/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryListener;

public class JpsLibraryRole
extends JpsElementChildRoleBase<JpsLibrary> {
    private static final JpsLibraryRole INSTANCE = new JpsLibraryRole();
    public static final JpsElementCollectionRole<JpsLibrary> LIBRARIES_COLLECTION_ROLE = JpsElementCollectionRole.create(INSTANCE);

    private JpsLibraryRole() {
        super("library");
    }

    @Override
    public void fireElementAdded(@NotNull JpsEventDispatcher dispatcher, @NotNull JpsLibrary element) {
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "org/jetbrains/jps/model/library/impl/JpsLibraryRole", "fireElementAdded"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/model/library/impl/JpsLibraryRole", "fireElementAdded"));
        }
        dispatcher.getPublisher(JpsLibraryListener.class).libraryAdded(element);
    }

    @Override
    public void fireElementRemoved(@NotNull JpsEventDispatcher dispatcher, @NotNull JpsLibrary element) {
        if (dispatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dispatcher", "org/jetbrains/jps/model/library/impl/JpsLibraryRole", "fireElementRemoved"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/model/library/impl/JpsLibraryRole", "fireElementRemoved"));
        }
        dispatcher.getPublisher(JpsLibraryListener.class).libraryRemoved(element);
    }
}

