/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.web.impl;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javaee.model.web.JpsWebRoot;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;

public class JpsWebRootImpl
extends JpsElementBase<JpsWebRootImpl>
implements JpsWebRoot {
    private static final JpsElementChildRole<JpsWebRoot> ROLE = JpsElementChildRoleBase.create((String)"web root");
    public static final JpsElementCollectionRole<JpsWebRoot> COLLECTION_ROLE = JpsElementCollectionRole.create(ROLE);
    private String myUrl;
    private String myRelativePath;

    public JpsWebRootImpl(String url, String relativePath) {
        this.myUrl = url;
        this.myRelativePath = relativePath;
    }

    private JpsWebRootImpl(JpsWebRootImpl original) {
        this.myUrl = original.myUrl;
        this.myRelativePath = original.myRelativePath;
    }

    @NotNull
    public JpsWebRootImpl createCopy() {
        JpsWebRootImpl jpsWebRootImpl = new JpsWebRootImpl(this);
        if (jpsWebRootImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/web/impl/JpsWebRootImpl", "createCopy"));
        }
        return jpsWebRootImpl;
    }

    public void applyChanges(@NotNull JpsWebRootImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/javaee/model/web/impl/JpsWebRootImpl", "applyChanges"));
        }
        this.setUrl(modified.myUrl);
        this.setRelativePath(modified.myRelativePath);
    }

    @Override
    public String getUrl() {
        return this.myUrl;
    }

    @Override
    public void setUrl(String url) {
        if (!Comparing.equal((String)this.myUrl, (String)url)) {
            this.myUrl = url;
            this.fireElementChanged();
        }
    }

    @Override
    public String getRelativePath() {
        return this.myRelativePath;
    }

    @Override
    public void setRelativePath(String relativePath) {
        if (!Comparing.equal((String)this.myRelativePath, (String)relativePath)) {
            this.myRelativePath = relativePath;
            this.fireElementChanged();
        }
    }
}

