/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtilRt {
    private static final int KILOBYTE = 1024;
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, FileUtilRt.getUserFileSizeLimit());
    private static final LoggerRt LOG = LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilLight");
    private static final int MAX_FILE_IO_ATTEMPTS = 10;
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
            }
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        return string;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        int index = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length());
        if (index < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
            }
            return "";
        }
        CharSequence charSequence = fileName.subSequence(index + 1, fileName.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        return charSequence;
    }

    public static boolean extensionEquals(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "extensionEquals"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/util/io/FileUtilRt", "extensionEquals"));
        }
        int extLen = extension.length();
        if (extLen == 0) {
            return fileName.indexOf(46) == -1;
        }
        int extStart = fileName.length() - extLen;
        return extStart >= 1 && fileName.charAt(extStart - 1) == '.' && fileName.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName, char separatorChar) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = fileName.replace('/', separatorChar).replace('\\', separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        String string = fileName.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        String filePathToCompare;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        String basePathToCompare = caseSensitive ? basePath : basePath.toLowerCase();
        String string = filePathToCompare = caseSensitive ? filePath : filePath.toLowerCase();
        if (basePathToCompare.equals(FileUtilRt.ensureEnds(filePathToCompare, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePathToCompare.charAt(len) == basePathToCompare.charAt(len); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/io/FileUtilRt", "ensureEnds"));
        }
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/io/FileUtilRt", "getNameWithoutExtension"));
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getNameWithoutExtension"));
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create directory: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(prefix, suffix, false);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete file: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file2;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean isDirectory) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
        }
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        int exceptionsCount = 0;
        while (true) {
            File file;
            try {
                File temp = FileUtilRt.createTemp(prefix, suffix, dir, isDirectory);
                file = FileUtilRt.normalizeFile(temp);
            }
            catch (IOException e) {
                if (++exceptionsCount < 100) continue;
                throw e;
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
            }
            return file;
        }
    }

    @NotNull
    private static File createTemp(@NotNull String prefix, @NotNull String suffix, @NotNull File directory, boolean isDirectory) throws IOException {
        boolean success;
        File f;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTemp"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/io/FileUtilRt", "createTemp"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/openapi/util/io/FileUtilRt", "createTemp"));
        }
        prefix = new File(prefix).getName();
        int i = 0;
        do {
            String name;
            if (!(name = prefix + i + suffix).equals((f = new File(directory, name)).getName())) {
                throw new IOException("Unable to create temporary file " + f + " for name " + name);
            }
            ++i;
        } while (f.exists());
        boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
        if (!success) {
            throw new IOException("Unable to create temporary file " + f);
        }
        File file = f;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTemp"));
        }
        return file;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        if (temp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temp", "com/intellij/openapi/util/io/FileUtilRt", "normalizeFile"));
        }
        File canonical = temp.getCanonicalFile();
        File file = SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "normalizeFile"));
        }
        return file;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string = ourCanonicalTempPathCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getTempDirectory"));
        }
        return string;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file;
        block4: {
            String string;
            file = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
            }
            return string;
        }
        String string = file.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
        }
        return string;
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        File file2 = FileUtilRt.normalizeFile(file);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "generateRandomTemporaryPath"));
        }
        return file2;
    }

    public static void setExecutableAttribute(@NotNull String path, boolean executableFlag) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "setExecutableAttribute"));
        }
        File file = new File(path);
        if (!file.setExecutable(executableFlag) && file.canExecute() != executableFlag) {
            LOG.warn("Can't set executable attribute of '" + path + "' to " + executableFlag);
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, null, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, null, convertLineSeparators);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, encoding, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        String string = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        char[] cArray = FileUtilRt.loadFileText(file, null);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block4: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
            }
            FileInputStream stream = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
            cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray != null) break block4;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            if (chars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
            }
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        if (newChars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
        }
        return newChars;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list = FileUtilRt.loadLines(file.getPath());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list = FileUtilRt.loadLines(file.getPath(), encoding);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list = FileUtilRt.loadLines(path, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable @NonNls String encoding) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        FileInputStream stream = new FileInputStream(path);
        InputStreamReader in = encoding == null ? new InputStreamReader(stream) : new InputStreamReader((InputStream)stream, encoding);
        BufferedReader reader = new BufferedReader(in);
        List<String> list = FileUtilRt.loadLines(reader);
        reader.close();
        List<String> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list2;
        {
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return arrayList;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] bytes = BUFFER.get();
        while ((n = stream.read(bytes, 0, bytes.length)) > 0) {
            buffer.write(bytes, 0, n);
        }
        buffer.close();
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return byArray;
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "getParentFile"));
        }
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file) {
        File[] files;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "delete"));
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                if (FileUtilRt.delete(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioTask", "com/intellij/openapi/util/io/FileUtilRt", "doIOOperation"));
        }
        for (int i = 10; i > 0; --i) {
            T result = ioTask.execute(i == 1);
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "deleteFile"));
        }
        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "ensureCanCreateFile"));
        }
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createIfNotExists"));
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            LOG.info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createParentDirs"));
        }
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "createDirectory"));
        }
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
        }
        if (toFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
        }
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            LOG.warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            LOG.warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block10: {
            int read;
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (outputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block10;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = BUFFER.get();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }

    public static int getUserFileSizeLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.intellisense.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }
}

