/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;

public class JpsLibraryCollectionImpl
implements JpsLibraryCollection {
    private final JpsElementCollection<JpsLibrary> myCollection;

    public JpsLibraryCollectionImpl(JpsElementCollection<JpsLibrary> collection) {
        this.myCollection = collection;
    }

    @Override
    @NotNull
    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(@NotNull String name, @NotNull LibraryType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        JpsTypedLibrary<JpsElement> jpsTypedLibrary = this.addLibrary(name, type, (JpsElement)((JpsElementTypeWithDefaultProperties<P>)type).createDefaultProperties());
        if (jpsTypedLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        return jpsTypedLibrary;
    }

    @Override
    @NotNull
    public <P extends JpsElement> JpsTypedLibrary<P> addLibrary(@NotNull String name, @NotNull JpsLibraryType<P> type, @NotNull P properties) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        JpsTypedLibrary jpsTypedLibrary = this.myCollection.addChild(new JpsLibraryImpl<P>(name, type, properties));
        if (jpsTypedLibrary == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        return jpsTypedLibrary;
    }

    @Override
    @NotNull
    public List<JpsLibrary> getLibraries() {
        List<JpsLibrary> list = this.myCollection.getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "getLibraries"));
        }
        return list;
    }

    @Override
    @NotNull
    public <P extends JpsElement> Iterable<JpsTypedLibrary<P>> getLibraries(@NotNull JpsLibraryType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "getLibraries"));
        }
        Iterable<JpsTypedLibrary<P>> iterable = this.myCollection.getElementsOfType(type);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "getLibraries"));
        }
        return iterable;
    }

    @Override
    public void addLibrary(@NotNull JpsLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "addLibrary"));
        }
        this.myCollection.addChild(library);
    }

    @Override
    public JpsLibrary findLibrary(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "findLibrary"));
        }
        for (JpsLibrary library : this.getLibraries()) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    @Override
    @Nullable
    public <E extends JpsElement> JpsTypedLibrary<E> findLibrary(@NotNull String name, @NotNull JpsLibraryType<E> type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "findLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jps/model/library/impl/JpsLibraryCollectionImpl", "findLibrary"));
        }
        for (JpsTypedLibrary<E> library : this.getLibraries(type)) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }
}

