/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.socksx.v4;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.socksx.v4.Socks4CmdStatus;
import io.netty.handler.codec.socksx.v4.Socks4Response;
import io.netty.util.NetUtil;
import java.net.IDN;

public final class Socks4CmdResponse
extends Socks4Response {
    private final Socks4CmdStatus cmdStatus;
    private final String host;
    private final int port;
    private static final byte[] IPv4_HOSTNAME_ZEROED = new byte[]{0, 0, 0, 0};

    public Socks4CmdResponse(Socks4CmdStatus cmdStatus) {
        this(cmdStatus, null, 0);
    }

    public Socks4CmdResponse(Socks4CmdStatus cmdStatus, String host, int port) {
        if (cmdStatus == null) {
            throw new NullPointerException("cmdStatus");
        }
        if (host != null && !NetUtil.isValidIpV4Address(host)) {
            throw new IllegalArgumentException(host + " is not a valid IPv4 address");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(port + " is not in bounds 0 <= x <= 65535");
        }
        this.cmdStatus = cmdStatus;
        this.host = host;
        this.port = port;
    }

    public Socks4CmdStatus cmdStatus() {
        return this.cmdStatus;
    }

    public String host() {
        if (this.host != null) {
            return IDN.toUnicode(this.host);
        }
        return null;
    }

    public int port() {
        return this.port;
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeZero(1);
        byteBuf.writeByte(this.cmdStatus.byteValue());
        byteBuf.writeShort(this.port);
        byte[] hostContent = this.host == null ? IPv4_HOSTNAME_ZEROED : NetUtil.createByteArrayFromIpAddressString(this.host);
        byteBuf.writeBytes(hostContent);
    }
}

