/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import java.util.concurrent.Future;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.build.common.GwtCompilerProcessHandlerBase;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.service.SharedThreadPool;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtExternalCompilerProcessHandler
extends GwtCompilerProcessHandlerBase {
    private final CompileContext myContext;

    public GwtExternalCompilerProcessHandler(Process process, String moduleFileUrl, CompileContext context) {
        super(process, moduleFileUrl);
        this.myContext = context;
    }

    protected Future<?> executeOnPooledThread(Runnable task) {
        return SharedThreadPool.getInstance().executeOnPooledThread(task);
    }

    @Override
    protected String findFileUrlByClassName(String className) {
        return null;
    }

    @Override
    protected boolean isCanceled() {
        return this.myContext.getCancelStatus().isCanceled();
    }

    @Override
    protected void reportMessage(String message, boolean isError, @Nullable String fileUrl, int lineNumber, int columnNum) {
        this.myContext.processMessage((BuildMessage)new CompilerMessage("GWT Compiler", isError ? BuildMessage.Kind.ERROR : BuildMessage.Kind.WARNING, message, fileUrl != null ? JpsPathUtil.urlToPath((String)fileUrl) : null, -1L, -1L, -1L, (long)lineNumber, (long)columnNum));
    }

    @Override
    protected void showProgressMessage(String message) {
        this.myContext.processMessage((BuildMessage)new ProgressMessage(message));
    }
}

