/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.internal.ObjectUtil;

public final class Http2Settings
extends IntObjectHashMap<Long> {
    public Http2Settings() {
        this(6);
    }

    public Http2Settings(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public Http2Settings(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public Long put(int key, Long value) {
        Http2Settings.verifyStandardSetting(key, value);
        return super.put(key, value);
    }

    public Long headerTableSize() {
        return (Long)this.get(1);
    }

    public Http2Settings headerTableSize(int value) {
        this.put(1, Long.valueOf(value));
        return this;
    }

    public Boolean pushEnabled() {
        Long value = (Long)this.get(2);
        if (value == null) {
            return null;
        }
        return value != 0L;
    }

    public Http2Settings pushEnabled(boolean enabled) {
        this.put(2, enabled ? 1L : 0L);
        return this;
    }

    public Long maxConcurrentStreams() {
        return (Long)this.get(3);
    }

    public Http2Settings maxConcurrentStreams(long value) {
        this.put(3, value);
        return this;
    }

    public Integer initialWindowSize() {
        return this.getIntValue(4);
    }

    public Http2Settings initialWindowSize(int value) {
        this.put(4, Long.valueOf(value));
        return this;
    }

    public Integer maxFrameSize() {
        return this.getIntValue(5);
    }

    public Http2Settings maxFrameSize(int value) {
        this.put(5, Long.valueOf(value));
        return this;
    }

    public Integer maxHeaderListSize() {
        return this.getIntValue(6);
    }

    public Http2Settings maxHeaderListSize(int value) {
        this.put(6, Long.valueOf(value));
        return this;
    }

    public Http2Settings copyFrom(Http2Settings settings) {
        this.clear();
        this.putAll(settings);
        return this;
    }

    Integer getIntValue(int key) {
        Long value = (Long)this.get(key);
        if (value == null) {
            return null;
        }
        return value.intValue();
    }

    private static void verifyStandardSetting(int key, Long value) {
        ObjectUtil.checkNotNull(value, "value");
        switch (key) {
            case 1: {
                if (value >= 0L && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting HEADER_TABLE_SIZE is invalid: " + value);
            }
            case 2: {
                if (value == 0L || value == 1L) break;
                throw new IllegalArgumentException("Setting ENABLE_PUSH is invalid: " + value);
            }
            case 3: {
                if (value >= 0L && value <= 0xFFFFFFFFL) break;
                throw new IllegalArgumentException("Setting MAX_CONCURRENT_STREAMS is invalid: " + value);
            }
            case 4: {
                if (value >= 0L && value <= Integer.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting INITIAL_WINDOW_SIZE is invalid: " + value);
            }
            case 5: {
                if (Http2CodecUtil.isMaxFrameSizeValid(value.intValue())) break;
                throw new IllegalArgumentException("Setting MAX_FRAME_SIZE is invalid: " + value);
            }
            case 6: {
                if (value >= 0L && value <= Long.MAX_VALUE) break;
                throw new IllegalArgumentException("Setting MAX_HEADER_LIST_SIZE is invalid: " + value);
            }
            default: {
                throw new IllegalArgumentException("key");
            }
        }
    }

    @Override
    protected String keyToString(int key) {
        switch (key) {
            case 1: {
                return "HEADER_TABLE_SIZE";
            }
            case 2: {
                return "ENABLE_PUSH";
            }
            case 3: {
                return "MAX_CONCURRENT_STREAMS";
            }
            case 4: {
                return "INITIAL_WINDOW_SIZE";
            }
            case 5: {
                return "MAX_FRAME_SIZE";
            }
            case 6: {
                return "MAX_HEADER_LIST_SIZE";
            }
        }
        return super.keyToString(key);
    }
}

