/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.instrumentation;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public abstract class ClassProcessingBuilder
extends ModuleLevelBuilder {
    private static final Key<InstrumentationClassFinder> CLASS_FINDER = Key.create((String)"_cached_instrumentation_class_finder_");

    public ClassProcessingBuilder(BuilderCategory category) {
        super(category);
    }

    protected abstract boolean isEnabled(CompileContext var1, ModuleChunk var2);

    protected abstract String getProgressMessage();

    @Override
    public void chunkBuildFinished(CompileContext context, ModuleChunk chunk) {
        InstrumentationClassFinder finder = (InstrumentationClassFinder)CLASS_FINDER.get((UserDataHolder)context);
        if (finder != null) {
            CLASS_FINDER.set((UserDataHolder)context, null);
            finder.releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        boolean shouldShowProgress;
        if (outputConsumer.getCompiledClasses().isEmpty() || !this.isEnabled(context, chunk)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        String progress = this.getProgressMessage();
        boolean bl = shouldShowProgress = !StringUtil.isEmptyOrSpaces((String)progress);
        if (shouldShowProgress) {
            context.processMessage(new ProgressMessage(progress + " [" + chunk.getPresentableShortName() + "]"));
        }
        ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        try {
            InstrumentationClassFinder finder = (InstrumentationClassFinder)CLASS_FINDER.get((UserDataHolder)context);
            if (finder == null) {
                Collection<File> platformCp = ProjectPaths.getPlatformCompilationClasspath(chunk, false);
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.addAll(ProjectPaths.getCompilationClasspath(chunk, false));
                classpath.addAll(ProjectPaths.getSourceRootsWithDependents(chunk).keySet());
                finder = ClassProcessingBuilder.createInstrumentationClassFinder(platformCp, classpath, outputConsumer);
                CLASS_FINDER.set((UserDataHolder)context, (Object)finder);
            }
            exitCode = this.performBuild(context, chunk, finder, outputConsumer);
        }
        finally {
            if (shouldShowProgress) {
                context.processMessage(new ProgressMessage(""));
            }
        }
        return exitCode;
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    protected abstract ModuleLevelBuilder.ExitCode performBuild(CompileContext var1, ModuleChunk var2, InstrumentationClassFinder var3, ModuleLevelBuilder.OutputConsumer var4);

    public static InstrumentationClassFinder createInstrumentationClassFinder(Collection<File> platformCp, Collection<File> cp, final ModuleLevelBuilder.OutputConsumer outputConsumer) throws MalformedURLException {
        URL[] platformUrls = new URL[platformCp.size()];
        int index = 0;
        for (File file : platformCp) {
            platformUrls[index++] = file.toURI().toURL();
        }
        URL[] urls = new URL[cp.size()];
        index = 0;
        for (File file : cp) {
            urls[index++] = file.toURI().toURL();
        }
        return new InstrumentationClassFinder(platformUrls, urls){

            @Override
            protected InputStream lookupClassBeforeClasspath(String internalClassName) {
                BinaryContent content = outputConsumer.lookupClassBytes(internalClassName.replace("/", "."));
                if (content != null) {
                    return new ByteArrayInputStream(content.getBuffer(), content.getOffset(), content.getLength());
                }
                return null;
            }
        };
    }

    public static int getAsmClassWriterFlags(int version) {
        return version >= 50 && version != 196653 ? 2 : 1;
    }

    public static int getClassFileVersion(ClassReader reader) {
        final Ref result = new Ref((Object)0);
        reader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                result.set((Object)version);
            }
        }, 7);
        return (Integer)result.get();
    }
}

