/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.osgi.jps.build.BndWrapper;
import org.jetbrains.osgi.jps.build.BundlorWrapper;
import org.jetbrains.osgi.jps.build.CachingBundleInfoProvider;
import org.jetbrains.osgi.jps.build.LocalPackageCollector;
import org.jetbrains.osgi.jps.build.OsgiBuildException;
import org.jetbrains.osgi.jps.build.OsmorcBuildTarget;
import org.jetbrains.osgi.jps.build.Reporter;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;
import org.jetbrains.osgi.jps.model.LibraryBundlificationRule;
import org.jetbrains.osgi.jps.model.OsmorcJarContentEntry;
import org.jetbrains.osgi.jps.util.OsgiBuildUtil;

public class OsgiBuildSession
implements Reporter {
    private static final Logger LOG = Logger.getInstance(OsgiBuildSession.class);
    private static final Condition<JpsDependencyElement> NOT_FRAMEWORK_LIBRARY_CONDITION = new Condition<JpsDependencyElement>(){

        public boolean value(JpsDependencyElement entry) {
            JpsLibraryDependency libEntry;
            String libraryName;
            return !(entry instanceof JpsLibraryDependency) || !(libraryName = (libEntry = (JpsLibraryDependency)entry).getLibraryReference().getLibraryName()).startsWith("Osmorc:");
        }
    };
    private CompileContext myContext;
    private JpsOsmorcModuleExtension myExtension;
    private JpsModule myModule;
    private String myMessagePrefix;
    private File myOutputJarFile;
    private File myModuleOutputDir;
    private File myOutputDir;
    private File[] myClasses;
    private File[] mySources;
    private BndWrapper myBndWrapper;
    private String mySourceToReport = null;

    public void build(@NotNull OsmorcBuildTarget target, @NotNull CompileContext context) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "build"));
        }
        this.myContext = context;
        this.myExtension = target.getExtension();
        this.myModule = target.getModule();
        this.myMessagePrefix = "[" + this.myModule.getName() + "] ";
        this.progress("Building OSGi bundle");
        try {
            this.prepare();
            this.doBuild();
        }
        catch (OsgiBuildException e) {
            this.error(e.getMessage(), e.getCause(), e.getSourcePath());
            return;
        }
        if (!this.myOutputJarFile.exists()) {
            this.error("Bundle was not built", null, null);
            return;
        }
        ProjectBuilderLogger logger = context.getLoggingManager().getProjectBuilderLogger();
        if (logger.isEnabled()) {
            logger.logCompiledFiles(Collections.singleton(this.myOutputJarFile), "osgi", "Built OSGi bundles:");
        }
        context.processMessage((BuildMessage)DoneSomethingNotification.INSTANCE);
    }

    private void prepare() throws OsgiBuildException {
        this.myModuleOutputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(this.myModule, false);
        if (this.myModuleOutputDir == null) {
            throw new OsgiBuildException("Unable to determine the compiler output path for the module.");
        }
        String jarFileLocation = this.myExtension.getJarFileLocation();
        if (jarFileLocation.isEmpty()) {
            throw new OsgiBuildException("Bundle path is empty - please check OSGi facet settings.");
        }
        this.myOutputJarFile = new File(jarFileLocation);
        if (!FileUtil.delete((File)this.myOutputJarFile)) {
            throw new OsgiBuildException("Can't delete bundle file '" + this.myOutputJarFile + "'.");
        }
        if (!FileUtil.createParentDirs((File)this.myOutputJarFile)) {
            throw new OsgiBuildException("Cannot create directory for bundle file '" + this.myOutputJarFile + "'.");
        }
        List classes = ContainerUtil.newSmartList((Object)this.myModuleOutputDir);
        for (JpsDependencyElement dependency : this.myModule.getDependenciesList().getDependencies()) {
            File outputDir;
            JpsModule module;
            if (!(dependency instanceof JpsModuleDependency) || (module = ((JpsModuleDependency)dependency).getModule()) == null || JpsOsmorcExtensionService.getExtension(module) != null || (outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(module, false)) == null) continue;
            classes.add(outputDir);
        }
        this.myClasses = classes.toArray(new File[classes.size()]);
        this.mySources = (File[])ContainerUtil.map2Array((Collection)this.myModule.getSourceRoots(), File.class, (Function)new Function<JpsModuleSourceRoot, File>(){

            public File fun(JpsModuleSourceRoot root) {
                return root.getFile();
            }
        });
        this.myOutputDir = BndWrapper.getOutputDir(this.myModuleOutputDir);
        this.myBndWrapper = new BndWrapper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuild() throws OsgiBuildException {
        this.progress("Running Bnd to build the bundle");
        if (this.myExtension.isUseBndFile()) {
            String bndPath = this.myExtension.getBndFileLocation();
            File bndFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, bndPath);
            if (bndFile == null || !bndFile.canRead()) {
                throw new OsgiBuildException("Bnd file missing '" + bndPath + "' - please check OSGi facet settings.");
            }
            this.mySourceToReport = bndFile.getAbsolutePath();
            try {
                this.myBndWrapper.build(bndFile, this.myClasses, this.mySources, this.myOutputJarFile);
            }
            catch (Exception e) {
                throw new OsgiBuildException("Unexpected build error", e, null);
            }
            this.mySourceToReport = null;
        } else {
            if (this.myExtension.isUseBundlorFile()) {
                Properties properties;
                String bundlorPath = this.myExtension.getBundlorFileLocation();
                File bundlorFile = OsgiBuildUtil.findFileInModuleContentRoots(this.myModule, bundlorPath);
                if (bundlorFile == null) {
                    throw new OsgiBuildException("Bundlor file missing '" + bundlorPath + "' - please check OSGi facet settings.");
                }
                File tempFile = new File(this.myOutputJarFile.getAbsolutePath() + ".tmp.jar");
                try {
                    properties = Collections.singletonMap("Created-By", "IntelliJ IDEA / OSGi Plugin");
                    this.myBndWrapper.build(properties, this.myClasses, this.mySources, tempFile);
                }
                catch (Exception e) {
                    throw new OsgiBuildException("Unexpected build error", e, null);
                }
                this.progress("Running Bundlor to calculate the manifest");
                try {
                    properties = OsgiBuildUtil.getMavenProjectProperties(this.myContext, this.myModule);
                    List<String> warnings = new BundlorWrapper().wrapModule(properties, tempFile, this.myOutputJarFile, bundlorFile);
                    for (String warning : warnings) {
                        this.warning(warning, null, bundlorFile.getPath());
                    }
                }
                finally {
                    if (!FileUtil.delete((File)tempFile)) {
                        this.warning("Can't delete temporary file '" + tempFile + "'", null, null);
                    }
                }
            }
            Map<String, String> buildProperties = this.getBuildProperties();
            if (LOG.isDebugEnabled()) {
                LOG.debug("build properties: " + buildProperties);
            }
            this.mySourceToReport = this.getSourceFileToReport();
            try {
                this.myBndWrapper.build(buildProperties, this.myClasses, this.mySources, this.myOutputJarFile);
            }
            catch (Exception e) {
                throw new OsgiBuildException("Unexpected build error", e, null);
            }
            this.mySourceToReport = null;
            this.progress("Bundling non-OSGi libraries");
            this.bundlifyLibraries();
        }
    }

    @NotNull
    private Map<String, String> getBuildProperties() throws OsgiBuildException {
        if (this.myExtension.isManifestManuallyEdited() || this.myExtension.isOsmorcControlsManifest()) {
            StringBuilder includedResources;
            HashMap properties = ContainerUtil.newHashMap();
            properties.put("Import-Package", "*");
            properties.put("-removeheaders", "Include-Resource,Private-Package");
            properties.put("Created-By", "IntelliJ IDEA / OSGi Plugin");
            if (this.myExtension.isOsmorcControlsManifest()) {
                properties.putAll(this.myExtension.getAdditionalProperties());
                properties.put("Bundle-SymbolicName", this.myExtension.getBundleSymbolicName());
                properties.put("Bundle-Version", this.myExtension.getBundleVersion());
                String activator = this.myExtension.getBundleActivator();
                if (!StringUtil.isEmptyOrSpaces((String)activator)) {
                    properties.put("Bundle-Activator", activator);
                }
            } else {
                File manifestFile = this.myExtension.getManifestFile();
                if (manifestFile == null) {
                    throw new OsgiBuildException("Manifest file '" + this.myExtension.getManifestLocation() + "' missing - please check OSGi facet settings.");
                }
                properties.put("-manifest", manifestFile.getAbsolutePath());
            }
            StringBuilder pathBuilder = new StringBuilder(this.myModuleOutputDir.getPath());
            for (OsmorcJarContentEntry contentEntry : this.myExtension.getAdditionalJarContents()) {
                pathBuilder.append(',').append(contentEntry.myDestination).append('=').append(contentEntry.mySource);
            }
            if (this.myExtension.isOsmorcControlsManifest()) {
                includedResources = new StringBuilder();
                String resources = (String)properties.get("Include-Resource");
                if (resources != null) {
                    includedResources.append(resources).append(',');
                }
                includedResources.append((CharSequence)pathBuilder);
            } else {
                includedResources = pathBuilder;
            }
            properties.put("Include-Resource", includedResources.toString());
            String pattern = this.myExtension.getIgnoreFilePattern();
            if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
                try {
                    Pattern.compile(pattern);
                }
                catch (PatternSyntaxException e) {
                    throw new OsgiBuildException("The file ignore pattern is invalid - please check OSGi facet settings.");
                }
                properties.put("-donotcopy", pattern);
            }
            if (this.myExtension.isOsmorcControlsManifest()) {
                this.progress("Calculating local packages");
                LocalPackageCollector.addLocalPackages(this.myModuleOutputDir, properties);
            }
            HashMap hashMap = properties;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "getBuildProperties"));
            }
            return hashMap;
        }
        throw new OsgiBuildException("Bundle creation method not specified - please check OSGi facet settings.");
    }

    private String getSourceFileToReport() {
        if (this.myExtension.isManifestManuallyEdited()) {
            File manifestFile = this.myExtension.getManifestFile();
            if (manifestFile != null) {
                return manifestFile.getPath();
            }
        } else {
            File mavenProjectFile = OsgiBuildUtil.getMavenProjectPath(this.myContext, this.myModule);
            if (mavenProjectFile != null) {
                return mavenProjectFile.getPath();
            }
        }
        return null;
    }

    @NotNull
    private List<String> bundlifyLibraries() {
        List<LibraryBundlificationRule> libRules = JpsOsmorcExtensionService.getInstance().getLibraryBundlificationRules();
        Collection dependencies = JpsJavaExtensionService.getInstance().enumerateDependencies(Collections.singletonList(this.myModule)).withoutSdk().withoutModuleSourceEntries().withoutDepModules().productionOnly().runtimeOnly().recursively().exportedOnly().satisfying(NOT_FRAMEWORK_LIBRARY_CONDITION).classes().getRoots();
        ArrayList result = ContainerUtil.newArrayList();
        for (File dependency : dependencies) {
            String path = dependency.getPath();
            if (CachingBundleInfoProvider.canBeBundlified(path)) {
                try {
                    File bundledDependency = this.myBndWrapper.wrapLibrary(dependency, this.myOutputDir, libRules);
                    if (bundledDependency == null) continue;
                    result.add(bundledDependency.getPath());
                }
                catch (OsgiBuildException e) {
                    this.warning(e.getMessage(), e.getCause(), e.getSourcePath());
                }
                continue;
            }
            if (!CachingBundleInfoProvider.isBundle(path)) continue;
            result.add(path);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "bundlifyLibraries"));
        }
        return arrayList;
    }

    @Override
    public void progress(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "progress"));
        }
        this.myContext.processMessage((BuildMessage)new ProgressMessage(this.myMessagePrefix + message));
    }

    @Override
    public void warning(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "warning"));
        }
        LOG.warn(message, t);
        if (sourcePath == null) {
            sourcePath = this.mySourceToReport;
        }
        this.myContext.processMessage((BuildMessage)new CompilerMessage("osgi", BuildMessage.Kind.WARNING, this.myMessagePrefix + message, sourcePath));
    }

    @Override
    public void error(@NotNull String message, @Nullable Throwable t, @Nullable String sourcePath) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/osgi/jps/build/OsgiBuildSession", "error"));
        }
        LOG.warn(message, t);
        if (sourcePath == null) {
            sourcePath = this.mySourceToReport;
        }
        this.myContext.processMessage((BuildMessage)new CompilerMessage("osgi", BuildMessage.Kind.ERROR, this.myMessagePrefix + message, sourcePath));
    }
}

