/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.Utils;

final class FilesDelta {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.fs.FilesDelta");
    private final Set<String> myDeletedPaths = Collections.synchronizedSet(new THashSet(FileUtil.PATH_HASHING_STRATEGY));
    private final Map<BuildRootDescriptor, Set<File>> myFilesToRecompile = Collections.synchronizedMap(new HashMap());

    FilesDelta() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAll(FilesDelta other) {
        Map<BuildRootDescriptor, Set<File>> dataToAdd;
        this.myDeletedPaths.addAll(other.myDeletedPaths);
        Map<BuildRootDescriptor, Set<File>> map = dataToAdd = other.myFilesToRecompile;
        synchronized (map) {
            for (Map.Entry<BuildRootDescriptor, Set<File>> entry : dataToAdd.entrySet()) {
                this._addToRecompiled(entry.getKey(), (Collection<File>)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myDeletedPaths.size());
        Object object = this.myDeletedPaths;
        synchronized (object) {
            for (String string : this.myDeletedPaths) {
                IOUtil.writeString((String)string, (DataOutput)out);
            }
        }
        object = this.myFilesToRecompile;
        synchronized (object) {
            out.writeInt(this.myFilesToRecompile.size());
            for (Map.Entry entry : this.myFilesToRecompile.entrySet()) {
                IOUtil.writeString((String)((BuildRootDescriptor)entry.getKey()).getRootId(), (DataOutput)out);
                Set files = (Set)entry.getValue();
                out.writeInt(files.size());
                for (File file : files) {
                    IOUtil.writeString((String)FileUtil.toSystemIndependentName((String)file.getPath()), (DataOutput)out);
                }
            }
        }
    }

    public void load(DataInput in, @NotNull BuildTarget<?> target, BuildRootIndex buildRootIndex) throws IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/incremental/fs/FilesDelta", "load"));
        }
        this.myDeletedPaths.clear();
        int deletedCount = in.readInt();
        while (deletedCount-- > 0) {
            this.myDeletedPaths.add(IOUtil.readString((DataInput)in));
        }
        this.myFilesToRecompile.clear();
        int recompileCount = in.readInt();
        while (recompileCount-- > 0) {
            THashSet files;
            String rootId = IOUtil.readString((DataInput)in);
            Object descriptor = target.findRootDescriptor(rootId, buildRootIndex);
            if (descriptor != null) {
                files = this.myFilesToRecompile.get(descriptor);
                if (files == null) {
                    files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    this.myFilesToRecompile.put((BuildRootDescriptor)descriptor, (Set<File>)files);
                }
            } else {
                LOG.debug("Cannot find root by " + rootId + ", delta will be skipped");
                files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            }
            int filesCount = in.readInt();
            while (filesCount-- > 0) {
                File file = new File(IOUtil.readString((DataInput)in));
                if (Utils.IS_TEST_MODE) {
                    LOG.info("Loaded " + file.getPath());
                }
                files.add(file);
            }
        }
    }

    public static void skip(DataInput in) throws IOException {
        int deletedCount = in.readInt();
        while (deletedCount-- > 0) {
            IOUtil.readString((DataInput)in);
        }
        int recompiledCount = in.readInt();
        while (recompiledCount-- > 0) {
            IOUtil.readString((DataInput)in);
            int filesCount = in.readInt();
            while (filesCount-- > 0) {
                IOUtil.readString((DataInput)in);
            }
        }
    }

    public boolean hasChanges() {
        return this.hasPathsToDelete() || this.hasSourcesToRecompile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompile(BuildRootDescriptor root, File file) {
        boolean added = this._addToRecompiled(root, file);
        if (added) {
            Set<String> set = this.myDeletedPaths;
            synchronized (set) {
                if (!this.myDeletedPaths.isEmpty()) {
                    this.myDeletedPaths.remove(FileUtil.toCanonicalPath((String)file.getPath()));
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean markRecompileIfNotDeleted(BuildRootDescriptor root, File file) {
        boolean isMarkedDeleted;
        Set<String> set = this.myDeletedPaths;
        synchronized (set) {
            isMarkedDeleted = !this.myDeletedPaths.isEmpty() && this.myDeletedPaths.contains(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        if (!isMarkedDeleted) {
            this._addToRecompiled(root, file);
            return true;
        }
        return false;
    }

    private boolean _addToRecompiled(BuildRootDescriptor root, File file) {
        if (Utils.IS_TEST_MODE) {
            LOG.info("Marking dirty: " + file.getPath());
        }
        return this._addToRecompiled(root, Collections.singleton(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addToRecompiled(BuildRootDescriptor root, Collection<File> filesToAdd) {
        Map<BuildRootDescriptor, Set<File>> map = this.myFilesToRecompile;
        synchronized (map) {
            THashSet files = this.myFilesToRecompile.get(root);
            if (files == null) {
                files = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                this.myFilesToRecompile.put(root, (Set<File>)files);
            }
            return files.addAll(filesToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleted(File file) {
        Map<BuildRootDescriptor, Set<File>> map = this.myFilesToRecompile;
        synchronized (map) {
            for (Set<File> files : this.myFilesToRecompile.values()) {
                files.remove(file);
            }
        }
        String path = FileUtil.toCanonicalPath((String)file.getPath());
        this.myDeletedPaths.add(path);
        if (Utils.IS_TEST_MODE) {
            LOG.info("Marking deleted: " + path);
        }
    }

    public void clearDeletedPaths() {
        this.myDeletedPaths.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAndClearDeletedPaths() {
        Set<String> set = this.myDeletedPaths;
        synchronized (set) {
            THashSet tHashSet;
            try {
                THashSet _paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                _paths.addAll(this.myDeletedPaths);
                tHashSet = _paths;
                this.myDeletedPaths.clear();
            }
            catch (Throwable throwable) {
                this.myDeletedPaths.clear();
                throw throwable;
            }
            return tHashSet;
        }
    }

    public Map<BuildRootDescriptor, Set<File>> getSourcesToRecompile() {
        return this.myFilesToRecompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSourcesToRecompile() {
        Map<BuildRootDescriptor, Set<File>> map = this.myFilesToRecompile;
        synchronized (map) {
            if (!this.myFilesToRecompile.isEmpty()) {
                for (Set<File> files : this.myFilesToRecompile.values()) {
                    if (files.isEmpty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasPathsToDelete() {
        return !this.myDeletedPaths.isEmpty();
    }

    @Nullable
    public Set<File> clearRecompile(BuildRootDescriptor root) {
        return this.myFilesToRecompile.remove(root);
    }
}

