/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.build;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.ant.execution.AntMain2;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.build.AntBuildTaskListener;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntExtensionService;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.ant.model.artifacts.JpsAntArtifactExtension;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public class AntArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    private static final Logger LOG = Logger.getInstance(AntArtifactBuildTaskProvider.class);

    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        if (buildPhase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildPhase", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        JpsAntArtifactExtension extension = AntArtifactBuildTaskProvider.getBuildExtension(artifact, buildPhase);
        if (extension != null && extension.isEnabled() && !StringUtil.isEmpty((String)extension.getFileUrl())) {
            List<AntArtifactBuildTask> list = Collections.singletonList(new AntArtifactBuildTask(extension));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider", "createArtifactBuildTasks"));
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider", "createArtifactBuildTasks"));
        }
        return list;
    }

    @Nullable
    private static JpsAntArtifactExtension getBuildExtension(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        switch (buildPhase) {
            case PRE_PROCESSING: {
                return JpsAntExtensionService.getPreprocessingExtension(artifact);
            }
            case POST_PROCESSING: {
                return JpsAntExtensionService.getPostprocessingExtension(artifact);
            }
        }
        return null;
    }

    private static class AntArtifactBuildTask
    extends BuildTask {
        public static final String BUILDER_NAME = "ant";
        private final JpsAntArtifactExtension myExtension;

        public AntArtifactBuildTask(@NotNull JpsAntArtifactExtension extension) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider$AntArtifactBuildTask", "<init>"));
            }
            this.myExtension = extension;
        }

        public void build(final CompileContext context) throws ProjectBuildException {
            JpsTypedLibrary jdkLibrary;
            JpsProject project = context.getProjectDescriptor().getProject();
            JpsAntBuildFileOptions options = JpsAntExtensionService.getOptions(project, this.myExtension.getFileUrl());
            String jdkName = options.getCustomJdkName();
            if (!StringUtil.isEmpty((String)jdkName)) {
                jdkLibrary = project.getModel().getGlobal().getLibraryCollection().findLibrary(jdkName, (JpsLibraryType)JpsJavaSdkType.INSTANCE);
                if (jdkLibrary == null) {
                    this.reportError(context, "JDK '" + jdkName + "' not found");
                    throw new StopBuildException();
                }
            } else {
                JpsSdkReference reference = project.getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
                if (reference == null) {
                    this.reportError(context, "project JDK is not specified");
                    throw new StopBuildException();
                }
                jdkLibrary = (JpsTypedLibrary)reference.resolve();
                if (jdkLibrary == null) {
                    this.reportError(context, "JDK '" + reference.getSdkName() + "' not found");
                    throw new StopBuildException();
                }
            }
            JpsSdk jdk = (JpsSdk)jdkLibrary.getProperties();
            JpsAntInstallation antInstallation = JpsAntExtensionService.getAntInstallationForBuildFile(context.getProjectDescriptor().getModel(), this.myExtension.getFileUrl());
            if (antInstallation == null) {
                this.reportError(context, "Ant installation is not configured");
                throw new StopBuildException();
            }
            ArrayList<String> classpath = new ArrayList<String>();
            File jreHome = new File(jdk.getHomePath(), "jre");
            for (File file : jdkLibrary.getFiles(JpsOrderRootType.COMPILED)) {
                if (FileUtil.isAncestor((File)jreHome, (File)file, (boolean)false)) continue;
                classpath.add(file.getAbsolutePath());
            }
            classpath.addAll(options.getAdditionalClasspath());
            classpath.addAll(antInstallation.getClasspath());
            JpsAntInstallationImpl.addAllJarsFromDirectory(classpath, new File(SystemProperties.getUserHome(), ".ant/lib"));
            classpath.add(PathManager.getJarPathForClass(AntMain2.class));
            ArrayList<String> vmParams = new ArrayList<String>();
            vmParams.add("-Xmx" + options.getMaxHeapSize() + "m");
            vmParams.add("-Xss" + options.getMaxStackSize() + "m");
            vmParams.add("-Dant.home=" + antInstallation.getAntHome().getAbsolutePath());
            ArrayList<String> programParams = new ArrayList<String>();
            for (String param : ParametersListUtil.parse((String)options.getAntCommandLineParameters())) {
                if (param.startsWith("-J")) {
                    String vmParam = StringUtil.trimStart((String)param, (String)"-J");
                    if (vmParam.isEmpty()) continue;
                    vmParams.add(vmParam);
                    continue;
                }
                programParams.add(param);
            }
            for (List properties : Arrays.asList(this.myExtension.getAntProperties(), options.getProperties())) {
                for (BuildFileProperty property : properties) {
                    programParams.add("-D" + property.getPropertyName() + "=" + property.getPropertyValue());
                }
            }
            programParams.add("-buildfile");
            final String buildFilePath = JpsPathUtil.urlToPath((String)this.myExtension.getFileUrl());
            programParams.add(buildFilePath);
            final String targetName = this.myExtension.getTargetName();
            if (targetName != null) {
                programParams.add(targetName);
            }
            context.processMessage((BuildMessage)new ProgressMessage("Running " + (targetName != null ? "'" + targetName + "'" : "default") + " Ant target from '" + PathUtilRt.getFileName((String)buildFilePath) + "' file..."));
            Iterable listeners = JpsServiceManager.getInstance().getExtensions(AntBuildTaskListener.class);
            for (AntBuildTaskListener listener : listeners) {
                listener.beforeAntBuildTaskStarted(this.myExtension, vmParams, programParams);
            }
            List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)JpsJavaSdkType.getJavaExecutable((JpsSdk)jdk), (String)AntMain2.class.getName(), Collections.emptyList(), classpath, vmParams, programParams, (boolean)false);
            try {
                Process process = new ProcessBuilder(commandLine).directory(new File(buildFilePath).getParentFile()).start();
                String commandLineString = StringUtil.join((Collection)commandLine, (String)" ");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting ant target:" + commandLineString);
                }
                BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commandLineString, null);
                final AtomicBoolean hasErrors = new AtomicBoolean();
                final StringBuilder errorOutput = new StringBuilder();
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDERR) {
                            errorOutput.append(event.getText());
                        }
                    }

                    public void processTerminated(ProcessEvent event) {
                        int exitCode = event.getExitCode();
                        if (exitCode != 0) {
                            context.processMessage((BuildMessage)new CompilerMessage(AntArtifactBuildTask.BUILDER_NAME, BuildMessage.Kind.ERROR, errorOutput.toString()));
                            context.processMessage((BuildMessage)new CompilerMessage(AntArtifactBuildTask.BUILDER_NAME, BuildMessage.Kind.ERROR, "target '" + targetName + "' in '" + buildFilePath + "' finished with exit code " + exitCode));
                            hasErrors.set(true);
                        }
                    }
                });
                handler.startNotify();
                handler.waitFor();
                if (hasErrors.get()) {
                    throw new StopBuildException();
                }
            }
            catch (IOException e) {
                throw new ProjectBuildException((Throwable)e);
            }
        }

        private void reportError(CompileContext context, String text) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, "Cannot run '" + this.myExtension.getTargetName() + "' target: " + text));
        }
    }
}

