/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexCompilerConfigFileUtilBase;
import com.intellij.flex.model.JpsFlexProjectLevelCompilerOptionsExtension;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.CompilerOptionInfo;
import com.intellij.flex.model.bc.InfoFromConfigFile;
import com.intellij.flex.model.bc.JpsAirDesktopPackagingOptions;
import com.intellij.flex.model.bc.JpsAndroidPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBCDependencyEntry;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.JpsFlexModuleOrProjectCompilerOptions;
import com.intellij.flex.model.bc.JpsIosPackagingOptions;
import com.intellij.flex.model.bc.JpsLibraryDependencyEntry;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.flex.model.bc.ValueSource;
import com.intellij.flex.model.sdk.JpsFlexmojosSdkType;
import com.intellij.flex.model.sdk.RslUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class CompilerConfigGeneratorRt {
    private static final String[] LIB_ORDER = new String[]{"framework", "textLayout", "osmf", "spark", "sparkskins", "rpc", "charts", "spark_dmv", "mx", "advancedgrids"};
    private final JpsModule myModule;
    private final JpsFlexBuildConfiguration myBC;
    private final boolean myFlexUnit;
    private final boolean myCSS;
    private final JpsSdk<?> mySdk;
    private final boolean myFlexmojos;
    private final JpsFlexModuleOrProjectCompilerOptions myModuleLevelCompilerOptions;
    private final JpsFlexModuleOrProjectCompilerOptions myProjectLevelCompilerOptions;
    private final ProjectDescriptor myProjectDescriptor;

    private CompilerConfigGeneratorRt(@NotNull JpsFlexBuildConfiguration bc, @NotNull JpsFlexModuleOrProjectCompilerOptions moduleLevelCompilerOptions, @NotNull JpsFlexModuleOrProjectCompilerOptions projectLevelCompilerOptions, @NotNull ProjectDescriptor projectDescriptor) throws IOException {
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/flex/build/CompilerConfigGeneratorRt", "<init>"));
        }
        if (moduleLevelCompilerOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleLevelCompilerOptions", "com/intellij/flex/build/CompilerConfigGeneratorRt", "<init>"));
        }
        if (projectLevelCompilerOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectLevelCompilerOptions", "com/intellij/flex/build/CompilerConfigGeneratorRt", "<init>"));
        }
        if (projectDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDescriptor", "com/intellij/flex/build/CompilerConfigGeneratorRt", "<init>"));
        }
        this.myProjectDescriptor = projectDescriptor;
        this.myModule = bc.getModule();
        this.myBC = bc;
        this.myFlexUnit = FlexCommonUtils.isFlexUnitBC(this.myBC);
        this.myCSS = FlexCommonUtils.isRuntimeStyleSheetBC(bc);
        this.mySdk = bc.getSdk();
        if (this.mySdk == null) {
            throw new IOException(FlexCommonBundle.message("sdk.not.set.for.bc.0.of.module.1", bc.getName(), bc.getModule().getName()));
        }
        this.myFlexmojos = this.mySdk.getSdkType() == JpsFlexmojosSdkType.INSTANCE;
        this.myModuleLevelCompilerOptions = moduleLevelCompilerOptions;
        this.myProjectLevelCompilerOptions = projectLevelCompilerOptions;
    }

    public static File getOrCreateConfigFile(JpsFlexBuildConfiguration bc, ProjectDescriptor projectDescriptor) throws IOException {
        CompilerConfigGeneratorRt generator = new CompilerConfigGeneratorRt(bc, ((JpsFlexBuildConfigurationManager)bc.getModule().getProperties()).getModuleLevelCompilerOptions(), JpsFlexProjectLevelCompilerOptionsExtension.getProjectLevelCompilerOptions(bc.getModule().getProject()), projectDescriptor);
        String text = generator.generateConfigFileText();
        if (bc.isTempBCForCompilation()) {
            JpsFlexBuildConfiguration originalBC = ((JpsFlexBuildConfigurationManager)bc.getModule().getProperties()).findConfigurationByName(bc.getName());
            boolean makeExternalLibsMerged = FlexCommonUtils.isFlexUnitBC(bc) || originalBC != null && originalBC.getOutputType() == OutputType.Library;
            boolean makeIncludedLibsMerged = FlexCommonUtils.isRuntimeStyleSheetBC(bc);
            text = FlexCompilerConfigFileUtilBase.mergeWithCustomConfigFile(text, bc.getCompilerOptions().getAdditionalConfigFilePath(), makeExternalLibsMerged, makeIncludedLibsMerged);
        }
        String name = CompilerConfigGeneratorRt.getConfigFileName(bc, FlexCommonUtils.getBCSpecifier(bc));
        return CompilerConfigGeneratorRt.getOrCreateConfigFile(name, text);
    }

    private String generateConfigFileText() throws IOException {
        Element rootElement = new Element("flex-config", "http://www.adobe.com/2006/flex-config");
        this.addMandatoryOptions(rootElement);
        this.addSourcePaths(rootElement);
        if (!this.myFlexmojos) {
            this.handleOptionsWithSpecialValues(rootElement);
            this.addNamespaces(rootElement);
            this.addRootsFromSdk(rootElement);
        }
        this.addLibs(rootElement);
        this.addOtherOptions(rootElement);
        this.addInputOutputPaths(rootElement);
        return JDOMUtil.writeElement((Element)rootElement, (String)"\n");
    }

    private void addMandatoryOptions(Element rootElement) {
        if (!FlexCommonUtils.isRLMTemporaryBC(this.myBC) && !FlexCommonUtils.isRuntimeStyleSheetBC(this.myBC) && FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets(this.myBC) && this.myBC.getRLMs().size() > 0) {
            this.addOption(rootElement, CompilerOptionInfo.LINK_REPORT_INFO, CompilerConfigGeneratorRt.getLinkReportFilePath(this.myBC));
        }
        if (FlexCommonUtils.isRLMTemporaryBC(this.myBC) && !this.myBC.getOptimizeFor().isEmpty()) {
            String customLinkReportPath = CompilerConfigGeneratorRt.getCustomLinkReportPath(this.myBC);
            String linkReportPath = StringUtil.notNullize((String)customLinkReportPath, (String)CompilerConfigGeneratorRt.getLinkReportFilePath(this.myBC));
            this.addOption(rootElement, CompilerOptionInfo.LOAD_EXTERNS_INFO, linkReportPath);
        }
        this.addOption(rootElement, CompilerOptionInfo.WARN_NO_CONSTRUCTOR_INFO, "false");
        if (this.myFlexmojos) {
            return;
        }
        BuildConfigurationNature nature = this.myBC.getNature();
        String targetPlayer = nature.isWebPlatform() ? this.myBC.getDependencies().getTargetPlayer() : FlexCommonUtils.getMaximumTargetPlayer(this.mySdk.getHomePath());
        this.addOption(rootElement, CompilerOptionInfo.TARGET_PLAYER_INFO, targetPlayer);
        if (FlexCommonUtils.isAirSdkWithoutFlex(this.mySdk) || StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4.5") >= 0) {
            String swfVersion;
            if (nature.isWebPlatform()) {
                swfVersion = FlexCommonUtils.getSwfVersionForTargetPlayer(targetPlayer);
            } else {
                String airVersion = CompilerConfigGeneratorRt.getAirVersionIfCustomDescriptor(this.myBC);
                if (airVersion == null) {
                    airVersion = FlexCommonUtils.getAirVersion(this.mySdk.getHomePath(), this.mySdk.getVersionString());
                }
                swfVersion = airVersion != null ? FlexCommonUtils.getSwfVersionForAirVersion(airVersion) : FlexCommonUtils.getSwfVersionForSdk_THE_WORST_WAY(this.mySdk.getVersionString());
            }
            this.addOption(rootElement, CompilerOptionInfo.SWF_VERSION_INFO, swfVersion);
        }
        if (nature.isMobilePlatform()) {
            this.addOption(rootElement, CompilerOptionInfo.MOBILE_INFO, "true");
            this.addOption(rootElement, CompilerOptionInfo.PRELOADER_INFO, "spark.preloaders.SplashScreen");
        }
        if (!FlexCommonUtils.isAirSdkWithoutFlex(this.mySdk)) {
            String accessible = nature.isMobilePlatform() ? "false" : (StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4") >= 0 ? "true" : "false");
            this.addOption(rootElement, CompilerOptionInfo.ACCESSIBLE_INFO, accessible);
            String fontManagers = StringUtil.compareVersionNumbers((String)this.mySdk.getVersionString(), (String)"4") >= 0 ? "flash.fonts.JREFontManager\nflash.fonts.BatikFontManager\nflash.fonts.AFEFontManager\nflash.fonts.CFFFontManager" : "flash.fonts.JREFontManager\nflash.fonts.AFEFontManager\nflash.fonts.BatikFontManager";
            this.addOption(rootElement, CompilerOptionInfo.FONT_MANAGERS_INFO, fontManagers);
            this.addOption(rootElement, CompilerOptionInfo.STATIC_RSLS_INFO, "false");
        }
    }

    @Nullable
    private static String getAirVersionIfCustomDescriptor(JpsFlexBuildConfiguration bc) {
        if (bc.getTargetPlatform() == TargetPlatform.Desktop) {
            JpsAirDesktopPackagingOptions packagingOptions = bc.getAirDesktopPackagingOptions();
            if (!packagingOptions.isUseGeneratedDescriptor()) {
                return FlexCommonUtils.parseAirVersionFromDescriptorFile(packagingOptions.getCustomDescriptorPath());
            }
        } else if (bc.getTargetPlatform() == TargetPlatform.Mobile) {
            JpsAndroidPackagingOptions androidOptions = bc.getAndroidPackagingOptions();
            JpsIosPackagingOptions iosPackagingOptions = bc.getIosPackagingOptions();
            if (androidOptions.isEnabled() && androidOptions.isUseGeneratedDescriptor() || iosPackagingOptions.isEnabled() && iosPackagingOptions.isUseGeneratedDescriptor()) {
                return null;
            }
            String androidAirVersion = null;
            String iosAirVersion = null;
            if (androidOptions.isEnabled() && !androidOptions.isUseGeneratedDescriptor()) {
                androidAirVersion = FlexCommonUtils.parseAirVersionFromDescriptorFile(androidOptions.getCustomDescriptorPath());
            }
            if (iosPackagingOptions.isEnabled() && !iosPackagingOptions.isUseGeneratedDescriptor()) {
                iosAirVersion = FlexCommonUtils.parseAirVersionFromDescriptorFile(iosPackagingOptions.getCustomDescriptorPath());
            }
            if (androidAirVersion == null) {
                return iosAirVersion;
            }
            if (iosAirVersion == null) {
                return androidAirVersion;
            }
            return StringUtil.compareVersionNumbers((String)androidAirVersion, (String)iosAirVersion) > 0 ? iosAirVersion : androidAirVersion;
        }
        return null;
    }

    @Nullable
    private static String getCustomLinkReportPath(JpsFlexBuildConfiguration rlmBC) {
        JpsFlexBuildConfiguration appBC = ((JpsFlexBuildConfigurationManager)rlmBC.getModule().getProperties()).findConfigurationByName(rlmBC.getName());
        if (appBC != null) {
            List<String> linkReports = FlexCommonUtils.getOptionValues(appBC.getCompilerOptions().getAdditionalOptions(), "link-report");
            if (!linkReports.isEmpty()) {
                String path = linkReports.get(0);
                if (new File(path).isFile()) {
                    return path;
                }
                String absPath = FlexCommonUtils.getFlexCompilerWorkDirPath(appBC.getModule().getProject()) + "/" + path;
                if (new File(absPath).isFile()) {
                    return absPath;
                }
            } else {
                String path;
                File configFile;
                String configFilePath = appBC.getCompilerOptions().getAdditionalConfigFilePath();
                if (!configFilePath.isEmpty() && (configFile = new File(configFilePath)).isFile() && (path = FlexCommonUtils.findXMLElement(configFile, "<flex-config><link-report>")) != null) {
                    if (new File(path).isFile()) {
                        return path;
                    }
                    for (JpsTypedModuleSourceRoot srcRoot : appBC.getModule().getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
                        String absPath = srcRoot.getFile().getPath() + "/" + path;
                        if (!new File(absPath).isFile()) continue;
                        return absPath;
                    }
                }
            }
        }
        return null;
    }

    private void handleOptionsWithSpecialValues(Element rootElement) {
        for (CompilerOptionInfo info : CompilerOptionInfo.getOptionsWithSpecialValues()) {
            boolean themeForPureAS;
            Pair<String, ValueSource> valueAndSource = this.getValueAndSource(info);
            boolean bl = themeForPureAS = this.myBC.isPureAs() && "compiler.theme".equals(info.ID);
            if (valueAndSource.second != ValueSource.GlobalDefault || ((String)valueAndSource.first).isEmpty() && !themeForPureAS) continue;
            this.addOption(rootElement, info, (String)valueAndSource.first);
        }
    }

    private void addNamespaces(Element rootElement) {
        final StringBuilder namespaceBuilder = new StringBuilder();
        FlexCommonUtils.processStandardNamespaces(this.myBC, new PairConsumer<String, String>(){

            public void consume(String namespace, String relativePath) {
                if (namespaceBuilder.length() > 0) {
                    namespaceBuilder.append("\n");
                }
                namespaceBuilder.append(namespace).append("\t").append("${FLEX_SDK}/").append(relativePath);
            }
        });
        if (namespaceBuilder.length() == 0) {
            return;
        }
        CompilerOptionInfo info = CompilerOptionInfo.getOptionInfo("compiler.namespaces.namespace");
        this.addOption(rootElement, info, namespaceBuilder.toString());
    }

    private void addRootsFromSdk(Element rootElement) {
        String theme;
        CompilerOptionInfo localeInfo = CompilerOptionInfo.getOptionInfo("compiler.locale");
        if (!((String)this.getValueAndSource((CompilerOptionInfo)localeInfo).first).isEmpty()) {
            this.addOption(rootElement, CompilerOptionInfo.LIBRARY_PATH_INFO, this.mySdk.getHomePath() + "/frameworks/locale/{locale}");
        }
        THashMap libNameToRslInfo = new THashMap();
        for (String swcUrl : this.mySdk.getParent().getRootUrls(JpsOrderRootType.COMPILED)) {
            List<String> rslUrls;
            CompilerOptionInfo info;
            String swcPath = JpsPathUtil.urlToPath((String)swcUrl);
            if (!swcPath.toLowerCase().endsWith(".swc")) {
                Logger.getInstance((String)CompilerConfigGeneratorRt.class.getName()).warn("Unexpected URL in Flex SDK classes: " + swcUrl);
                continue;
            }
            LinkageType linkageType = FlexCommonUtils.getSdkEntryLinkageType(swcPath, this.myBC);
            if (linkageType == null) continue;
            if (linkageType == LinkageType.Default) {
                linkageType = this.myBC.getDependencies().getFrameworkLinkage();
            }
            if (linkageType == LinkageType.Default) {
                linkageType = FlexCommonUtils.getDefaultFrameworkLinkage(this.mySdk.getVersionString(), this.myBC.getNature());
            }
            if (this.myCSS && linkageType == LinkageType.Include) {
                linkageType = LinkageType.Merged;
            }
            CompilerOptionInfo compilerOptionInfo = linkageType == LinkageType.Merged ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.RSL ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.External ? CompilerOptionInfo.EXTERNAL_LIBRARY_INFO : (info = linkageType == LinkageType.Include ? CompilerOptionInfo.INCLUDE_LIBRARY_INFO : null)));
            assert (info != null) : swcPath + ": " + linkageType.getShortText();
            this.addOption(rootElement, info, swcPath);
            if (linkageType != LinkageType.RSL || (rslUrls = RslUtil.getRslUrls(this.mySdk.getHomePath(), swcPath)).isEmpty()) continue;
            StringBuilder rslBuilder = new StringBuilder();
            String firstUrl = rslUrls.get(0);
            rslBuilder.append(swcPath).append("\t").append(firstUrl).append("\t");
            if (firstUrl.startsWith("http://")) {
                rslBuilder.append("http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
            }
            if (rslUrls.size() > 1) {
                String secondUrl = rslUrls.get(1);
                rslBuilder.append("\t").append(secondUrl).append("\t");
                if (secondUrl.startsWith("http://")) {
                    rslBuilder.append("http://fpdownload.adobe.com/pub/swz/crossdomain.xml");
                }
            }
            String swcName = PathUtilRt.getFileName((String)swcPath);
            String libName = swcName.substring(0, swcName.length() - ".swc".length());
            libNameToRslInfo.put(libName, rslBuilder.toString());
        }
        if (this.myBC.getNature().isLib() && (theme = (String)this.getValueAndSource((CompilerOptionInfo)CompilerOptionInfo.getOptionInfo((String)"compiler.theme")).first) != null && theme.toLowerCase().endsWith(".swc")) {
            this.addOption(rootElement, CompilerOptionInfo.LIBRARY_PATH_INFO, theme);
        }
        this.addRslInfo(rootElement, (Map<String, String>)libNameToRslInfo);
    }

    private void addRslInfo(Element rootElement, Map<String, String> libNameToRslInfo) {
        if (libNameToRslInfo.isEmpty()) {
            return;
        }
        for (String libName : LIB_ORDER) {
            String rslInfo = libNameToRslInfo.remove(libName);
            if (rslInfo == null) continue;
            CompilerOptionInfo option = StringUtil.split((String)rslInfo, (String)"\t", (boolean)true, (boolean)false).size() == 3 ? CompilerOptionInfo.RSL_ONE_URL_PATH_INFO : CompilerOptionInfo.RSL_TWO_URLS_PATH_INFO;
            this.addOption(rootElement, option, rslInfo);
        }
        for (String rslInfo : libNameToRslInfo.values()) {
            CompilerOptionInfo option = StringUtil.split((String)rslInfo, (String)"\t", (boolean)true, (boolean)false).size() == 3 ? CompilerOptionInfo.RSL_ONE_URL_PATH_INFO : CompilerOptionInfo.RSL_TWO_URLS_PATH_INFO;
            this.addOption(rootElement, option, rslInfo);
        }
    }

    private void addLibs(Element rootElement) {
        for (JpsFlexDependencyEntry entry : this.myBC.getDependencies().getEntries()) {
            JpsLibrary library;
            LinkageType linkageType = entry.getLinkageType();
            if (linkageType == LinkageType.Test) {
                if (!this.myFlexUnit) continue;
                linkageType = LinkageType.Merged;
            }
            if (this.myCSS && linkageType == LinkageType.Include) {
                linkageType = LinkageType.Merged;
            }
            if (entry instanceof JpsFlexBCDependencyEntry) {
                JpsFlexBuildConfiguration dependencyBC;
                if (linkageType == LinkageType.LoadInRuntime || (dependencyBC = ((JpsFlexBCDependencyEntry)entry).getBC()) == null || !FlexCommonUtils.checkDependencyType(this.myBC.getOutputType(), dependencyBC.getOutputType(), linkageType)) continue;
                this.addLib(rootElement, dependencyBC.getActualOutputFilePath(), linkageType);
                continue;
            }
            if (!(entry instanceof JpsLibraryDependencyEntry) || (library = ((JpsLibraryDependencyEntry)entry).getLibrary()) == null) continue;
            this.addLibraryRoots(rootElement, library.getRootUrls(JpsOrderRootType.COMPILED), linkageType);
        }
        if (this.myFlexUnit) {
            Collection<String> flexUnitLibNames = FlexCommonUtils.getFlexUnitSupportLibNames(this.myBC.getNature(), this.myBC.getDependencies().getComponentSet(), CompilerConfigGeneratorRt.getPathToFlexUnitMainClass(this.myProjectDescriptor, this.myBC.getNature(), this.myBC.getMainClass()));
            for (String libName : flexUnitLibNames) {
                String libPath = FlexCommonUtils.getPathToBundledJar(libName);
                String flexUnitSwcUrl = JpsPathUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)libPath));
                this.addLibraryRoots(rootElement, Collections.singletonList(flexUnitSwcUrl), LinkageType.Merged);
            }
        }
    }

    private void addLibraryRoots(Element rootElement, List<String> libRootUrls, LinkageType linkageType) {
        for (String libRootUrl : libRootUrls) {
            String libFileName;
            String libFilePath = JpsPathUtil.urlToPath((String)libRootUrl);
            File libFile = new File(libFilePath);
            if (libFile.isDirectory()) {
                this.addOption(rootElement, CompilerOptionInfo.SOURCE_PATH_INFO, libFile.getPath());
                continue;
            }
            if (!libFile.isFile()) continue;
            if (libFilePath.toLowerCase().endsWith(".ane")) {
                this.addLib(rootElement, libFilePath, LinkageType.External);
                continue;
            }
            if (!libFilePath.toLowerCase().endsWith(".swc") || (libFileName = libFile.getName().toLowerCase()).startsWith("airglobal") && !libFileName.equals("airglobal.swc") || libFileName.startsWith("playerglobal") && !libFileName.equals("playerglobal.swc")) continue;
            this.addLib(rootElement, libFilePath, linkageType);
        }
    }

    private void addLib(Element rootElement, String swcPath, LinkageType linkageType) {
        CompilerOptionInfo info;
        CompilerOptionInfo compilerOptionInfo = linkageType == LinkageType.Merged || linkageType == LinkageType.RSL ? CompilerOptionInfo.LIBRARY_PATH_INFO : (linkageType == LinkageType.External ? CompilerOptionInfo.EXTERNAL_LIBRARY_INFO : (info = linkageType == LinkageType.Include ? CompilerOptionInfo.INCLUDE_LIBRARY_INFO : null));
        assert (info != null) : swcPath + ": " + linkageType;
        this.addOption(rootElement, info, swcPath);
        if (linkageType == LinkageType.RSL) {
            // empty if block
        }
    }

    private void addSourcePaths(Element rootElement) {
        String cssFolderPath;
        String srcRootPath;
        String localeValue = (String)this.getValueAndSource((CompilerOptionInfo)CompilerOptionInfo.getOptionInfo((String)"compiler.locale")).first;
        List locales = StringUtil.split((String)localeValue, (String)"\n");
        locales.addAll(FlexCommonUtils.getOptionValues(this.myProjectLevelCompilerOptions.getAdditionalOptions(), "locale", "compiler.locale"));
        locales.addAll(FlexCommonUtils.getOptionValues(this.myModuleLevelCompilerOptions.getAdditionalOptions(), "locale", "compiler.locale"));
        locales.addAll(FlexCommonUtils.getOptionValues(this.myBC.getCompilerOptions().getAdditionalOptions(), "locale", "compiler.locale"));
        THashSet sourcePathsWithLocaleToken = new THashSet();
        LinkedList<String> sourcePathsWithoutLocaleToken = new LinkedList<String>();
        for (JpsTypedModuleSourceRoot srcRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
            srcRootPath = JpsPathUtil.urlToPath((String)srcRoot.getUrl());
            if (locales.contains(PathUtilRt.getFileName((String)srcRootPath))) {
                sourcePathsWithLocaleToken.add(PathUtilRt.getParentPath((String)srcRootPath) + "/" + "{locale}");
                continue;
            }
            sourcePathsWithoutLocaleToken.add(srcRootPath);
        }
        if (this.includeTestRoots()) {
            for (JpsTypedModuleSourceRoot srcRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
                srcRootPath = JpsPathUtil.urlToPath((String)srcRoot.getUrl());
                if (locales.contains(PathUtilRt.getFileName((String)srcRootPath))) {
                    sourcePathsWithLocaleToken.add(PathUtilRt.getParentPath((String)srcRootPath) + "/" + "{locale}");
                    continue;
                }
                sourcePathsWithoutLocaleToken.add(srcRootPath);
            }
        }
        StringBuilder sourcePathBuilder = new StringBuilder();
        if (this.myCSS && !sourcePathsWithoutLocaleToken.contains(cssFolderPath = PathUtilRt.getParentPath((String)this.myBC.getMainClass()))) {
            sourcePathBuilder.append(cssFolderPath);
        }
        for (String sourcePath : sourcePathsWithLocaleToken) {
            if (sourcePathBuilder.length() > 0) {
                sourcePathBuilder.append("\n");
            }
            sourcePathBuilder.append(sourcePath);
        }
        for (String sourcePath : sourcePathsWithoutLocaleToken) {
            if (sourcePathBuilder.length() > 0) {
                sourcePathBuilder.append("\n");
            }
            sourcePathBuilder.append(sourcePath);
        }
        this.addOption(rootElement, CompilerOptionInfo.SOURCE_PATH_INFO, sourcePathBuilder.toString());
    }

    private boolean includeTestRoots() {
        if (this.myFlexUnit) {
            return true;
        }
        if (this.myCSS) {
            return false;
        }
        if (this.myBC.getOutputType() != OutputType.Application) {
            return false;
        }
        String path = FlexCommonUtils.getPathToMainClassFile(this.myBC.getMainClass(), this.myModule);
        return CompilerConfigGeneratorRt.isInTestSourceRoot(this.myModule, path);
    }

    private static boolean isInTestSourceRoot(JpsModule module, String path) {
        for (JpsTypedModuleSourceRoot testSrcRoot : module.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
            String testSrcRootPath = JpsPathUtil.urlToPath((String)testSrcRoot.getUrl());
            if (!path.startsWith(testSrcRootPath + "/")) continue;
            return true;
        }
        return false;
    }

    private void addOtherOptions(Element rootElement) {
        THashMap options = new THashMap(this.myProjectLevelCompilerOptions.getAllOptions());
        options.putAll(this.myModuleLevelCompilerOptions.getAllOptions());
        options.putAll(this.myBC.getCompilerOptions().getAllOptions());
        String addOptions = this.myProjectLevelCompilerOptions.getAdditionalOptions() + " " + this.myModuleLevelCompilerOptions.getAdditionalOptions() + " " + this.myBC.getCompilerOptions().getAdditionalOptions();
        List<String> contextRootInAddOptions = FlexCommonUtils.getOptionValues(addOptions, "context-root", "compiler.context-root");
        if (options.get("compiler.context-root") == null && contextRootInAddOptions.isEmpty()) {
            List<String> servicesInAddOptions = FlexCommonUtils.getOptionValues(addOptions, "services", "compiler.services");
            if (options.get("compiler.services") != null || !servicesInAddOptions.isEmpty()) {
                options.put("compiler.context-root", "");
            }
        }
        for (Map.Entry entry : options.entrySet()) {
            this.addOption(rootElement, CompilerOptionInfo.getOptionInfo((String)entry.getKey()), (String)entry.getValue());
        }
        String namespacesRaw = (String)options.get("compiler.namespaces.namespace");
        if (namespacesRaw != null && this.myBC.getOutputType() == OutputType.Library) {
            String namespaces = FlexCommonUtils.replacePathMacros(namespacesRaw, this.myModule, this.myFlexmojos ? "" : this.mySdk.getHomePath());
            StringBuilder buf = new StringBuilder();
            for (String listEntry : StringUtil.split((String)namespaces, (String)"\n")) {
                int tabIndex = listEntry.indexOf("\t");
                assert (tabIndex != -1) : namespaces;
                String namespace = listEntry.substring(0, tabIndex);
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(namespace);
            }
            if (buf.length() > 0) {
                this.addOption(rootElement, CompilerOptionInfo.INCLUDE_NAMESPACES_INFO, buf.toString());
            }
        }
    }

    private void addInputOutputPaths(Element rootElement) throws IOException {
        if (this.myBC.getOutputType() == OutputType.Library) {
            this.addFilesIncludedInSwc(rootElement);
            if (!this.myFlexmojos) {
                this.addLibClasses(rootElement);
            }
        } else {
            String pathToMainClassFile;
            InfoFromConfigFile info = InfoFromConfigFile.getInfoFromConfigFile(this.myBC.getCompilerOptions().getAdditionalConfigFilePath());
            String string = this.myCSS ? this.myBC.getMainClass() : (pathToMainClassFile = this.myFlexUnit ? CompilerConfigGeneratorRt.getPathToFlexUnitMainClass(this.myProjectDescriptor, this.myBC.getNature(), this.myBC.getMainClass()) : FlexCommonUtils.getPathToMainClassFile(this.myBC.getMainClass(), this.myModule));
            if (pathToMainClassFile.isEmpty() && info.getMainClass(this.myModule) == null && !Utils.IS_TEST_MODE) {
                throw new IOException(FlexCommonBundle.message("bc.incorrect.main.class", this.myBC.getMainClass(), this.myBC.getName(), this.myModule.getName()));
            }
            if (!pathToMainClassFile.isEmpty()) {
                this.addOption(rootElement, CompilerOptionInfo.MAIN_CLASS_INFO, FileUtil.toSystemIndependentName((String)pathToMainClassFile));
            }
        }
        this.addOption(rootElement, CompilerOptionInfo.OUTPUT_PATH_INFO, this.myBC.getActualOutputFilePath());
    }

    private void addFilesIncludedInSwc(Element rootElement) {
        final JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(this.myModule.getProject()).getCompilerExcludes();
        THashMap filePathToPathInSwc = new THashMap();
        for (String string : this.myBC.getCompilerOptions().getFilesToIncludeInSWC()) {
            final File fileOrDir = new File(string);
            if (excludes.isExcluded(fileOrDir) || this.myProjectDescriptor.getIgnoredFileIndex().isIgnored(fileOrDir.getName())) continue;
            final String baseRelativePath = StringUtil.notNullize((String)FlexCommonUtils.getPathRelativeToSourceRoot(this.myModule, fileOrDir.getPath()), (String)fileOrDir.getName());
            if (fileOrDir.isDirectory()) {
                CompilerConfigGeneratorRt.processFilesRecursively(fileOrDir, new Processor<File>((Map)filePathToPathInSwc){
                    final /* synthetic */ Map val$filePathToPathInSwc;
                    {
                        this.val$filePathToPathInSwc = map;
                    }

                    public boolean process(File file) {
                        if (CompilerConfigGeneratorRt.this.myProjectDescriptor.getIgnoredFileIndex().isIgnored(file.getName())) {
                            return false;
                        }
                        if (!(file.isDirectory() || FlexCommonUtils.isSourceFile(file.getName()) || excludes.isExcluded(file))) {
                            String relativePath = FileUtil.getRelativePath((File)fileOrDir, (File)file);
                            assert (relativePath != null);
                            String pathInSwc = baseRelativePath.isEmpty() ? relativePath : baseRelativePath + "/" + relativePath;
                            this.val$filePathToPathInSwc.put(file.getPath(), pathInSwc);
                        }
                        return true;
                    }
                });
                continue;
            }
            if (!fileOrDir.isFile()) continue;
            filePathToPathInSwc.put(fileOrDir.getPath(), baseRelativePath);
        }
        for (Map.Entry entry : filePathToPathInSwc.entrySet()) {
            String value = FileUtil.toSystemIndependentName((String)((String)entry.getValue())) + "\t" + FileUtil.toSystemIndependentName((String)((String)entry.getKey()));
            this.addOption(rootElement, CompilerOptionInfo.INCLUDE_FILE_INFO, value);
        }
    }

    private void addOption(Element rootElement, CompilerOptionInfo info, String rawValue) {
        if (!info.isApplicable(this.mySdk.getVersionString(), this.myBC.getNature())) {
            return;
        }
        String value = FlexCommonUtils.replacePathMacros(rawValue, this.myModule, this.myFlexmojos ? "" : this.mySdk.getHomePath());
        String pathInFlexConfig = info.ID.startsWith("compiler.debug") ? "compiler.debug" : info.ID;
        List elementNames = StringUtil.split((String)pathInFlexConfig, (String)".");
        Element parentElement = rootElement;
        for (int i1 = 0; i1 < elementNames.size() - 1; ++i1) {
            parentElement = CompilerConfigGeneratorRt.getOrCreateElement(parentElement, (String)elementNames.get(i1));
        }
        String elementName = (String)elementNames.get(elementNames.size() - 1);
        switch (info.TYPE) {
            case Boolean: 
            case String: 
            case Int: 
            case File: {
                Element simpleElement = new Element(elementName, parentElement.getNamespace());
                simpleElement.setText(value);
                parentElement.addContent(simpleElement);
                break;
            }
            case List: {
                if (info.LIST_ELEMENTS.length == 1) {
                    Element listHolderElement = CompilerConfigGeneratorRt.getOrCreateElement(parentElement, elementName);
                    for (String listElementValue : StringUtil.split((String)value, (String)"\n")) {
                        Element child = new Element(info.LIST_ELEMENTS[0].NAME, listHolderElement.getNamespace());
                        child.setText(listElementValue);
                        listHolderElement.addContent(child);
                    }
                } else {
                    for (String listEntry : StringUtil.split((String)value, (String)String.valueOf("\n"))) {
                        Element repeatableListHolderElement = new Element(elementName, parentElement.getNamespace());
                        List values = StringUtil.split((String)listEntry, (String)"\t", (boolean)true, (boolean)false);
                        assert (info.LIST_ELEMENTS.length == values.size()) : info.ID + "=" + value;
                        for (int i = 0; i < info.LIST_ELEMENTS.length; ++i) {
                            Element child = new Element(info.LIST_ELEMENTS[i].NAME, repeatableListHolderElement.getNamespace());
                            child.setText((String)values.get(i));
                            repeatableListHolderElement.addContent(child);
                        }
                        parentElement.addContent(repeatableListHolderElement);
                    }
                }
                break;
            }
            default: {
                assert (false) : info.DISPLAY_NAME;
                break;
            }
        }
    }

    private static Element getOrCreateElement(Element parentElement, String elementName) {
        Element child = parentElement.getChild(elementName, parentElement.getNamespace());
        if (child == null) {
            child = new Element(elementName, parentElement.getNamespace());
            parentElement.addContent(child);
        }
        return child;
    }

    private Pair<String, ValueSource> getValueAndSource(CompilerOptionInfo info) {
        assert (!info.isGroup()) : info.DISPLAY_NAME;
        String bcLevelValue = this.myBC.getCompilerOptions().getOption(info.ID);
        if (bcLevelValue != null) {
            return Pair.create((Object)bcLevelValue, (Object)((Object)ValueSource.BC));
        }
        String moduleLevelValue = this.myModuleLevelCompilerOptions.getOption(info.ID);
        if (moduleLevelValue != null) {
            return Pair.create((Object)moduleLevelValue, (Object)((Object)ValueSource.ModuleDefault));
        }
        String projectLevelValue = this.myProjectLevelCompilerOptions.getOption(info.ID);
        if (projectLevelValue != null) {
            return Pair.create((Object)projectLevelValue, (Object)((Object)ValueSource.ProjectDefault));
        }
        return Pair.create((Object)info.getDefaultValue(this.mySdk.getVersionString(), this.myBC.getNature(), this.myBC.getDependencies().getComponentSet()), (Object)((Object)ValueSource.GlobalDefault));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getOrCreateConfigFile(String fileName, String text) throws IOException {
        File tempFolder = new File(FlexCommonUtils.getTempFlexConfigsDirPath());
        File configFile = new File(tempFolder, fileName);
        byte[] textBytes = text.getBytes("UTF-8");
        if (!FileUtil.createDirectory((File)tempFolder) && !tempFolder.isDirectory()) {
            throw new IOException("Failed to create folder " + configFile.getParent());
        }
        FileOutputStream outputStream = new FileOutputStream(configFile);
        try {
            outputStream.write(textBytes);
        }
        finally {
            outputStream.close();
        }
        return configFile;
    }

    private static String getConfigFileName(JpsFlexBuildConfiguration bc, @Nullable String postfix) {
        String prefix = "idea";
        String hash1 = Integer.toHexString((SystemProperties.getUserName() + bc.getModule().getProject().getName()).hashCode()).toUpperCase();
        String hash2 = Integer.toHexString((bc.getModule().getName() + StringUtil.notNullize((String)bc.getName())).hashCode()).toUpperCase();
        return "idea-" + hash1 + "-" + hash2 + (postfix == null ? ".xml" : "-" + StringUtil.replaceChar((String)postfix, (char)' ', (char)'-') + ".xml");
    }

    private static String getLinkReportFilePath(JpsFlexBuildConfiguration bc) {
        String fileName = CompilerConfigGeneratorRt.getConfigFileName(bc, "link-report");
        return FlexCommonUtils.getTempFlexConfigsDirPath() + "/" + fileName;
    }

    private void addLibClasses(final Element rootElement) throws IOException {
        final JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(this.myModule.getProject()).getCompilerExcludes();
        final Ref noClasses = new Ref((Object)true);
        for (JpsTypedModuleSourceRoot srcRoot : this.myModule.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
            final File srcFolder = JpsPathUtil.urlToFile((String)srcRoot.getUrl());
            if (!srcFolder.isDirectory()) continue;
            CompilerConfigGeneratorRt.processFilesRecursively(srcFolder, new Processor<File>(){

                public boolean process(File file) {
                    if (CompilerConfigGeneratorRt.this.myProjectDescriptor.getIgnoredFileIndex().isIgnored(file.getName())) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (!FlexCommonUtils.isSourceFile(file.getName())) {
                        return true;
                    }
                    if (excludes.isExcluded(file)) {
                        return true;
                    }
                    String packageRelativePath = FileUtil.getRelativePath((File)srcFolder, (File)file.getParentFile());
                    assert (packageRelativePath != null) : srcFolder.getPath() + ": " + file.getPath();
                    if (packageRelativePath.equals(".")) {
                        packageRelativePath = "";
                    }
                    String packageName = packageRelativePath.replace(File.separatorChar, '.');
                    String qName = StringUtil.getQualifiedName((String)packageName, (String)FileUtil.getNameWithoutExtension((File)file));
                    if (CompilerConfigGeneratorRt.isSourceFileWithPublicDeclaration(file)) {
                        CompilerConfigGeneratorRt.this.addOption(rootElement, CompilerOptionInfo.INCLUDE_CLASSES_INFO, qName);
                        noClasses.set((Object)false);
                    }
                    return true;
                }
            });
        }
        if (((Boolean)noClasses.get()).booleanValue() && this.myBC.getCompilerOptions().getFilesToIncludeInSWC().isEmpty() && !Utils.IS_TEST_MODE) {
            throw new IOException(FlexCommonBundle.message("nothing.to.compile.in.library", this.myModule.getName(), this.myBC.getName()));
        }
    }

    private static boolean isSourceFileWithPublicDeclaration(File file) {
        String fileNameLowercased = file.getName().toLowerCase();
        if (fileNameLowercased.endsWith(".mxml") || fileNameLowercased.endsWith(".fxg")) {
            return true;
        }
        if (fileNameLowercased.endsWith(".as")) {
            try {
                String content = FileUtil.loadFile((File)file, (String)"UTF-8");
                return content.contains("package");
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    private static boolean processFilesRecursively(@NotNull File root, @NotNull Processor<File> processor) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/flex/build/CompilerConfigGeneratorRt", "processFilesRecursively"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/flex/build/CompilerConfigGeneratorRt", "processFilesRecursively"));
        }
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(root);
        while (!queue.isEmpty()) {
            Object[] children;
            File file = (File)queue.removeFirst();
            if (!processor.process((Object)file) || !file.isDirectory() || (children = file.listFiles()) == null) continue;
            ContainerUtil.addAll(queue, (Object[])children);
        }
        return true;
    }

    private static String getPathToFlexUnitTempDirectory(ProjectDescriptor projectDescriptor) {
        return FileUtil.toSystemIndependentName((String)projectDescriptor.dataManager.getDataPaths().getDataStorageRoot().getPath()) + "/tmp";
    }

    private static String getPathToFlexUnitMainClass(ProjectDescriptor projectDescriptor, BuildConfigurationNature nature, String mainClass) {
        return CompilerConfigGeneratorRt.getPathToFlexUnitTempDirectory(projectDescriptor) + "/" + mainClass + FlexCommonUtils.getFlexUnitLauncherExtension(nature);
    }
}

