/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.GwtCompilerWorkspaceState;
import org.jetbrains.jps.gwt.model.impl.GwtModuleExtensionProperties;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerOutputPackagingElement;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerProjectExtensionImpl;
import org.jetbrains.jps.gwt.model.impl.JpsGwtModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetSerializer;

public class JpsGwtModelSerializerExtension
extends JpsModelSerializerExtension {
    @NonNls
    public static final String GWT_COMPILER_CONFIGURATION_COMPONENT_NAME = "GwtCompilerConfiguration";

    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsGwtWorkspaceConfigurationSerializer> list = Collections.singletonList(new JpsGwtWorkspaceConfigurationSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension", "getProjectExtensionSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<JpsGwtFacetConfigurationSerializer> list = Collections.singletonList(new JpsGwtFacetConfigurationSerializer());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension", "getFacetConfigurationSerializers"));
        }
        return list;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsGwtCompilerOutputElementSerializer> list = Arrays.asList(new JpsGwtCompilerOutputElementSerializer("gwt-compiler-output", JpsGwtCompilerOutputPackagingElement.OutputKind.REGULAR), new JpsGwtCompilerOutputElementSerializer("gwt-compiler-deploy-output", JpsGwtCompilerOutputPackagingElement.OutputKind.DEPLOY));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension", "getPackagingElementSerializers"));
        }
        return list;
    }

    private static class JpsGwtWorkspaceConfigurationSerializer
    extends JpsProjectExtensionSerializer {
        private JpsGwtWorkspaceConfigurationSerializer() {
            super("workspace.xml", JpsGwtModelSerializerExtension.GWT_COMPILER_CONFIGURATION_COMPONENT_NAME);
        }

        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtWorkspaceConfigurationSerializer", "loadExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtWorkspaceConfigurationSerializer", "loadExtension"));
            }
            GwtCompilerWorkspaceState state = (GwtCompilerWorkspaceState)XmlSerializer.deserialize((Element)componentTag, GwtCompilerWorkspaceState.class);
            if (state != null) {
                JpsGwtCompilerProjectExtensionImpl extension = new JpsGwtCompilerProjectExtensionImpl(state.getModulesToShowCompilerOutput());
                project.getContainer().setChild(JpsGwtCompilerProjectExtensionImpl.ROLE, (JpsElement)extension);
            }
        }

        public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtWorkspaceConfigurationSerializer", "saveExtension"));
            }
            if (componentTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtWorkspaceConfigurationSerializer", "saveExtension"));
            }
        }
    }

    private static class JpsGwtCompilerOutputElementSerializer
    extends JpsPackagingElementSerializer<JpsGwtCompilerOutputPackagingElement> {
        private JpsGwtCompilerOutputPackagingElement.OutputKind myOutputKind;

        public JpsGwtCompilerOutputElementSerializer(String typeId, JpsGwtCompilerOutputPackagingElement.OutputKind outputKind) {
            super(typeId, JpsGwtCompilerOutputPackagingElement.class);
            this.myOutputKind = outputKind;
        }

        public JpsGwtCompilerOutputPackagingElement load(Element element) {
            JpsModuleReference moduleReference = JpsFacetSerializer.createModuleReference((String)element.getAttributeValue("facet"));
            return new JpsGwtCompilerOutputPackagingElement(moduleReference, this.myOutputKind);
        }

        public void save(JpsGwtCompilerOutputPackagingElement element, Element tag) {
            String id = JpsFacetSerializer.getFacetId((JpsModuleReference)element.getModuleReference(), (String)"gwt", (String)"GWT");
            tag.setAttribute("facet", id);
        }
    }

    private static class JpsGwtFacetConfigurationSerializer
    extends JpsFacetConfigurationSerializer<JpsGwtModuleExtension> {
        public JpsGwtFacetConfigurationSerializer() {
            super(JpsGwtModuleExtensionImpl.ROLE, "gwt", "GWT");
        }

        protected JpsGwtModuleExtension loadExtension(@NotNull Element facetConfigurationElement, String name, JpsElement parent, JpsModule module) {
            if (facetConfigurationElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetConfigurationElement", "org/jetbrains/jps/gwt/model/impl/JpsGwtModelSerializerExtension$JpsGwtFacetConfigurationSerializer", "loadExtension"));
            }
            GwtModuleExtensionProperties properties = (GwtModuleExtensionProperties)XmlSerializer.deserialize((Element)facetConfigurationElement, GwtModuleExtensionProperties.class);
            return new JpsGwtModuleExtensionImpl(properties != null ? properties : new GwtModuleExtensionProperties());
        }

        protected void saveExtension(JpsGwtModuleExtension extension, Element facetConfigurationTag, JpsModule module) {
            XmlSerializer.serializeInto((Object)((JpsGwtModuleExtensionImpl)extension).getProperties(), (Element)facetConfigurationTag, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
    }
}

