/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Log4jFileLoggerFactory
implements Logger.Factory {
    private final RollingFileAppender myAppender;
    private final List<String> myCategoriesWithDebugLevel;

    public Log4jFileLoggerFactory(File logFile, String categoriesWithDebugLevel) throws IOException {
        this.myCategoriesWithDebugLevel = categoriesWithDebugLevel.isEmpty() ? Collections.emptyList() : Arrays.asList(categoriesWithDebugLevel.split(","));
        PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %30.30c - %m\n");
        this.myAppender = new RollingFileAppender((Layout)pattern, logFile.getAbsolutePath());
        this.myAppender.setMaxFileSize("20MB");
        this.myAppender.setMaxBackupIndex(10);
    }

    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(String category) {
        final Logger logger = Logger.getLogger((String)category);
        logger.addAppender((Appender)this.myAppender);
        logger.setLevel(this.isDebugLevel(category) ? Level.DEBUG : Level.INFO);
        return new com.intellij.openapi.diagnostic.Logger(){

            public boolean isDebugEnabled() {
                return logger.isDebugEnabled();
            }

            public void debug(@NonNls String message) {
                logger.debug((Object)message);
            }

            public void debug(@Nullable Throwable t) {
                logger.debug((Object)t);
            }

            public void debug(@NonNls String message, @Nullable Throwable t) {
                logger.debug((Object)message, t);
            }

            public void info(@NonNls String message) {
                logger.info((Object)message);
            }

            public void info(@NonNls String message, @Nullable Throwable t) {
                logger.info((Object)message, t);
            }

            public void warn(@NonNls String message, @Nullable Throwable t) {
                logger.warn((Object)message, t);
            }

            public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
                if (details == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "org/jetbrains/jps/gant/Log4jFileLoggerFactory$1", "error"));
                }
                logger.error((Object)message, t);
            }

            public void setLevel(Level level) {
                logger.setLevel(level);
            }
        };
    }

    private boolean isDebugLevel(String category) {
        for (String debug : this.myCategoriesWithDebugLevel) {
            if (!category.startsWith(debug)) continue;
            return true;
        }
        return false;
    }
}

