/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.build;

import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.osgi.jps.build.OsmorcBuildTargetType;
import org.jetbrains.osgi.jps.model.JpsOsmorcExtensionService;
import org.jetbrains.osgi.jps.model.JpsOsmorcModuleExtension;

public class OsmorcBuildTarget
extends ModuleBasedTarget<BuildRootDescriptor> {
    private final JpsOsmorcModuleExtension myExtension;

    public OsmorcBuildTarget(@NotNull JpsOsmorcModuleExtension extension, @NotNull JpsModule module) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "<init>"));
        }
        super((ModuleBasedBuildTargetType)OsmorcBuildTargetType.INSTANCE, module);
        this.myExtension = extension;
    }

    public JpsOsmorcModuleExtension getExtension() {
        return this.myExtension;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        Collection targets = targetRegistry.getModuleBasedTargets(this.getModule(), BuildTargetRegistry.ModuleTargetSelector.PRODUCTION);
        return Collections.unmodifiableCollection(targets);
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        final ArrayList roots = ContainerUtil.newArrayList();
        JpsJavaExtensionService.dependencies((JpsModule)this.getModule()).recursively().productionOnly().processModules((Consumer)new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                JpsOsmorcModuleExtension extension = JpsOsmorcExtensionService.getExtension(module);
                if (extension != null) {
                    for (JpsTypedModuleSourceRoot sourceRoot : module.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
                        File root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
                        roots.add(new BuildRootDescriptorImpl((BuildTarget)OsmorcBuildTarget.this, root, true));
                    }
                }
            }
        });
        ArrayList arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = "OSGi in module '" + this.getModule().getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        String jarFileLocation = this.myExtension.getJarFileLocation();
        Collection<File> collection = jarFileLocation.isEmpty() ? Collections.emptyList() : Collections.singleton(new File(jarFileLocation));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/build/OsmorcBuildTarget", "getOutputRoots"));
        }
        return collection;
    }

    public boolean isTests() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OsmorcBuildTarget target = (OsmorcBuildTarget)((Object)o);
        return this.myExtension.equals(target.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }
}

