/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtMavenSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "maven";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;

    public GwtMavenSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myVersion = version;
    }

    public static String getPlatformId() {
        return SystemInfo.isMac ? "mac" : (SystemInfo.isLinux ? "linux" : "windows");
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String platformSuffix = this.myVersion.startsWith("2.") ? "" : "-" + GwtMavenSdkPaths.getPlatformId();
        String string = FileUtil.toSystemDependentName((String)this.myDevDirPath) + File.separator + "gwt-dev-" + this.myVersion + platformSuffix + ".jar";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getJarPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("gwt-servlet");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    private String getJarPath(String name) {
        return FileUtil.toSystemDependentName((String)this.myBasePath) + File.separator + name + File.separator + this.myVersion + File.separator + name + "-" + this.myVersion + ".jar";
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("gwt-user");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        String repositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath)));
        List<String> list = GwtSdkPathUtil.findValidationJarsInMavenRepo(repositoryPath);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getAdditionalCompilerJars"));
        }
        return list;
    }
}

