/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.build;

import com.intellij.util.ArrayUtil;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.jps.api.BuildType;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.build.GroovyModelInitializer;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.cmdline.BuildRunner;
import org.jetbrains.jps.cmdline.JpsModelLoader;
import org.jetbrains.jps.cmdline.JpsModelLoaderImpl;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTargetType;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class Standalone {
    @Argument(value="config", prefix="--", description="Path to directory containing global options (idea.config.path)")
    public String configPath;
    @Argument(value="script", prefix="--", description="Path to Groovy script which will be used to initialize global options")
    public String initializationScriptPath;
    @Argument(value="cache-dir", prefix="--", description="Path to directory to store build caches")
    public String cacheDirPath;
    @Argument(value="modules", prefix="--", delimiter=",", description="Comma-separated list of modules to compile")
    public String[] modules = ArrayUtil.EMPTY_STRING_ARRAY;
    @Argument(value="all-modules", prefix="--", description="Compile all modules")
    public boolean allModules;
    @Argument(value="artifacts", prefix="--", delimiter=",", description="Comma-separated list of artifacts to build")
    public String[] artifacts = ArrayUtil.EMPTY_STRING_ARRAY;
    @Argument(value="all-artifacts", prefix="--", description="Build all artifacts")
    public boolean allArtifacts;
    @Argument(value="i", description="Build incrementally")
    public boolean incremental;

    public static void main(String[] args) {
        List projectPaths;
        Standalone instance = new Standalone();
        try {
            projectPaths = Args.parse((Object)instance, (String[])args);
        }
        catch (Exception e) {
            Standalone.printUsageAndExit();
            return;
        }
        if (projectPaths.isEmpty()) {
            System.out.println("Path to project is not specified");
            Standalone.printUsageAndExit();
        }
        if (projectPaths.size() > 1) {
            System.out.println("Only one project can be specified");
            Standalone.printUsageAndExit();
        }
        instance.loadAndRunBuild((String)projectPaths.get(0));
        System.exit(0);
    }

    private static void printUsageAndExit() {
        Args.usage((PrintStream)System.err, (Object)new Standalone());
        System.exit(0);
    }

    public void loadAndRunBuild(String projectPath) {
        String globalOptionsPath = null;
        if (this.configPath != null) {
            File optionsDir = new File(this.configPath, "options");
            if (!optionsDir.isDirectory()) {
                System.err.println("'" + this.configPath + "' is not valid config path: " + optionsDir.getAbsolutePath() + " not found");
                return;
            }
            globalOptionsPath = optionsDir.getAbsolutePath();
        }
        GroovyModelInitializer initializer = null;
        String scriptPath = this.initializationScriptPath;
        if (scriptPath != null) {
            File scriptFile = new File(scriptPath);
            if (!scriptFile.isFile()) {
                System.err.println("Script '" + scriptPath + "' not found");
                return;
            }
            initializer = new GroovyModelInitializer(scriptFile);
        }
        if (this.modules.length == 0 && this.artifacts.length == 0 && !this.allModules && !this.allArtifacts) {
            System.err.println("Nothing to compile: at least one of --modules, --artifacts, --all-modules or --all-artifacts parameters must be specified");
            return;
        }
        JpsModelLoaderImpl loader = new JpsModelLoaderImpl(projectPath, globalOptionsPath, initializer);
        HashSet<String> modulesSet = new HashSet<String>(Arrays.asList(this.modules));
        List<String> artifactsList = Arrays.asList(this.artifacts);
        File dataStorageRoot = this.cacheDirPath != null ? new File(this.cacheDirPath) : Utils.getDataStorageRoot(projectPath);
        if (dataStorageRoot == null) {
            System.err.println("Error: Cannot determine build data storage root for project " + projectPath);
            return;
        }
        long start = System.currentTimeMillis();
        try {
            Standalone.runBuild(loader, dataStorageRoot, !this.incremental, modulesSet, this.allModules, artifactsList, this.allArtifacts, true, new ConsoleMessageHandler());
        }
        catch (Throwable t) {
            System.err.println("Internal error: " + t.getMessage());
            t.printStackTrace();
        }
        System.out.println("Build finished in " + Utils.formatDuration(System.currentTimeMillis() - start));
    }

    @Deprecated
    public static void runBuild(JpsModelLoader loader, File dataStorageRoot, boolean forceBuild, Set<String> modulesSet, List<String> artifactsList, boolean includeTests, MessageHandler messageHandler) throws Exception {
        Standalone.runBuild(loader, dataStorageRoot, forceBuild, modulesSet, modulesSet.isEmpty(), artifactsList, includeTests, messageHandler);
    }

    public static void runBuild(JpsModelLoader loader, File dataStorageRoot, boolean forceBuild, Set<String> modulesSet, boolean allModules, List<String> artifactsList, boolean includeTests, MessageHandler messageHandler) throws Exception {
        Standalone.runBuild(loader, dataStorageRoot, forceBuild, modulesSet, allModules, artifactsList, false, includeTests, messageHandler);
    }

    public static void runBuild(JpsModelLoader loader, File dataStorageRoot, boolean forceBuild, Set<String> modulesSet, boolean allModules, List<String> artifactsList, boolean allArtifacts, boolean includeTests, MessageHandler messageHandler) throws Exception {
        ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        for (JavaModuleBuildTargetType type : JavaModuleBuildTargetType.ALL_TYPES) {
            if (!includeTests && type.isTests()) continue;
            CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(type.getTypeId()).setForceBuild(forceBuild);
            if (allModules) {
                scopes.add(builder.setAllTargets(true).build());
                continue;
            }
            if (modulesSet.isEmpty()) continue;
            scopes.add(builder.addAllTargetId(modulesSet).build());
        }
        CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(ArtifactBuildTargetType.INSTANCE.getTypeId()).setForceBuild(forceBuild);
        if (allArtifacts) {
            scopes.add(builder.setAllTargets(true).build());
        } else if (!artifactsList.isEmpty()) {
            scopes.add(builder.addAllTargetId(artifactsList).build());
        }
        Standalone.runBuild(loader, dataStorageRoot, messageHandler, scopes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runBuild(JpsModelLoader loader, File dataStorageRoot, MessageHandler messageHandler, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, boolean includeDependenciesToScope) throws Exception {
        BuildRunner buildRunner = new BuildRunner(loader, Collections.<String>emptyList(), Collections.<String, String>emptyMap());
        ProjectDescriptor descriptor = buildRunner.load(messageHandler, dataStorageRoot, new BuildFSState(true));
        try {
            buildRunner.runBuild(descriptor, CanceledStatus.NULL, null, messageHandler, BuildType.BUILD, scopes, includeDependenciesToScope);
        }
        finally {
            descriptor.release();
        }
    }

    private static class ConsoleMessageHandler
    implements MessageHandler {
        private ConsoleMessageHandler() {
        }

        @Override
        public void processMessage(BuildMessage msg) {
            String messageText = msg.getMessageText();
            if (messageText.isEmpty()) {
                return;
            }
            if (msg.getKind() == BuildMessage.Kind.ERROR) {
                System.err.println("Error: " + messageText);
            } else if (msg.getKind() != BuildMessage.Kind.PROGRESS || !messageText.startsWith("Compiled") && !messageText.startsWith("Copying")) {
                System.out.println(messageText);
            }
        }
    }
}

