/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.jps.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class OsgiBuildUtil {
    @NotNull
    public static Properties getMavenProjectProperties(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        final MavenProjectConfiguration projectConfig = OsgiBuildUtil.getProjectConfig(context);
        final Properties result = new Properties();
        if (projectConfig == null) {
            Properties properties = result;
            if (properties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
            }
            return properties;
        }
        JpsJavaExtensionService.dependencies((JpsModule)module).recursively().productionOnly().processModules((Consumer)new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                MavenModuleResourceConfiguration moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module.getName());
                if (moduleConfig != null) {
                    Map properties = moduleConfig.properties;
                    for (Map.Entry entry : properties.entrySet()) {
                        result.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
        });
        Properties properties = result;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectProperties"));
        }
        return properties;
    }

    @Nullable
    public static File getMavenProjectPath(@NotNull CompileContext context, @NotNull JpsModule module) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectPath"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "getMavenProjectPath"));
        }
        MavenProjectConfiguration projectConfig = OsgiBuildUtil.getProjectConfig(context);
        if (projectConfig == null) {
            return null;
        }
        MavenModuleResourceConfiguration moduleConfig = (MavenModuleResourceConfiguration)projectConfig.moduleConfigurations.get(module.getName());
        return moduleConfig == null ? null : new File(FileUtil.toSystemDependentName((String)moduleConfig.directory), "pom.xml");
    }

    @Nullable
    private static MavenProjectConfiguration getProjectConfig(CompileContext context) {
        BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
        return JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
    }

    @Nullable
    public static File findFileInModuleContentRoots(@NotNull JpsModule module, @NotNull String relativePath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "findFileInModuleContentRoots"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/osgi/jps/util/OsgiBuildUtil", "findFileInModuleContentRoots"));
        }
        String ioRelativePath = FileUtil.toSystemDependentName((String)relativePath);
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            File result = new File(root, ioRelativePath);
            if (!result.exists()) continue;
            return result;
        }
        return null;
    }
}

