/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import com.intellij.util.text.StringTokenizer;
import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.text.StringUtil");
    @NonNls
    private static final String VOWELS = "aeiouy";
    @NonNls
    private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
    @NonNls
    private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
    @NonNls
    private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");
    public static final NotNullFunction<String, String> QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "\"" + s + "\"";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$1", "fun"));
            }
            return string;
        }
    };
    public static final NotNullFunction<String, String> SINGLE_QUOTER = new NotNullFunction<String, String>(){

        @Override
        @NotNull
        public String fun(String s) {
            String string = "'" + s + "'";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$2", "fun"));
            }
            return string;
        }
    };
    @NotNull
    public static Function<String, String> TRIMMER = new Function<String, String>(){

        @Override
        @Nullable
        public String fun(@Nullable String s) {
            return StringUtil.trim(s);
        }
    };
    @NonNls
    private static final String[] ourPrepositions = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "if", "in", "into", "not", "of", "on", "onto", "or", "out", "over", "per", "nor", "the", "to", "up", "upon", "via", "with"};
    @NonNls
    private static final String[] REPLACES_REFS = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&quot;"};
    @NonNls
    private static final String[] REPLACES_DISP = new String[]{"<", ">", "&", "'", "\""};

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "find", "com/intellij/openapi/util/text/StringUtil", "getWordsInStringLongestFirst"));
        }
        List<String> words = StringUtil.getWordsIn(find);
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(@NotNull String o1, @NotNull String o2) {
                if (o1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/util/text/StringUtil$3", "compare"));
                }
                if (o2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/util/text/StringUtil$3", "compare"));
                }
                return o2.length() - o1.length();
            }
        });
        List<String> list = words;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getWordsInStringLongestFirst"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapePattern(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "escapePattern"));
        }
        String string = StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapePattern"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/openapi/util/text/StringUtil", "createToStringFunction"));
        }
        Function function = new Function<T, String>(){

            @Override
            public String fun(@NotNull T o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/util/text/StringUtil$4", "fun"));
                }
                return o.toString();
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "createToStringFunction"));
        }
        return function;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (oldS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldS", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (newS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newS", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        String string = StringUtil.replace(text, oldS, newS, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceIgnoreCase(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "replaceIgnoreCase"));
        }
        if (oldS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldS", "com/intellij/openapi/util/text/StringUtil", "replaceIgnoreCase"));
        }
        if (newS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newS", "com/intellij/openapi/util/text/StringUtil", "replaceIgnoreCase"));
        }
        String string = StringUtil.replace(text, oldS, newS, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "replaceIgnoreCase"));
        }
        return string;
    }

    public static void replaceChar(@NotNull char[] buffer, char oldChar, char newChar, int start, int end) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "replaceChar"));
        }
        for (int i = start; i < end; ++i) {
            char c = buffer[i];
            if (c != oldChar) continue;
            buffer[i] = newChar;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "replaceChar"));
        }
        StringBuilder newBuffer = null;
        for (int i = 0; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c == oldChar) {
                if (newBuffer == null) {
                    newBuffer = new StringBuilder(buffer.length());
                    newBuffer.append(buffer, 0, i);
                }
                newBuffer.append(newChar);
                continue;
            }
            if (newBuffer == null) continue;
            newBuffer.append(c);
        }
        String string = newBuffer == null ? buffer : newBuffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "replaceChar"));
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NonNls @NotNull String text, @NonNls @NotNull String oldS, @NonNls @NotNull String newS, boolean ignoreCase) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (oldS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldS", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (newS == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newS", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/openapi/util/text/StringUtil", "indexOfIgnoreCase"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/openapi/util/text/StringUtil", "indexOfIgnoreCase"));
        }
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/openapi/util/text/StringUtil", "indexOfIgnoreCase"));
        }
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "where", "com/intellij/openapi/util/text/StringUtil", "containsIgnoreCase"));
        }
        if (what == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/openapi/util/text/StringUtil", "containsIgnoreCase"));
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String suffix) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "endsWithIgnoreCase"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "endsWithIgnoreCase"));
        }
        return StringUtilRt.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull String str, @NonNls @NotNull String prefix) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "startsWithIgnoreCase"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtil", "startsWithIgnoreCase"));
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "html", "com/intellij/openapi/util/text/StringUtil", "stripHtml"));
        }
        if (convertBreaks) {
            html = html.replaceAll("<br/?>", "\n\n");
        }
        String string = html.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "stripHtml"));
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return str == null ? null : str.toLowerCase();
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtil", "getPackageName"));
        }
        String string = StringUtil.getPackageName(fqName, '.');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getPackageName"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getPackageName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtil", "getPackageName"));
        }
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getPackageName"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getPackageName"));
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "getLineBreakCount"));
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "containsLineBreak"));
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeLineBreak(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "escapeLineBreak"));
        }
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeLineBreak"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "endsWithLineBreak"));
        }
        int len = text.length();
        return len > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "lineColToOffset"));
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "offsetToLineNumber"));
        }
        int curLine = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return -1;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset >= text.length() - 1 || text.charAt(curOffset + 1) != '\n') continue;
            ++curOffset;
        }
        return curLine;
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/util/text/StringUtil", "difference"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/util/text/StringUtil", "difference"));
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "wordsToBeginFromUpperCase"));
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "wordsToBeginFromUpperCase"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "wordsToBeginFromLowerCase"));
        }
        String string = StringUtil.fixCapitalization(s, ourPrepositions, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "wordsToBeginFromLowerCase"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "toTitleCase"));
        }
        String string = StringUtil.fixCapitalization(s, ArrayUtil.EMPTY_STRING_ARRAY, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "toTitleCase"));
        }
        return string;
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, @NotNull String[] prepositions, boolean title) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "fixCapitalization"));
        }
        if (prepositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prepositions", "com/intellij/openapi/util/text/StringUtil", "fixCapitalization"));
        }
        StringBuilder buffer = null;
        for (int i = 0; i < s.length(); ++i) {
            int j;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            for (j = i; j < s.length() && Character.isLetterOrDigit(s.charAt(j)); ++j) {
            }
            if (StringUtil.isPreposition(s, i, j - 1, prepositions)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(i, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        if (buffer == null) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "fixCapitalization"));
            }
            return string;
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "fixCapitalization"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "isPreposition"));
        }
        return StringUtil.isPreposition(s, firstChar, lastChar, ourPrepositions);
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, @NotNull String[] prepositions) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "isPreposition"));
        }
        if (prepositions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prepositions", "com/intellij/openapi/util/text/StringUtil", "isPreposition"));
        }
        for (String preposition : prepositions) {
            boolean found = false;
            if (lastChar - firstChar + 1 == preposition.length()) {
                found = true;
                for (int j = 0; j < preposition.length(); ++j) {
                    if (StringUtil.toLowerCase(s.charAt(firstChar + j)) == preposition.charAt(j)) continue;
                    found = false;
                }
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static NotNullFunction<String, String> escaper(final boolean escapeSlash, final @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = new NotNullFunction<String, String>(){

            @Override
            @NotNull
            public String fun(@NotNull String dom) {
                if (dom == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dom", "com/intellij/openapi/util/text/StringUtil$6", "fun"));
                }
                StringBuilder builder = new StringBuilder(dom.length());
                StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
                String string = builder.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$6", "fun"));
                }
                return string;
            }
        };
        if (notNullFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escaper"));
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        StringBuilder stringBuilder = StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        return stringBuilder;
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull @NonNls StringBuilder buffer) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (!StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtilRt.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append(hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    private static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeStringCharacters"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "escapeCharCharacters"));
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeCharCharacters"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "unescapeStringCharacters"));
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unescapeStringCharacters"));
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "isQuoteAt"));
        }
        char ch = s.charAt(ind);
        return ch == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "isQuotedString"));
        }
        return s.length() > 1 && StringUtil.isQuoteAt(s, 0) && s.charAt(0) == s.charAt(s.length() - 1);
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
        }
        if (StringUtil.isQuotedString(s)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
        }
        if (s.length() > 1 && quotationChar == s.charAt(0) && quotationChar == s.charAt(s.length() - 1)) {
            String string = s.substring(1, s.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unquoteString"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String quoteReplacement(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "quoteReplacement"));
        }
        boolean needReplacements = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '$') continue;
            needReplacements = true;
            break;
        }
        if (!needReplacements) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "quoteReplacement"));
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(s.length() * 6 / 5);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "quoteReplacement"));
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "unescapeStringCharacters"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "unescapeStringCharacters"));
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String suggestion) {
        if (suggestion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestion", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
        }
        if (suggestion.endsWith("Child") || suggestion.endsWith("child")) {
            String string = suggestion + "ren";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return string;
        }
        if (suggestion.equals("this")) {
            if ("these" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return "these";
        }
        if (suggestion.equals("This")) {
            if ("These" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return "These";
        }
        if (StringUtil.endsWithIgnoreCase(suggestion, "s") || StringUtil.endsWithIgnoreCase(suggestion, "x") || StringUtil.endsWithIgnoreCase(suggestion, "ch")) {
            String string = suggestion + "es";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return string;
        }
        int len = suggestion.length();
        if (StringUtil.endsWithIgnoreCase(suggestion, "y") && len > 1 && !StringUtil.isVowel(StringUtil.toLowerCase(suggestion.charAt(len - 2)))) {
            String string = suggestion.substring(0, len - 1) + "ies";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return string;
        }
        String string = suggestion + "s";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "capitalizeWords"));
        }
        String string = StringUtil.capitalizeWords(text, " \t\n\r\f", allWords, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalizeWords"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelim, boolean allWords, boolean leaveOriginalDelims) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "capitalizeWords"));
        }
        if (tokenizerDelim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenizerDelim", "com/intellij/openapi/util/text/StringUtil", "capitalizeWords"));
        }
        java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(text, tokenizerDelim, leaveOriginalDelims);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelims && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalizeWords"));
        }
        return string;
    }

    @Contract(pure=true)
    public static String decapitalize(String s) {
        return Introspector.decapitalize(s);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return VOWELS.indexOf(c) >= 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "capitalize"));
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalize"));
            }
            return string;
        }
        if (s.length() == 1) {
            String string = StringUtilRt.toUpperCase(s);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalize"));
            }
            return string;
        }
        if (Character.isUpperCase(s.charAt(0))) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalize"));
            }
            return string;
        }
        String string = StringUtil.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalize"));
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return s != null && !s.isEmpty() && Character.isUpperCase(s.charAt(0));
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "capitalizeWithJavaBeanConvention"));
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalizeWithJavaBeanConvention"));
            }
            return string;
        }
        String string = StringUtil.capitalize(s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalizeWithJavaBeanConvention"));
        }
        return string;
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCode"));
        }
        if (chars instanceof String) {
            return chars.hashCode();
        }
        if (chars instanceof CharSequenceWithStringHash) {
            return chars.hashCode();
        }
        if (chars instanceof CharArrayCharSequence) {
            return chars.hashCode();
        }
        return StringUtil.stringHashCode(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCode"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars.charAt(off);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + chars[off];
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull char[] chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeInsensitive"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars[off]);
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeInsensitive"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            h = 31 * h + StringUtil.toLowerCase(chars.charAt(off));
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeInsensitive"));
        }
        return StringUtil.stringHashCodeInsensitive(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(char[] chars, int from, int to) {
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars[off];
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeIgnoreWhitespaces"));
        }
        int h = 0;
        for (int off = from; off < to; ++off) {
            char c = chars.charAt(off);
            if (StringUtil.isWhiteSpace(c)) continue;
            h = 31 * h + c;
        }
        return h;
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "stringHashCodeIgnoreWhitespaces"));
        }
        return StringUtil.stringHashCodeIgnoreWhitespaces(chars, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenation"));
        }
        if (prefixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefixes", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenation"));
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        if (firstPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstPrefix", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        if (secondPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondPrefix", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix);
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenationOf(@NotNull String string, @NotNull String firstPrefix, @NotNull String secondPrefix, @NotNull String thirdPrefix) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        if (firstPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstPrefix", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        if (secondPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondPrefix", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        if (thirdPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thirdPrefix", "com/intellij/openapi/util/text/StringUtil", "startsWithConcatenationOf"));
        }
        return StringUtil.startsWithConcatenation(string, firstPrefix, secondPrefix, thirdPrefix);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @NotNull
    @Contract(pure=true)
    public static String trimEnd(@NotNull String s, @NonNls @NotNull String suffix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (s.endsWith(suffix)) {
            String string = s.substring(0, s.length() - suffix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLog(@NotNull String text, int limit) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "trimLog"));
        }
        if (limit > 5 && text.length() > limit) {
            String string = text.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimLog"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimLog"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        String string2 = ((Object)StringUtil.trimLeading((CharSequence)string)).toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimLeading"));
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "trimTrailing"));
        }
        String string2 = ((Object)StringUtil.trimTrailing((CharSequence)string)).toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimTrailing"));
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "trimTrailing"));
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimTrailing"));
        }
        return charSequence;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return StringUtilRt.endsWithChar(s, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static String trimStart(@NotNull String s, @NonNls @NotNull String prefix) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        if (s.startsWith(prefix)) {
            String string = s.substring(prefix.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
            }
            return string;
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimStart"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String pluralize(@NotNull String base, int n) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
        }
        if (n == 1) {
            String string = base;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
            }
            return string;
        }
        String string = StringUtil.pluralize(base);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "pluralize"));
        }
        return string;
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "repeatSymbol"));
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return s != null && !s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s) {
        String string = StringUtil.notNullize(s, "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "notNullize"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/openapi/util/text/StringUtil", "notNullize"));
        }
        String string = s == null ? defaultValue : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "notNullize"));
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s) {
        return StringUtil.nullize(s, false);
    }

    @Nullable
    @Contract(pure=true)
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        if (nullizeSpaces ? StringUtil.isEmptyOrSpaces(s) : StringUtil.isEmpty(s)) {
            return null;
        }
        return s;
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        if (StringUtil.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) <= ' ') continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return c == '\n' || c == '\t' || c == ' ';
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aThrowable", "com/intellij/openapi/util/text/StringUtil", "getThrowableText"));
        }
        String string = ExceptionUtil.getThrowableText(aThrowable);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getThrowableText"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getThrowableText(@NotNull Throwable aThrowable, @NonNls @NotNull String stackFrameSkipPattern) {
        if (aThrowable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aThrowable", "com/intellij/openapi/util/text/StringUtil", "getThrowableText"));
        }
        if (stackFrameSkipPattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrameSkipPattern", "com/intellij/openapi/util/text/StringUtil", "getThrowableText"));
        }
        String string = ExceptionUtil.getThrowableText(aThrowable, stackFrameSkipPattern);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getThrowableText"));
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/text/StringUtil", "getMessage"));
        }
        return ExceptionUtil.getMessage(e);
    }

    @NotNull
    @Contract(pure=true)
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        String string = StringFactory.createShared(buffer);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "repeatSymbol"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "repeat"));
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "repeat"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "splitHonorQuotes"));
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(s.length());
        boolean inQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "splitHonorQuotes"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        List<String> list = StringUtil.split(s, separator, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        List<CharSequence> list = StringUtil.split(s, separator, true, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        List<String> list = StringUtil.split(s, separator, excludeSeparator, true);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        List<CharSequence> list = StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        if (separator.length() == 0) {
            List<CharSequence> list = Collections.singletonList(s);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
            }
            return list;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "split"));
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "tokenize"));
        }
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "com/intellij/openapi/util/text/StringUtil", "tokenize"));
        }
        final StringTokenizer tokenizer = new StringTokenizer(s, separators);
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$7", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "tokenize"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static Iterable<String> tokenize(final @NotNull java.util.StringTokenizer tokenizer) {
        if (tokenizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenizer", "com/intellij/openapi/util/text/StringUtil", "tokenize"));
        }
        Iterable<String> iterable = new Iterable<String>(){

            @Override
            @NotNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return tokenizer.hasMoreTokens();
                    }

                    @Override
                    public String next() {
                        return tokenizer.nextToken();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$8", "iterator"));
                }
                return iterator;
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "tokenize"));
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "getWordsIn"));
        }
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            List<String> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getWordsIn"));
            }
            return list;
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getWordsIn"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "getWordIndicesIn"));
        }
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1 && start != -1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getWordIndicesIn"));
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        String string = StringUtil.join(strings, 0, strings.length, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull String[] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] zip(@NotNull String[] strings1, @NotNull String[] strings2, String separator) {
        if (strings1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings1", "com/intellij/openapi/util/text/StringUtil", "zip"));
        }
        if (strings2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings2", "com/intellij/openapi/util/text/StringUtil", "zip"));
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "zip"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] surround(@NotNull String[] strings1, String prefix, String suffix) {
        if (strings1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings1", "com/intellij/openapi/util/text/StringUtil", "surround"));
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings1[i] + suffix;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "surround"));
        }
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull T[] items, @NotNull Function<T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        String string = StringUtil.join(Arrays.asList(items), f, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (items.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
            }
            return "";
        }
        String string = StringUtil.join(items, f, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull Function<? super T, String> f, @NotNull @NonNls String separator) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (T item : items) {
            String string = f.fun(item);
            if (string == null || string.isEmpty()) continue;
            if (result.length() != 0) {
                result.append(separator);
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<? extends String> strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(strings, separator, result);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    public static void join(@NotNull Collection<? extends String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull int[] strings, @NotNull String separator) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(String ... strings) {
        if (strings == null || strings.length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String string : strings) {
            builder.append(string);
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "join"));
        }
        return string;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    public static String stripQuotesAroundValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "stripQuotesAroundValue"));
        }
        int len = text.length();
        if (len > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text.substring(from, to);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "stripQuotesAroundValue"));
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "stripQuotesAroundValue"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatFileSize(long size) {
        String string = StringUtil.formatValue(size, false, new String[]{"", "K", "M", "G", "T", "P"}, new long[]{1000L, 1000L, 1000L, 1000L, 1000L});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "formatFileSize"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatDuration(long duration) {
        String string = StringUtil.formatValue(duration, true, new String[]{"ms", "sec", "min", "h", "d"}, new long[]{1000L, 60L, 60L, 24L});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "formatDuration"));
        }
        return string;
    }

    @NotNull
    private static String formatValue(long value, boolean decimalsOnly, String[] units, long[] multipliers) {
        long count = value;
        long remainder = 0L;
        String suffix = units[0];
        for (int i = 0; i < units.length; ++i) {
            long multiplier;
            suffix = units[i];
            long l = multiplier = i < multipliers.length ? multipliers[i] : -1L;
            if (multiplier == -1L || count < multiplier) break;
            remainder = count % multiplier * 100L / multiplier;
            count /= multiplier;
        }
        String string = count + (remainder == 0L || decimalsOnly && remainder <= 9L ? "" : (remainder <= 9L ? ".0" : ".") + remainder) + suffix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "formatValue"));
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String unpluralize(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/text/StringUtil", "unpluralize"));
        }
        if (name.endsWith("sses") || name.endsWith("shes") || name.endsWith("ches") || name.endsWith("xes")) {
            return name.substring(0, name.length() - 2);
        }
        if (name.endsWith("ses")) {
            return name.substring(0, name.length() - 1);
        }
        if (name.endsWith("ies")) {
            if (name.endsWith("cookies") || name.endsWith("Cookies")) {
                return name.substring(0, name.length() - "ookies".length()) + "ookie";
            }
            return name.substring(0, name.length() - 3) + "y";
        }
        if (name.endsWith("leaves") || name.endsWith("Leaves")) {
            return name.substring(0, name.length() - "eaves".length()) + "eaf";
        }
        String result = StringUtil.stripEnding(name, "s");
        if (result != null) {
            return result;
        }
        if (name.endsWith("children")) {
            return name.substring(0, name.length() - "children".length()) + "child";
        }
        if (name.endsWith("Children") && name.length() > "Children".length()) {
            return name.substring(0, name.length() - "Children".length()) + "Child";
        }
        return null;
    }

    @Nullable
    @Contract(pure=true)
    private static String stripEnding(@NotNull String name, @NotNull String ending) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/text/StringUtil", "stripEnding"));
        }
        if (ending == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ending", "com/intellij/openapi/util/text/StringUtil", "stripEnding"));
        }
        if (name.endsWith(ending)) {
            if (name.equals(ending)) {
                return name;
            }
            return name.substring(0, name.length() - 1);
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/text/StringUtil", "containsAlphaCharacters"));
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/text/StringUtil", "containsAnyChar"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "containsAnyChar"));
        }
        if (chars.length() > value.length()) {
            return StringUtil.containsAnyChar(value, chars, 0, value.length());
        }
        return StringUtil.containsAnyChar(chars, value, 0, chars.length());
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/text/StringUtil", "containsAnyChar"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "containsAnyChar"));
        }
        for (int i = start; i < end; ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/text/StringUtil", "containsChar"));
        }
        return value.indexOf(ch) >= 0;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String firstLetterToUpperCase(@Nullable String displayString) {
        if (displayString == null || displayString.isEmpty()) {
            return displayString;
        }
        char firstChar = displayString.charAt(0);
        char uppedFirstChar = StringUtil.toUpperCase(firstChar);
        if (uppedFirstChar == firstChar) {
            return displayString;
        }
        char[] buffer = displayString.toCharArray();
        buffer[0] = uppedFirstChar;
        return StringFactory.createShared(buffer);
    }

    @NotNull
    @Contract(pure=true)
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "strip"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/util/text/StringUtil", "strip"));
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "strip"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        List<String> list = StringUtil.findMatches(s, pattern, 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "findMatches"));
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "findFirst"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/openapi/util/text/StringUtil", "findFirst"));
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    @Contract(pure=true)
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "replaceSubstring"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/util/text/StringUtil", "replaceSubstring"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/openapi/util/text/StringUtil", "replaceSubstring"));
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "replaceSubstring"));
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "startsWithWhitespace"));
        }
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "startsWith"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtil", "startsWith"));
        }
        int l1 = text.length();
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "startsWith"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/text/StringUtil", "startsWith"));
        }
        int l1 = text.length() - startIndex;
        if (l1 < (l2 = prefix.length())) {
            return false;
        }
        for (int i = 0; i < l2; ++i) {
            if (text.charAt(i + startIndex) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "endsWith"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/text/StringUtil", "endsWith"));
        }
        int l1 = text.length();
        if (l1 < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/util/text/StringUtil", "commonPrefix"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/util/text/StringUtil", "commonPrefix"));
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "commonPrefix"));
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/util/text/StringUtil", "commonPrefixLength"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/util/text/StringUtil", "commonPrefixLength"));
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    @NotNull
    @Contract(pure=true)
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/util/text/StringUtil", "commonSuffix"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/util/text/StringUtil", "commonSuffix"));
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "commonSuffix"));
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/openapi/util/text/StringUtil", "commonSuffixLength"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/openapi/util/text/StringUtil", "commonSuffixLength"));
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "contains"));
        }
        return StringUtil.indexOf(s, c, start, end) >= 0;
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        return StringUtil.indexOf(s, c, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        return StringUtil.indexOf(s, c, start, s.length());
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/util/text/StringUtil", "contains"));
        }
        if (infix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infix", "com/intellij/openapi/util/text/StringUtil", "contains"));
        }
        return StringUtil.indexOf(sequence, infix) >= 0;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        if (infix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infix", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        return StringUtil.indexOf(sequence, infix, 0);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        if (infix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infix", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        for (int i = start; i <= sequence.length() - infix.length(); ++i) {
            if (!StringUtil.startsWith(sequence, i, infix)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s.charAt(i), c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull char[] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOf"));
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.charsMatch(s[i], c, !caseSensitive)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "indexOfSubstringEnd"));
        }
        if (subString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subString", "com/intellij/openapi/util/text/StringUtil", "indexOfSubstringEnd"));
        }
        int i = text.indexOf(subString);
        if (i == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        return StringUtil.indexOfAny(s, chars, 0, s.length());
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        return StringUtil.indexOfAny((CharSequence)s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "indexOfAny"));
        }
        for (int i = start; i < end; ++i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @Contract(pure=true)
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "substringBefore"));
        }
        if (subString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subString", "com/intellij/openapi/util/text/StringUtil", "substringBefore"));
        }
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @Nullable
    @Contract(pure=true)
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "substringAfter"));
        }
        if (subString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subString", "com/intellij/openapi/util/text/StringUtil", "substringAfter"));
        }
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "lastIndexOf"));
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @NotNull
    @Contract(pure=true)
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "first"));
        }
        String string = text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? "..." : "") : text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "first"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "first"));
        }
        CharSequence charSequence = text.length() > length ? text.subSequence(0, length) + (appendEllipsis ? "..." : "") : text;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "first"));
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "last"));
        }
        CharSequence charSequence = text.length() > length ? (prependEllipsis ? "..." : "") + text.subSequence(text.length() - length, text.length()) : text;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "last"));
        }
        return charSequence;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeChar"));
        }
        StringBuilder buf = new StringBuilder(str);
        StringUtil.escapeChar(buf, character);
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeChar"));
        }
        return string;
    }

    private static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/util/text/StringUtil", "escapeChar"));
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeQuotes"));
        }
        String string = StringUtil.escapeChar(str, '\"');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeQuotes"));
        }
        return string;
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/util/text/StringUtil", "escapeQuotes"));
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeSlashes"));
        }
        String string = StringUtil.escapeChar(str, '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeSlashes"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "escapeBackSlashes"));
        }
        String string = StringUtil.escapeChar(str, '\\');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeBackSlashes"));
        }
        return string;
    }

    public static void escapeSlashes(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/util/text/StringUtil", "escapeSlashes"));
        }
        StringUtil.escapeChar(buf, '/');
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "unescapeSlashes"));
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '/');
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unescapeSlashes"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "unescapeBackSlashes"));
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unescapeBackSlashes"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "unescapeChar"));
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "unescapeChar"));
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/openapi/util/text/StringUtil", "unescapeChar"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "unescapeChar"));
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/StringUtil", "quote"));
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/StringUtil", "quote"));
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @NotNull
    @Contract(pure=true)
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/text/StringUtil", "wrapWithDoubleQuote"));
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "wrapWithDoubleQuote"));
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_REFS, REPLACES_DISP);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        if (text == null) {
            return null;
        }
        return StringUtil.replace(text, REPLACES_DISP, REPLACES_REFS);
    }

    @NotNull
    @Contract(pure=true)
    public static String htmlEmphasize(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "htmlEmphasize"));
        }
        String string = "<b><code>" + StringUtil.escapeXml(text) + "</code></b>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "htmlEmphasize"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "escapeToRegexp"));
        }
        StringBuilder result = new StringBuilder(text.length());
        String string = StringUtil.escapeToRegexp(text, result).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeToRegexp"));
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "escapeToRegexp"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/openapi/util/text/StringUtil", "escapeToRegexp"));
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                builder.append(c);
                continue;
            }
            if (c == '\n') {
                builder.append("\\n");
                continue;
            }
            builder.append('\\').append(c);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeToRegexp"));
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isNotEscapedBackslash(@NotNull char[] chars, int startOffset, int backslashOffset) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/util/text/StringUtil", "isNotEscapedBackslash"));
        }
        if (chars[backslashOffset] != '\\') {
            return false;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = chars[i] == '\\' ? !escaped : false;
        }
        return !escaped;
    }

    @Contract(pure=true)
    public static boolean isNotEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "isNotEscapedBackslash"));
        }
        if (text.charAt(backslashOffset) != '\\') {
            return false;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return !escaped;
    }

    @NotNull
    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String[] from, @NotNull String[] to) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        StringBuilder result = new StringBuilder(text.length());
        block0: for (int i = 0; i < text.length(); ++i) {
            for (int j = 0; j < from.length; ++j) {
                String toReplace = from[j];
                String replaceWith = to[j];
                int len = toReplace.length();
                if (!text.regionMatches(i, toReplace, 0, len)) continue;
                result.append(replaceWith);
                i += len - 1;
                continue block0;
            }
            result.append(text.charAt(i));
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "replace"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] filterEmptyStrings(@NotNull String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/util/text/StringUtil", "filterEmptyStrings"));
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "filterEmptyStrings"));
            }
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "filterEmptyStrings"));
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "countNewLines"));
        }
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "countChars"));
        }
        return StringUtil.countChars(text, c, 0, false);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean continuous) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "countChars"));
        }
        int count = 0;
        for (int i = offset; i < text.length(); ++i) {
            if (text.charAt(i) == c) {
                ++count;
                continue;
            }
            if (continuous) break;
        }
        return count;
    }

    @NotNull
    @Contract(pure=true)
    public static String capitalsOnly(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "capitalsOnly"));
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            b.append(s.charAt(i));
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "capitalsOnly"));
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String joinOrNull(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/openapi/util/text/StringUtil", "joinOrNull"));
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Nullable
    @Contract(pure=true)
    public static String getPropertyName(@NonNls @NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/openapi/util/text/StringUtil", "getPropertyName"));
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || StringUtil.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "isJavaIdentifier"));
        }
        int len = text.length();
        if (len == 0) {
            return false;
        }
        if (!StringUtil.isJavaIdentifierStart(text.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (StringUtil.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    @Contract(pure=true)
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/openapi/util/text/StringUtil", "escapeProperty"));
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "escapeProperty"));
        }
        return string;
    }

    @Contract(pure=true)
    public static String getQualifiedName(@Nullable String packageName, String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "getOccurrenceCount"));
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "getOccurrenceCount"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "getOccurrenceCount"));
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/text/StringUtil", "fixVariableNameDerivedFromPropertyName"));
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "fixVariableNameDerivedFromPropertyName"));
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "fixVariableNameDerivedFromPropertyName"));
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "fixVariableNameDerivedFromPropertyName"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/text/StringUtil", "sanitizeJavaIdentifier"));
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "sanitizeJavaIdentifier"));
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "assertValidSeparators"));
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            LOG.error("Wrong line separators: '" + context + "' at offset " + slashRIndex);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "tail"));
        }
        String string = idx >= s.length() ? "" : s.substring(idx, s.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "tail"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "splitByLines"));
        }
        String[] stringArray = StringUtil.splitByLines(string, true);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "splitByLines"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "splitByLines"));
        }
        String[] stringArray = (excludeEmptyStrings ? EOL_SPLIT_PATTERN : EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "splitByLines"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "splitByLinesDontTrim"));
        }
        String[] stringArray = EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "splitByLinesDontTrim"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "splitByLinesKeepSeparators"));
        }
        String[] stringArray = EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "splitByLinesKeepSeparators"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "getWordsWithOffset"));
        }
        ArrayList<Pair<String, Integer>> res = ContainerUtil.newArrayList();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getWordsWithOffset"));
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return StringUtil.naturalCompare(string1, string2, false);
    }

    @Contract(pure=true)
    private static int naturalCompare(@Nullable String string1, @Nullable String string2, boolean caseSensitive) {
        int j;
        if (string1 == string2) {
            return 0;
        }
        if (string1 == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        int string1Length = string1.length();
        int string2Length = string2.length();
        int i = 0;
        for (j = 0; i < string1Length && j < string2Length; ++i, ++j) {
            int diff2;
            int diff1;
            char ch1 = string1.charAt(i);
            char ch2 = string2.charAt(j);
            if ((StringUtil.isDecimalDigit(ch1) || ch1 == ' ') && (StringUtil.isDecimalDigit(ch2) || ch2 == ' ')) {
                int startNum1 = i;
                while ((ch1 == ' ' || ch1 == '0') && ++startNum1 < string1Length) {
                    ch1 = string1.charAt(startNum1);
                }
                int startNum2 = j;
                while ((ch2 == ' ' || ch2 == '0') && ++startNum2 < string2Length) {
                    ch2 = string2.charAt(startNum2);
                }
                j = startNum2;
                for (i = startNum1; i < string1Length && StringUtil.isDecimalDigit(string1.charAt(i)); ++i) {
                }
                while (j < string2Length && StringUtil.isDecimalDigit(string2.charAt(j))) {
                    ++j;
                }
                int lengthDiff = i - startNum1 - (j - startNum2);
                if (lengthDiff != 0) {
                    return lengthDiff;
                }
                while (startNum1 < i) {
                    int diff = string1.charAt(startNum1) - string2.charAt(startNum2);
                    if (diff != 0) {
                        return diff;
                    }
                    ++startNum1;
                    ++startNum2;
                }
                --i;
                --j;
                continue;
            }
            if (caseSensitive) {
                return ch1 - ch2;
            }
            if (ch1 == ch2 || (diff1 = StringUtilRt.toUpperCase(ch1) - StringUtilRt.toUpperCase(ch2)) == 0 || (diff2 = StringUtilRt.toLowerCase(ch1) - StringUtilRt.toLowerCase(ch2)) == 0) continue;
            return diff2;
        }
        if (i < string1Length) {
            return 1;
        }
        if (j < string2Length) {
            return -1;
        }
        if (!caseSensitive && string1Length == string2Length) {
            return StringUtil.naturalCompare(string1, string2, true);
        }
        return string1Length - string2Length;
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static int hashCode(@NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "hashCode"));
        }
        return StringUtil.stringHashCode(s);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            if (StringUtil.charsMatch(s1.charAt(i), s2.charAt(i), true)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1 == null) {
            return true;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int index1 = 0;
        int index2 = 0;
        while (index1 < len1 && index2 < len2) {
            if (s1.charAt(index1) == s2.charAt(index2)) {
                ++index1;
                ++index2;
                continue;
            }
            boolean skipped = false;
            while (index1 != len1 && StringUtil.isWhiteSpace(s1.charAt(index1))) {
                skipped = true;
                ++index1;
            }
            while (index2 != len2 && StringUtil.isWhiteSpace(s2.charAt(index2))) {
                skipped = true;
                ++index2;
            }
            if (skipped) continue;
            return false;
        }
        while (index1 != len1) {
            if (!StringUtil.isWhiteSpace(s1.charAt(index1))) {
                return false;
            }
            ++index1;
        }
        while (index2 != len2) {
            if (!StringUtil.isWhiteSpace(s2.charAt(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        char u2;
        int d = c1 - c2;
        if (d == 0 || !ignoreCase) {
            return d;
        }
        char u1 = StringUtilRt.toUpperCase(c1);
        d = u1 - (u2 = StringUtilRt.toUpperCase(c2));
        if (d != 0) {
            d = StringUtilRt.toLowerCase(u1) - StringUtilRt.toLowerCase(u2);
        }
        return d;
    }

    @Contract(pure=true)
    public static boolean charsMatch(char c1, char c2, boolean ignoreCase) {
        return StringUtil.compare(c1, c2, ignoreCase) == 0;
    }

    @NotNull
    @Contract(pure=true)
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/openapi/util/text/StringUtil", "formatLinks"));
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z0-9\\./\\-\\+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "formatLinks"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String trimMiddle(@NotNull String text, int maxLength) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "trimMiddle"));
        }
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "trimMiddle"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        int textLength = text.length();
        if (textLength > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength > 0);
            String string = text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
            }
            return string;
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        String string = StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenTextWithEllipsis"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/text/StringUtil", "shortenPathWithEllipsis"));
        }
        String string = StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenPathWithEllipsis"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/text/StringUtil", "shortenPathWithEllipsis"));
        }
        String string = StringUtil.shortenPathWithEllipsis(path, maxLength, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "shortenPathWithEllipsis"));
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean charsEqual(char a, char b, boolean ignoreCase) {
        return ignoreCase ? StringUtil.charsEqualIgnoreCase(a, b) : a == b;
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return StringUtilRt.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return StringUtilRt.toUpperCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String toUpperCase(@NotNull String a) {
        if (a == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a", "com/intellij/openapi/util/text/StringUtil", "toUpperCase"));
        }
        String string = StringUtilRt.toUpperCase(a);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "toUpperCase"));
        }
        return string;
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return StringUtilRt.toLowerCase(a);
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, keepCarriageReturn);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        return string;
    }

    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator, @Nullable int[] offsetsToKeep, boolean keepCarriageReturn) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        if (newSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSeparator", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator, offsetsToKeep, keepCarriageReturn);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "convertLineSeparators"));
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static boolean parseBoolean(String string, boolean defaultValue) {
        return StringUtilRt.parseBoolean(string, defaultValue);
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String getShortName(@NotNull String fqName, char separator) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        String string = StringUtilRt.getShortName(fqName, separator);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "getShortName"));
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/util/text/StringUtil", "newBombedCharSequence"));
        }
        final long myTime = System.currentTimeMillis() + delay;
        BombedCharSequence bombedCharSequence = new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
        if (bombedCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil", "newBombedCharSequence"));
        }
        return bombedCharSequence;
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (end == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "end", "com/intellij/openapi/util/text/StringUtil", "trimEnd"));
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/openapi/util/text/StringUtil", "isBetween"));
        }
        if (smallPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smallPart", "com/intellij/openapi/util/text/StringUtil", "isBetween"));
        }
        if (bigPart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bigPart", "com/intellij/openapi/util/text/StringUtil", "isBetween"));
        }
        String s = string.toLowerCase();
        return s.startsWith(smallPart.toLowerCase()) && bigPart.toLowerCase().startsWith(s);
    }

    @Contract(pure=true)
    public static String getShortened(@NotNull String s, int maxWidth) {
        int index;
        String aWord;
        int i;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/text/StringUtil", "getShortened"));
        }
        int length = s.length();
        if (StringUtil.isEmpty(s) || length <= maxWidth) {
            return s;
        }
        ArrayList<String> words = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (i == length - 1) {
                builder.append(ch);
                words.add(builder.toString());
                builder.delete(0, builder.length());
                continue;
            }
            if (i > 0 && (ch == '/' || ch == '\\' || ch == '.' || ch == '-' || Character.isUpperCase(ch))) {
                words.add(builder.toString());
                builder.delete(0, builder.length());
            }
            builder.append(ch);
        }
        for (i = 0; i < words.size(); ++i) {
            String word = (String)words.get(i);
            if (i >= words.size() - 1 || word.length() != 1) continue;
            words.remove(i);
            words.set(i, word + (String)words.get(i));
        }
        int removedLength = 0;
        String toPaste = "...";
        do {
            index = Math.max(0, (words.size() - 1) / 2);
            aWord = (String)words.get(index);
            words.remove(index);
            int toCut = length - removedLength - maxWidth + 3;
            if (words.size() >= 2 && (toCut >= aWord.length() - 2 || removedLength != 0)) continue;
            int pos = (aWord.length() - toCut) / 2;
            toPaste = aWord.substring(0, pos) + "..." + aWord.substring(pos + toCut);
            break;
        } while (length - (removedLength += aWord.length()) > maxWidth - 3);
        for (int i2 = 0; i2 < Math.max(1, words.size()); ++i2) {
            String word;
            String string = word = words.isEmpty() ? "" : (String)words.get(i2);
            if (i2 == index || words.size() == 1) {
                builder.append(toPaste);
            }
            builder.append(word);
        }
        return builder.toString().replaceAll("\\.{4,}", "...");
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;

        public BombedCharSequence(@NotNull CharSequence sequence) {
            if (sequence == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/openapi/util/text/StringUtil$BombedCharSequence", "<init>"));
            }
            this.i = 0;
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            String string = ((Object)this.delegate).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/text/StringUtil$BombedCharSequence", "toString"));
            }
            return string;
        }

        protected abstract void checkCanceled();

        @Override
        public CharSequence subSequence(int i, int i1) {
            this.check();
            return this.delegate.subSequence(i, i1);
        }
    }
}

