/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.FileLoader;
import com.intellij.util.lang.JarLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import sun.misc.Resource;

public class ClassPath {
    private static final ResourceStringLoaderIterator ourCheckedIterator = new ResourceStringLoaderIterator(true);
    private static final ResourceStringLoaderIterator ourUncheckedIterator = new ResourceStringLoaderIterator(false);
    private static final LoaderCollector ourLoaderCollector = new LoaderCollector();
    private final Stack<URL> myUrls = new Stack();
    private final List<Loader> myLoaders = new ArrayList<Loader>();
    private final Map<URL, Loader> myLoadersMap = new HashMap<URL, Loader>();
    private final ClasspathCache myCache = new ClasspathCache();
    private final boolean myCanLockJars;
    private final boolean myCanUseCache;
    private final boolean myAcceptUnescapedUrls;
    private final boolean myPreloadJarContents;
    private final boolean myCanHavePersistentIndex;
    @Nullable
    private final CachePoolImpl myCachePool;
    @Nullable
    private final UrlClassLoader.CachingCondition myCachingCondition;
    private static final boolean ourDumpOrder = "true".equals(System.getProperty("idea.dump.order"));
    private static PrintStream ourOrder;
    private static long ourOrderSize;
    private static final Set<String> ourOrderedUrls;
    private static final boolean ourLogTiming;
    private static long ourTotalTime;
    private static int ourTotalRequests;

    public ClassPath(List<URL> urls, boolean canLockJars, boolean canUseCache, boolean acceptUnescapedUrls, boolean preloadJarContents, boolean canHavePersistentIndex, @Nullable CachePoolImpl cachePool, @Nullable UrlClassLoader.CachingCondition cachingCondition) {
        this.myCanLockJars = canLockJars;
        this.myCanUseCache = canUseCache;
        this.myAcceptUnescapedUrls = acceptUnescapedUrls;
        this.myPreloadJarContents = preloadJarContents;
        this.myCachePool = cachePool;
        this.myCachingCondition = cachingCondition;
        this.myCanHavePersistentIndex = canHavePersistentIndex;
        this.push(urls);
    }

    void addURL(URL url) {
        this.push(Collections.singletonList(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(List<URL> urls) {
        if (!urls.isEmpty()) {
            Stack<URL> stack = this.myUrls;
            synchronized (stack) {
                for (int i = urls.size() - 1; i >= 0; --i) {
                    this.myUrls.push(urls.get(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Resource getResource(String s, boolean flag) {
        long started = ClassPath.startTiming();
        try {
            Resource resource;
            Loader loader;
            int i;
            if (this.myCanUseCache) {
                Resource prevResource = this.myCache.iterateLoaders(s, flag ? ourCheckedIterator : ourUncheckedIterator, s, this);
                if (prevResource != null) {
                    Resource resource2 = prevResource;
                    return resource2;
                }
                Stack<URL> stack = this.myUrls;
                synchronized (stack) {
                    if (this.myUrls.isEmpty()) {
                        Resource resource3 = null;
                        return resource3;
                    }
                }
                i = this.myLoaders.size();
            } else {
                i = 0;
            }
            String shortName = ClasspathCache.transformName(s);
            do {
                if ((loader = this.getLoader(i++)) == null) return null;
            } while (this.myCanUseCache && !this.myCache.loaderHasName(s, shortName, loader) || (resource = loader.getResource(s, flag)) == null);
            Resource resource4 = resource;
            return resource4;
        }
        finally {
            ClassPath.logTiming(this, started, s);
        }
    }

    public Enumeration<URL> getResources(String name, boolean check) {
        return new MyEnumeration(name, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private synchronized Loader getLoader(int i) {
        while (this.myLoaders.size() < i + 1) {
            Loader loader;
            boolean lastOne;
            URL url;
            block9: {
                Stack<URL> stack = this.myUrls;
                synchronized (stack) {
                    if (this.myUrls.empty()) {
                        if (this.myCanUseCache) {
                            this.myCache.nameSymbolsLoaded();
                        }
                        return null;
                    }
                    url = this.myUrls.pop();
                    lastOne = this.myUrls.isEmpty();
                }
                if (this.myLoadersMap.containsKey(url)) continue;
                try {
                    loader = this.getLoader(url, this.myLoaders.size());
                    if (loader == null) {
                    }
                    break block9;
                }
                catch (IOException e) {
                    Logger.getInstance(ClassPath.class).debug("url: " + url, e);
                }
                continue;
            }
            this.myLoaders.add(loader);
            this.myLoadersMap.put(url, loader);
            if (!lastOne || !this.myCanUseCache) continue;
            this.myCache.nameSymbolsLoaded();
        }
        return this.myLoaders.get(i);
    }

    @Nullable
    private Loader getLoader(URL url, int index) throws IOException {
        String path;
        if (this.myAcceptUnescapedUrls) {
            path = url.getFile();
        } else {
            try {
                path = url.toURI().getSchemeSpecificPart();
            }
            catch (URISyntaxException e) {
                Logger.getInstance(ClassPath.class).error("url: " + url, e);
                path = url.getFile();
            }
        }
        Loader loader = null;
        if (path != null && "file".equals(url.getProtocol())) {
            File file = new File(path);
            if (file.isDirectory()) {
                loader = new FileLoader(url, index, this.myCanHavePersistentIndex);
            } else if (file.isFile()) {
                loader = new JarLoader(url, this.myCanLockJars, index, this.myPreloadJarContents);
            }
        }
        if (loader != null && this.myCanUseCache) {
            ClasspathCache.LoaderData data;
            ClasspathCache.LoaderData loaderData = data = this.myCachePool == null ? null : this.myCachePool.getCachedData(url);
            if (data == null) {
                data = loader.buildData();
                if (this.myCachePool != null && this.myCachingCondition != null && this.myCachingCondition.shouldCacheData(url)) {
                    this.myCachePool.cacheData(url, data);
                }
            }
            this.myCache.applyLoaderData(data, loader);
        }
        return loader;
    }

    private static synchronized void printOrder(Loader loader, String url, Resource resource) {
        if (!ourDumpOrder) {
            return;
        }
        if (!ourOrderedUrls.add(url)) {
            return;
        }
        String home = FileUtil.toSystemIndependentName(PathManager.getHomePath());
        try {
            ourOrderSize += (long)resource.getContentLength();
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        if (ourOrder == null) {
            File orderFile = new File(PathManager.getBinPath() + File.separator + "order.txt");
            try {
                if (!FileUtil.ensureCanCreateFile(orderFile)) {
                    return;
                }
                ourOrder = new PrintStream(new FileOutputStream(orderFile, true));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        ourOrder.close();
                        System.out.println(ourOrderSize);
                    }
                });
            }
            catch (IOException e) {
                return;
            }
        }
        if (ourOrder != null) {
            String jarURL = FileUtil.toSystemIndependentName(loader.getBaseURL().getFile());
            if ((jarURL = StringUtil.trimStart(jarURL, "file:/")).startsWith(home)) {
                jarURL = jarURL.replaceFirst(home, "");
                jarURL = StringUtil.trimEnd(jarURL, "!/");
                ourOrder.println(url + ":" + jarURL);
            }
        }
    }

    private static long startTiming() {
        return ourLogTiming ? System.nanoTime() : 0L;
    }

    private static void logTiming(ClassPath path, long started, String msg) {
        if (!ourLogTiming) {
            return;
        }
        long time = System.nanoTime() - started;
        ourTotalTime += time;
        ++ourTotalRequests;
        if (time > 10000000L) {
            System.out.println(time / 1000000L + " ms for " + msg);
        }
        if (ourTotalRequests % 1000 == 0) {
            System.out.println(path.toString() + ", requests:" + ourTotalRequests + ", time:" + ourTotalTime / 1000000L + "ms");
        }
    }

    static {
        ourOrderedUrls = new HashSet<String>();
        ourLogTiming = Boolean.getBoolean("idea.print.classpath.timing");
        ourTotalTime = 0L;
        ourTotalRequests = 0;
    }

    private static class LoaderCollector
    extends ClasspathCache.LoaderIterator<Object, List<Loader>, Object> {
        private LoaderCollector() {
        }

        @Override
        Object process(Loader loader, List<Loader> parameter, Object parameter2) {
            parameter.add(loader);
            return null;
        }
    }

    private static class ResourceStringLoaderIterator
    extends ClasspathCache.LoaderIterator<Resource, String, ClassPath> {
        private final boolean myFlag;

        private ResourceStringLoaderIterator(boolean flag) {
            this.myFlag = flag;
        }

        @Override
        Resource process(Loader loader, String s, ClassPath classPath) {
            if (!classPath.myCache.loaderHasName(s, ClasspathCache.transformName(s), loader)) {
                return null;
            }
            Resource resource = loader.getResource(s, this.myFlag);
            if (resource != null) {
                ClassPath.printOrder(loader, s, resource);
                return resource;
            }
            return null;
        }
    }

    private class MyEnumeration
    implements Enumeration<URL> {
        private int myIndex = 0;
        private Resource myRes = null;
        private final String myName;
        private final String myShortName;
        private final boolean myCheck;
        private final List<Loader> myLoaders;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MyEnumeration(String name, boolean check) {
            this.myName = name;
            this.myShortName = ClasspathCache.transformName(name);
            this.myCheck = check;
            SmartList loaders = null;
            if (ClassPath.this.myCanUseCache) {
                Stack stack = ClassPath.this.myUrls;
                synchronized (stack) {
                    if (ClassPath.this.myUrls.isEmpty()) {
                        loaders = new SmartList();
                        ClassPath.this.myCache.iterateLoaders(name, ourLoaderCollector, loaders, this);
                        if (!name.endsWith("/")) {
                            ClassPath.this.myCache.iterateLoaders(name.concat("/"), ourLoaderCollector, loaders, this);
                        }
                    }
                }
            }
            this.myLoaders = loaders;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean next() {
            if (this.myRes != null) {
                return true;
            }
            long started = ClassPath.startTiming();
            try {
                if (this.myLoaders != null) {
                    while (this.myIndex < this.myLoaders.size()) {
                        Loader loader = this.myLoaders.get(this.myIndex++);
                        if (!ClassPath.this.myCache.loaderHasName(this.myName, this.myShortName, loader)) {
                            this.myRes = null;
                            continue;
                        }
                        this.myRes = loader.getResource(this.myName, this.myCheck);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                } else {
                    Loader loader;
                    while ((loader = ClassPath.this.getLoader(this.myIndex++)) != null) {
                        if (ClassPath.this.myCanUseCache && !ClassPath.this.myCache.loaderHasName(this.myName, this.myShortName, loader)) continue;
                        this.myRes = loader.getResource(this.myName, this.myCheck);
                        if (this.myRes == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                ClassPath.logTiming(ClassPath.this, started, this.myName);
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public URL nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            Resource resource = this.myRes;
            this.myRes = null;
            return resource.getURL();
        }
    }
}

