/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import com.intellij.util.PathUtilRt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.model.GwtJavaScriptOutputStyle;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.GwtModuleExtensionProperties;
import org.jetbrains.jps.gwt.model.impl.GwtModulePackagingProperties;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtMavenSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathsImpl;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtVaadinMavenSdkPaths;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtVaadinSdkPaths;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsGwtModuleExtensionImpl
extends JpsCompositeElementBase<JpsGwtModuleExtensionImpl>
implements JpsGwtModuleExtension {
    public static final JpsElementChildRole<JpsGwtModuleExtension> ROLE = JpsElementChildRoleBase.create((String)"GWT");
    public static final int DEFAULT_COMPILER_HEAP_SIZE = 1024;
    private final GwtModuleExtensionProperties myProperties;

    public JpsGwtModuleExtensionImpl(GwtModuleExtensionProperties properties) {
        this.myProperties = properties;
    }

    private JpsGwtModuleExtensionImpl(JpsGwtModuleExtensionImpl original) {
        super((JpsCompositeElementBase)original);
        this.myProperties = (GwtModuleExtensionProperties)XmlSerializerUtil.createCopy((Object)original.myProperties);
    }

    public GwtModuleExtensionProperties getProperties() {
        return this.myProperties;
    }

    @Override
    @NotNull
    public JpsModule getModule() {
        JpsModule jpsModule = (JpsModule)this.myParent;
        if (jpsModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "getModule"));
        }
        return jpsModule;
    }

    @Override
    public String getCompilerParameters() {
        return this.myProperties.myCompilerParameters;
    }

    @Override
    public String getAdditionalCompilerVMParameters() {
        return this.myProperties.myAdditionalCompilerVMParameters;
    }

    @Override
    public int getCompilerMaximumHeapSize() {
        return this.myProperties.myCompilerMaxHeapSize > 0 ? this.myProperties.myCompilerMaxHeapSize : 1024;
    }

    @Override
    public GwtJavaScriptOutputStyle getOutputStyle() {
        return this.myProperties.myOutputStyle != null ? this.myProperties.myOutputStyle : GwtJavaScriptOutputStyle.DETAILED;
    }

    @Override
    public String getPackagingRelativePath(JpsGwtModule module) {
        for (GwtModulePackagingProperties state : this.myProperties.myPackagingStates) {
            if (!state.myName.equals(module.getQualifiedName()) || state.myPath == null) continue;
            return state.myPath;
        }
        return "/" + module.getOutputName();
    }

    @Override
    public boolean isModuleCompilationEnabled(JpsGwtModule module) {
        for (GwtModulePackagingProperties state : this.myProperties.myPackagingStates) {
            if (!state.myName.equals(module.getQualifiedName())) continue;
            return state.myEnabled;
        }
        return true;
    }

    @Override
    @NotNull
    public GwtSdkPaths getSdkPaths() {
        String sdkUrl = this.myProperties.mySdkUrl;
        String sdkPath = JpsPathUtil.urlToPath((String)sdkUrl);
        if ("maven".equals(this.myProperties.mySdkType)) {
            String version = PathUtilRt.getFileName((String)sdkPath);
            GwtMavenSdkPaths gwtMavenSdkPaths = new GwtMavenSdkPaths(sdkPath, version);
            if (gwtMavenSdkPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "getSdkPaths"));
            }
            return gwtMavenSdkPaths;
        }
        if ("Vaadin".equals(this.myProperties.mySdkType)) {
            GwtVaadinSdkPaths gwtVaadinSdkPaths = new GwtVaadinSdkPaths(sdkPath);
            if (gwtVaadinSdkPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "getSdkPaths"));
            }
            return gwtVaadinSdkPaths;
        }
        if ("Vaadin-Maven".equals(this.myProperties.mySdkType)) {
            GwtVaadinMavenSdkPaths gwtVaadinMavenSdkPaths = new GwtVaadinMavenSdkPaths(sdkPath);
            if (gwtVaadinMavenSdkPaths == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "getSdkPaths"));
            }
            return gwtVaadinMavenSdkPaths;
        }
        GwtSdkPathsImpl gwtSdkPathsImpl = new GwtSdkPathsImpl(sdkUrl);
        if (gwtSdkPathsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "getSdkPaths"));
        }
        return gwtSdkPathsImpl;
    }

    @NotNull
    public JpsGwtModuleExtensionImpl createCopy() {
        JpsGwtModuleExtensionImpl jpsGwtModuleExtensionImpl = new JpsGwtModuleExtensionImpl(this);
        if (jpsGwtModuleExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtModuleExtensionImpl", "createCopy"));
        }
        return jpsGwtModuleExtensionImpl;
    }
}

