/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacMessageHandler;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.JavacServerBootstrap;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.service.SharedThreadPool;

public class ExternalJavacServer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.javac.ExternalJavacServer");
    public static final GlobalContextKey<ExternalJavacServer> KEY = GlobalContextKey.create("_external_javac_server_");
    public static final int DEFAULT_SERVER_PORT = 7878;
    private static final AttributeKey<JavacProcessDescriptor> SESSION_DESCRIPTOR = AttributeKey.valueOf((String)"ExternalJavacServer.JavacProcessDescriptor");
    private ChannelRegistrar myChannelRegistrar;
    private final Map<UUID, JavacProcessDescriptor> myMessageHandlers = new HashMap<UUID, JavacProcessDescriptor>();
    private int myListenPort = 7878;

    public void start(int listenPort) {
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, (Executor)SharedThreadPool.getInstance())).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.myChannelRegistrar = new ChannelRegistrar();
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{ExternalJavacServer.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        this.myChannelRegistrar.add(bootstrap.bind(listenPort).syncUninterruptibly().channel());
        this.myListenPort = listenPort;
    }

    private static int getExternalJavacHeapSize(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        JpsJavaCompilerConfiguration config = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        JpsJavaCompilerOptions options = config.getCurrentCompilerOptions();
        return options.MAXIMUM_HEAP_SIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forkJavac(CompileContext context, List<String> options, List<String> vmOptions, Collection<File> files, Collection<File> classpath, Collection<File> platformCp, Collection<File> sourcePath, Map<File, Set<File>> outs, DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, String javaHome, JavaCompilingTool compilingTool) {
        ExternalJavacMessageHandler rh = new ExternalJavacMessageHandler(diagnosticSink, outputSink, ExternalJavacServer.getEncodingName(options));
        JavacRemoteProto.Message.Request request = JavacProtoUtil.createCompilationRequest(options, files, classpath, platformCp, sourcePath, outs);
        UUID uuid = UUID.randomUUID();
        JavacProcessDescriptor processDescriptor = new JavacProcessDescriptor(uuid, rh, request);
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            this.myMessageHandlers.put(uuid, processDescriptor);
        }
        try {
            JavacServerBootstrap.ExternalJavacProcessHandler processHandler = JavacServerBootstrap.launchExternalJavacProcess(uuid, javaHome, ExternalJavacServer.getExternalJavacHeapSize(context), this.myListenPort, Utils.getSystemRoot(), vmOptions, compilingTool);
            while (!processDescriptor.waitFor(300L)) {
                if (processHandler.isProcessTerminated() && processDescriptor.channel == null && processHandler.getExitCode() != 0) {
                    processDescriptor.setDone();
                    break;
                }
                if (!context.getCancelStatus().isCanceled()) continue;
                processDescriptor.cancelBuild();
            }
            boolean bl = rh.isTerminatedSuccessfully();
            return bl;
        }
        catch (Throwable e) {
            LOG.info(e);
            diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
        }
        finally {
            this.unregisterMessageHandler(uuid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMessageHandler(UUID uuid) {
        JavacProcessDescriptor descriptor;
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            descriptor = this.myMessageHandlers.remove(uuid);
        }
        if (descriptor != null) {
            descriptor.setDone();
        }
    }

    @Nullable
    private static String getEncodingName(List<String> options) {
        boolean found = false;
        for (String option : options) {
            if (found) {
                return option;
            }
            if (!"-encoding".equalsIgnoreCase(option)) continue;
            found = true;
        }
        return null;
    }

    public void stop() {
        this.myChannelRegistrar.close().awaitUninterruptibly();
    }

    private static class JavacProcessDescriptor {
        @NotNull
        final UUID sessionId;
        @NotNull
        final ExternalJavacMessageHandler handler;
        volatile JavacRemoteProto.Message.Request request;
        volatile Channel channel;
        private final Semaphore myDone;

        public JavacProcessDescriptor(@NotNull UUID sessionId, @NotNull ExternalJavacMessageHandler handler, @NotNull JavacRemoteProto.Message.Request request) {
            if (sessionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "org/jetbrains/jps/javac/ExternalJavacServer$JavacProcessDescriptor", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jps/javac/ExternalJavacServer$JavacProcessDescriptor", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/jps/javac/ExternalJavacServer$JavacProcessDescriptor", "<init>"));
            }
            this.myDone = new Semaphore();
            this.sessionId = sessionId;
            this.handler = handler;
            this.request = request;
            this.myDone.down();
        }

        public void cancelBuild() {
            if (this.channel != null) {
                this.channel.writeAndFlush((Object)JavacProtoUtil.toMessage(this.sessionId, JavacProtoUtil.createCancelRequest()));
            }
        }

        public void setDone() {
            this.myDone.up();
        }

        public boolean waitFor(long timeout) {
            return this.myDone.waitFor(timeout);
        }
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/jps/javac/ExternalJavacServer$ChannelRegistrar", "add"));
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            ChannelGroupFuture future;
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                future = this.openChannels.close();
            }
            finally {
                assert (eventLoopGroup != null);
                eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
            }
            return future;
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)ctx.attr(SESSION_DESCRIPTOR).get();
            if (descriptor != null) {
                descriptor.setDone();
            }
            super.channelUnregistered(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            UUID sessionId;
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)context.attr(SESSION_DESCRIPTOR).get();
            if (descriptor == null) {
                sessionId = JavacProtoUtil.fromProtoUUID(message.getSessionId());
                descriptor = (JavacProcessDescriptor)ExternalJavacServer.this.myMessageHandlers.get(sessionId);
                if (descriptor != null) {
                    descriptor.channel = context.channel();
                    context.attr(SESSION_DESCRIPTOR).set((Object)descriptor);
                }
            } else {
                sessionId = descriptor.sessionId;
            }
            ExternalJavacMessageHandler handler = descriptor != null ? descriptor.handler : null;
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.RESPONSE) {
                    JavacRemoteProto.Message.Response response = message.getResponse();
                    JavacRemoteProto.Message.Response.Type responseType = response.getResponseType();
                    if (handler != null) {
                        if (responseType == JavacRemoteProto.Message.Response.Type.REQUEST_ACK) {
                            JavacRemoteProto.Message.Request request = descriptor.request;
                            if (request != null) {
                                reply = JavacProtoUtil.toMessage(sessionId, request);
                                descriptor.request = null;
                            }
                        } else {
                            boolean terminateOk = handler.handleMessage((MessageLite)message);
                            if (terminateOk) {
                                descriptor.setDone();
                            }
                        }
                    } else {
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createCancelRequest());
                    }
                } else {
                    reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported message: " + messageType.name(), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }
}

