/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.grails.builder;

import com.intellij.openapi.application.PathManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.compiler.GrailsCompilerRtMarker;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class GrailsBuilderExtension
implements GroovyBuilderExtension {
    @NotNull
    public Collection<String> getCompilationClassPath(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        for (JpsModule module : chunk.getModules()) {
            if (!GrailsBuilderExtension.shouldInjectGrails(module)) continue;
            Set<String> set = Collections.singleton(PathManager.getJarPathForClass(GrailsCompilerRtMarker.class));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationClassPath"));
        }
        return list;
    }

    private static boolean shouldInjectGrails(JpsModule module) {
        for (String rootUrl : module.getContentRootsList().getUrls()) {
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            if (!new File(root, "grails-app").isDirectory() || !new File(root, "application.properties").isFile()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getGrailsVersion(JpsModule module) {
        Iterator i$ = module.getContentRootsList().getUrls().iterator();
        while (i$.hasNext()) {
            String rootUrl = (String)i$.next();
            File root = JpsPathUtil.urlToFile((String)rootUrl);
            if (!new File(root, "grails-app").isDirectory()) continue;
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(root, "application.properties")));
                try {
                    Properties prop = new Properties();
                    prop.load(in);
                    String res = prop.getProperty("app.grails.version");
                    if (res == null) continue;
                    String string = res;
                    return string;
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (IOException ignored) {}
        }
        return null;
    }

    @NotNull
    public Collection<String> getCompilationUnitPatchers(@NotNull CompileContext context, @NotNull ModuleChunk chunk) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        HashSet<String> res = new HashSet<String>();
        for (JpsModule module : chunk.getModules()) {
            String grailsVersion = GrailsBuilderExtension.getGrailsVersion(module);
            if (grailsVersion == null) continue;
            res.add("org.jetbrains.groovy.grails.compiler.GrailsJUnitPatcher");
            if (grailsVersion.compareTo("1.2") < 0) {
                res.add("org.jetbrains.groovy.grails.compiler.GrailsDomainClassPatcher");
                continue;
            }
            if (grailsVersion.compareTo("2.0") < 0) continue;
            res.add("org.jetbrains.groovy.grails.compiler.EmptyGrailsAwarePatcher");
            res.add("org.jetbrains.groovy.grails.compiler.Grails2_0_JUnitPatcher");
        }
        HashSet<String> hashSet = res;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/grails/builder/GrailsBuilderExtension", "getCompilationUnitPatchers"));
        }
        return hashSet;
    }
}

