/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;

public class JBInsets
extends Insets {
    public JBInsets(int top, int left, int bottom, int right) {
        super(JBUI.scale(top), JBUI.scale(left), JBUI.scale(bottom), JBUI.scale(right));
    }

    public int width() {
        return this.left + this.right;
    }

    public int height() {
        return this.top + this.bottom;
    }

    public static JBInsets create(@NotNull Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insets", "com/intellij/util/ui/JBInsets", "create"));
        }
        return insets instanceof JBInsets ? (JBInsets)insets : new JBInsets(insets.top, insets.left, insets.bottom, insets.right);
    }

    public JBInsetsUIResource asUIResource() {
        return new JBInsetsUIResource(this);
    }

    public static class JBInsetsUIResource
    extends JBInsets
    implements UIResource {
        public JBInsetsUIResource(JBInsets insets) {
            super(0, 0, 0, 0);
            this.top = insets.top;
            this.left = insets.left;
            this.bottom = insets.bottom;
            this.right = insets.right;
        }
    }
}

