/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class PropertyAccessor
implements Accessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method myWriteMethod;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, @NotNull Method readMethod, @NotNull Method writeMethod) {
        if (readMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readMethod", "com/intellij/util/xmlb/PropertyAccessor", "<init>"));
        }
        if (writeMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeMethod", "com/intellij/util/xmlb/PropertyAccessor", "<init>"));
        }
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.myWriteMethod = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            this.myWriteMethod.setAccessible(true);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/PropertyAccessor", "read"));
        }
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void write(Object o, Object value) {
        try {
            this.myWriteMethod.invoke(o, XmlSerializerImpl.convert(value, this.myType));
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        SmartList result = new SmartList();
        ContainerUtil.addAll(result, this.myReadMethod.getAnnotations());
        ContainerUtil.addAll(result, this.myWriteMethod.getAnnotations());
        Annotation[] annotationArray = result.toArray(new Annotation[result.size()]);
        if (annotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/PropertyAccessor", "getAnnotations"));
        }
        return annotationArray;
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/util/xmlb/PropertyAccessor", "getAnnotation"));
        }
        T annotation = this.myReadMethod.getAnnotation(annotationClass);
        return annotation == null ? this.myWriteMethod.getAnnotation(annotationClass) : annotation;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

