/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.gwt.build.GwtBuildTarget;
import org.jetbrains.jps.gwt.build.JpsGwtCompilerPaths;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.index.JpsGwtModuleIndex;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.gwt.model.impl.JpsGwtCompilerOutputPackagingElement;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuilderService;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.model.module.JpsModule;

public class GwtCompilerOutputLayoutElementBuilder
extends LayoutElementBuilderService<JpsGwtCompilerOutputPackagingElement> {
    public GwtCompilerOutputLayoutElementBuilder() {
        super(JpsGwtCompilerOutputPackagingElement.class);
    }

    public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsGwtCompilerOutputPackagingElement element, TargetOutputIndex outputIndex) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/gwt/build/GwtCompilerOutputLayoutElementBuilder", "getDependencies"));
        }
        JpsModule module = (JpsModule)element.getModuleReference().resolve();
        JpsGwtModuleExtension extension = JpsGwtExtensionService.getInstance().getExtension(module);
        if (extension != null) {
            return Collections.singletonList(new GwtBuildTarget(extension));
        }
        return Collections.emptyList();
    }

    public void generateInstructions(JpsGwtCompilerOutputPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext builderContext) {
        JpsModule module = (JpsModule)element.getModuleReference().resolve();
        JpsGwtModuleExtension extension = JpsGwtExtensionService.getInstance().getExtension(module);
        if (extension == null) {
            return;
        }
        File outputRoot = JpsGwtCompilerPaths.getCompilerOutputRoot(new GwtBuildTarget(extension), builderContext.getDataPaths());
        JpsGwtModuleIndex index = JpsGwtExtensionService.getInstance().getGwtModuleIndex(builderContext.getModel(), builderContext.getDataPaths());
        for (JpsGwtModule gwtModule : index.getModulesToCompile(extension, true)) {
            String outputName = gwtModule.getOutputName();
            String relativePath = extension.getPackagingRelativePath(gwtModule);
            switch (element.getOutputKind()) {
                case REGULAR: {
                    File outputDir = new File(outputRoot, outputName);
                    instructionCreator.subFolderByRelativePath(relativePath).addDirectoryCopyInstructions(outputDir);
                    break;
                }
                case DEPLOY: {
                    File outputDir = new File(outputRoot, JpsArtifactPathUtil.appendToPath((String)"WEB-INF/deploy", (String)outputName));
                    instructionCreator.subFolderByRelativePath(JpsArtifactPathUtil.appendToPath((String)"WEB-INF/deploy", (String)relativePath)).addDirectoryCopyInstructions(outputDir);
                }
            }
        }
    }
}

