/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeaSpecificSettings<T, C, SdkType> {
    public void readIDEASpecific(Element root, T model, @Nullable SdkType projectSdkType, Map<String, String> levels) throws InvalidDataException {
        this.expandElement(root, model);
        this.readLanguageLevel(root, model);
        this.setupCompilerOutputs(root, model);
        List entriesElements = root.getChildren("contentEntry");
        if (!entriesElements.isEmpty()) {
            for (Object o : entriesElements) {
                this.readContentEntry((Element)o, this.createContentEntry(model, ((Element)o).getAttributeValue("url")), model);
            }
        } else {
            C[] entries = this.getEntries(model);
            if (entries.length > 0) {
                this.readContentEntry(root, entries[0], model);
            }
        }
        this.setupJdk(root, model, projectSdkType);
        this.setupLibraryRoots(root, model);
        this.overrideModulesScopes(root, model);
        this.readLibraryLevels(root, levels);
    }

    public void initLevels(Element root, T model, Map<String, String> levels) throws InvalidDataException {
        this.expandElement(root, model);
        this.readLanguageLevel(root, model);
        this.readLibraryLevels(root, levels);
    }

    public void updateEntries(Element root, T model, @Nullable SdkType projectSdkType) {
        this.setupJdk(root, model, projectSdkType);
        this.setupCompilerOutputs(root, model);
        List entriesElements = root.getChildren("contentEntry");
        if (!entriesElements.isEmpty()) {
            for (Object o : entriesElements) {
                this.readContentEntry((Element)o, this.createContentEntry(model, ((Element)o).getAttributeValue("url")), model);
            }
        } else {
            C[] entries = this.getEntries(model);
            if (entries.length > 0) {
                this.readContentEntry(root, entries[0], model);
            }
        }
    }

    protected abstract void readLibraryLevels(Element var1, Map<String, String> var2);

    protected abstract C[] getEntries(T var1);

    protected abstract C createContentEntry(T var1, String var2);

    protected abstract void setupLibraryRoots(Element var1, T var2);

    protected abstract void setupJdk(Element var1, T var2, @Nullable SdkType var3);

    protected abstract void setupCompilerOutputs(Element var1, T var2);

    protected abstract void readLanguageLevel(Element var1, T var2) throws InvalidDataException;

    protected abstract void expandElement(Element var1, T var2);

    protected abstract void overrideModulesScopes(Element var1, T var2);

    public abstract void readContentEntry(Element var1, C var2, T var3);
}

