/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.DiffFragmentBuilder;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.highlighting.Util;
import com.intellij.openapi.diff.impl.processing.DiffCorrection;
import com.intellij.openapi.diff.impl.processing.Formatting;
import com.intellij.openapi.diff.impl.processing.Word;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComparisonPolicy {
    public static final ComparisonPolicy DEFAULT = new DefaultPolicy();
    public static final ComparisonPolicy TRIM_SPACE = new TrimSpacePolicy();
    public static final ComparisonPolicy IGNORE_SPACE = new IgnoreSpacePolicy();
    public static final ComparisonPolicy[] COMPARISON_POLICIES = new ComparisonPolicy[]{DEFAULT, IGNORE_SPACE, TRIM_SPACE};
    private final String myName;

    protected ComparisonPolicy(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public DiffFragment[] buildFragments(@NotNull DiffString[] strings1, @NotNull DiffString[] strings2) throws FilesTooBigForDiffException {
        if (strings1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings1", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildFragments"));
        }
        if (strings2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings2", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildFragments"));
        }
        DiffFragmentBuilder builder = new DiffFragmentBuilder(strings1, strings2);
        Object[] wrappers1 = this.getWrappers(strings1);
        Object[] wrappers2 = this.getWrappers(strings2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        DiffFragment[] diffFragmentArray = builder.buildFragments(Util.concatEquals(change, wrappers1, wrappers2));
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildFragments"));
        }
        return diffFragmentArray;
    }

    @NotNull
    public DiffFragment[] buildDiffFragmentsFromLines(@NotNull DiffString[] lines1, @NotNull DiffString[] lines2) throws FilesTooBigForDiffException {
        if (lines1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildDiffFragmentsFromLines"));
        }
        if (lines2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildDiffFragmentsFromLines"));
        }
        DiffFragmentBuilder builder = new DiffFragmentBuilder(lines1, lines2);
        Object[] wrappers1 = this.getLineWrappers(lines1);
        Object[] wrappers2 = this.getLineWrappers(lines2);
        Diff.Change change = Diff.buildChanges(wrappers1, wrappers2);
        DiffFragment[] diffFragmentArray = builder.buildFragments(change);
        if (diffFragmentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "buildDiffFragmentsFromLines"));
        }
        return diffFragmentArray;
    }

    @NotNull
    public DiffFragment createFragment(@Nullable DiffString text1, @Nullable DiffString text2) {
        text1 = ComparisonPolicy.toNull(text1);
        text2 = ComparisonPolicy.toNull(text2);
        if (text1 == null && text2 == null) {
            DiffFragment diffFragment = new DiffFragment(DiffString.EMPTY, DiffString.EMPTY);
            if (diffFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "createFragment"));
            }
            return diffFragment;
        }
        DiffFragment result = new DiffFragment(text1, text2);
        if (text1 != null && text2 != null) {
            result.setModified(!this.getWrapper(text1).equals(this.getWrapper(text2)));
        }
        DiffFragment diffFragment = result;
        if (diffFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "createFragment"));
        }
        return diffFragment;
    }

    @NotNull
    public abstract DiffFragment createFragment(@NotNull Word var1, @NotNull Word var2);

    @NotNull
    protected abstract Object[] getWrappers(@NotNull DiffString[] var1);

    @NotNull
    protected abstract Object[] getLineWrappers(@NotNull DiffString[] var1);

    @NotNull
    private Object getWrapper(@NotNull DiffString text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getWrapper"));
        }
        Object object = this.getWrappers(new DiffString[]{text})[0];
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getWrapper"));
        }
        return object;
    }

    @Nullable
    private static DiffString toNull(@Nullable DiffString text1) {
        return text1 == null || text1.isEmpty() ? null : text1;
    }

    @NotNull
    private static DiffString toNotNull(@Nullable DiffString text) {
        DiffString diffString = text == null ? DiffString.EMPTY : text;
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "toNotNull"));
        }
        return diffString;
    }

    @NotNull
    protected Object[] trimStrings(@NotNull DiffString[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/ComparisonPolicy", "trimStrings"));
        }
        Object[] result = new Object[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            DiffString string = strings[i];
            result[i] = string.trim();
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "trimStrings"));
        }
        return result;
    }

    public boolean isEqual(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/ComparisonPolicy", "isEqual"));
        }
        if (fragment.isOneSide()) {
            return false;
        }
        Object[] wrappers = this.getLineWrappers(new DiffString[]{fragment.getText1(), fragment.getText2()});
        return Comparing.equal(wrappers[0], wrappers[1]);
    }

    @NotNull
    public Word createFormatting(@NotNull DiffString text, @NotNull TextRange textRange) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/ComparisonPolicy", "createFormatting"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/diff/impl/ComparisonPolicy", "createFormatting"));
        }
        Formatting formatting = new Formatting(text, textRange);
        if (formatting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "createFormatting"));
        }
        return formatting;
    }

    public static ComparisonPolicy[] getAllInstances() {
        return COMPARISON_POLICIES;
    }

    @NotNull
    protected Object[] getWrappers(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getWrappers"));
        }
        DiffString[] unsafeStrings = new DiffString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            unsafeStrings[i] = DiffString.createNullable(lines[i]);
        }
        Object[] objectArray = this.getWrappers(unsafeStrings);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getWrappers"));
        }
        return objectArray;
    }

    @NotNull
    protected Object[] getLineWrappers(@NotNull String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getLineWrappers"));
        }
        DiffString[] unsafeStrings = new DiffString[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            unsafeStrings[i] = DiffString.createNullable(lines[i]);
        }
        Object[] objectArray = this.getLineWrappers(unsafeStrings);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy", "getLineWrappers"));
        }
        return objectArray;
    }

    private static class IgnoreSpacePolicy
    extends ComparisonPolicy
    implements DiffCorrection.FragmentProcessor<DiffCorrection.FragmentsCollector> {
        public IgnoreSpacePolicy() {
            super(CommonBundle.message("comparison.policy.ignore.spaces.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getLineWrappers"));
            }
            Object[] result = new Object[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                DiffString line = lines[i];
                result[i] = IgnoreSpacePolicy.getWrapper(line);
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getLineWrappers"));
            }
            return result;
        }

        @Override
        @NotNull
        public DiffFragment[] buildFragments(@NotNull DiffString[] strings1, @NotNull DiffString[] strings2) throws FilesTooBigForDiffException {
            if (strings1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings1", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "buildFragments"));
            }
            if (strings2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings2", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "buildFragments"));
            }
            DiffFragment[] fragments = super.buildFragments(strings1, strings2);
            DiffCorrection.FragmentsCollector collector = new DiffCorrection.FragmentsCollector();
            collector.processAll(fragments, this);
            DiffFragment[] diffFragmentArray = collector.toArray();
            if (diffFragmentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "buildFragments"));
            }
            return diffFragmentArray;
        }

        @NotNull
        private static Object getWrapper(@NotNull DiffString line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getWrapper"));
            }
            DiffString diffString = line.skipSpaces();
            if (diffString == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getWrapper"));
            }
            return diffString;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word1", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "createFragment"));
            }
            if (word2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word2", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "createFragment"));
            }
            DiffString text1 = word1.getText();
            DiffString text2 = word2.getText();
            DiffFragment diffFragment = word1.isWhitespace() && word2.isWhitespace() ? DiffFragment.unchanged(text1, text2) : this.createFragment(text1, text2);
            if (diffFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "createFragment"));
            }
            return diffFragment;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(DiffString text1, DiffString text2) {
            DiffString toCompare1 = ComparisonPolicy.toNotNull(text1);
            DiffString toCompare2 = ComparisonPolicy.toNotNull(text2);
            if (IgnoreSpacePolicy.getWrapper(toCompare1).equals(IgnoreSpacePolicy.getWrapper(toCompare2))) {
                DiffFragment diffFragment = DiffFragment.unchanged(toCompare1, toCompare2);
                if (diffFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "createFragment"));
                }
                return diffFragment;
            }
            DiffFragment diffFragment = new DiffFragment(text1, text2);
            if (diffFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "createFragment"));
            }
            return diffFragment;
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getWrappers"));
            }
            Object[] objectArray = this.trimStrings(strings);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "getWrappers"));
            }
            return objectArray;
        }

        public String toString() {
            return "IGNORE";
        }

        @Override
        public void process(@NotNull DiffFragment fragment, @NotNull DiffCorrection.FragmentsCollector collector) {
            FragmentSide side;
            DiffString text;
            DiffString trimed;
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "process"));
            }
            if (collector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/openapi/diff/impl/ComparisonPolicy$IgnoreSpacePolicy", "process"));
            }
            if (fragment.isEqual()) {
                collector.add(fragment);
                return;
            }
            if (fragment.isOneSide() && (trimed = (text = (side = FragmentSide.chooseSide(fragment)).getText(fragment)).trim()).isEmpty()) {
                collector.add(side.createFragment(text, DiffString.EMPTY, false));
                return;
            }
            collector.add(fragment);
        }
    }

    private static class TrimSpacePolicy
    extends ComparisonPolicy {
        public TrimSpacePolicy() {
            super(CommonBundle.message("comparison.policy.trim.space.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "getLineWrappers"));
            }
            Object[] objectArray = this.trimStrings(lines);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "getLineWrappers"));
            }
            return objectArray;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word1", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "createFragment"));
            }
            if (word2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word2", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "createFragment"));
            }
            DiffString text1 = word1.getText();
            DiffString text2 = word2.getText();
            if (word1.isWhitespace() && word2.isWhitespace() && word1.atEndOfLine() && word2.atEndOfLine()) {
                DiffFragment diffFragment = DiffFragment.unchanged(text1, text2);
                if (diffFragment == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "createFragment"));
                }
                return diffFragment;
            }
            DiffFragment diffFragment = this.createFragment(text1, text2);
            if (diffFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "createFragment"));
            }
            return diffFragment;
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "getWrappers"));
            }
            Object[] result = new Object[strings.length];
            boolean atBeginning = true;
            for (int i = 0; i < strings.length; ++i) {
                DiffString wrapper;
                DiffString string = strings[i];
                DiffString diffString = wrapper = atBeginning ? string.trimLeading() : string;
                if (wrapper.endsWith('\n')) {
                    atBeginning = true;
                    wrapper = wrapper.trimTrailing();
                } else {
                    atBeginning = false;
                }
                result[i] = wrapper;
            }
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$TrimSpacePolicy", "getWrappers"));
            }
            return result;
        }

        public String toString() {
            return "TRIM";
        }
    }

    private static class DefaultPolicy
    extends ComparisonPolicy {
        public DefaultPolicy() {
            super(CommonBundle.message("comparison.policy.default.name", new Object[0]));
        }

        @Override
        @NotNull
        protected Object[] getWrappers(@NotNull DiffString[] strings) {
            if (strings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "getWrappers"));
            }
            if (strings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "getWrappers"));
            }
            return strings;
        }

        @Override
        @NotNull
        protected Object[] getLineWrappers(@NotNull DiffString[] lines) {
            if (lines == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "getLineWrappers"));
            }
            if (lines == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "getLineWrappers"));
            }
            return lines;
        }

        @Override
        @NotNull
        public DiffFragment createFragment(@NotNull Word word1, @NotNull Word word2) {
            if (word1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word1", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "createFragment"));
            }
            if (word2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word2", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "createFragment"));
            }
            DiffFragment diffFragment = this.createFragment(word1.getText(), word2.getText());
            if (diffFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/ComparisonPolicy$DefaultPolicy", "createFragment"));
            }
            return diffFragment;
        }

        public String toString() {
            return "DEFAULT";
        }
    }
}

