/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TagBindingWrapper;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractCollectionBinding
extends Binding
implements MultiNodeBinding {
    private Map<Class, Binding> myElementBindings;
    private final Class myElementType;
    private final String myTagName;
    private final AbstractCollection myAnnotation;

    public AbstractCollectionBinding(Class elementType, String tagName, @Nullable Accessor accessor) {
        super(accessor);
        this.myElementType = elementType;
        this.myTagName = tagName;
        this.myAnnotation = accessor == null ? null : accessor.getAnnotation(AbstractCollection.class);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    @Override
    public void init() {
        if (this.myAnnotation != null && !this.myAnnotation.surroundWithTag()) {
            if (this.myAnnotation.elementTag() == null) {
                throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
            }
            if (this.myAnnotation.elementTag().equals("option")) {
                for (Binding binding : this.getElementBindings().values()) {
                    if (!(binding instanceof TagBindingWrapper)) continue;
                    throw new XmlSerializationException("If surround with tag is turned off, element tag must be specified for: " + this.myAccessor);
                }
            }
        }
    }

    protected Binding getElementBinding(@NotNull Class<?> elementClass) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/util/xmlb/AbstractCollectionBinding", "getElementBinding"));
        }
        Binding binding = this.getElementBindings().get(elementClass);
        return binding == null ? XmlSerializerImpl.getBinding(elementClass) : binding;
    }

    private synchronized Map<Class, Binding> getElementBindings() {
        if (this.myElementBindings == null) {
            this.myElementBindings = new THashMap();
            this.myElementBindings.put(this.myElementType, this.getBinding(this.myElementType));
            if (this.myAnnotation != null) {
                for (Class aClass : this.myAnnotation.elementTypes()) {
                    this.myElementBindings.put(aClass, this.getBinding(aClass));
                }
            }
        }
        return this.myElementBindings;
    }

    protected Binding getElementBinding(Object node) {
        for (Binding binding : this.getElementBindings().values()) {
            if (!binding.isBoundTo(node)) continue;
            return binding;
        }
        throw new XmlSerializationException("Node " + node + " is not bound");
    }

    private Binding getBinding(@NotNull Class type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/AbstractCollectionBinding", "getBinding"));
        }
        Binding binding = XmlSerializerImpl.getBinding(type);
        return binding.getBoundNodeType().isAssignableFrom(Element.class) ? binding : this.createElementTagWrapper(binding);
    }

    private Binding createElementTagWrapper(Binding elementBinding) {
        if (this.myAnnotation == null) {
            return new TagBindingWrapper(elementBinding, "option", "value");
        }
        return new TagBindingWrapper(elementBinding, this.myAnnotation.elementTag() != null ? this.myAnnotation.elementTag() : "option", this.myAnnotation.elementValueAttribute() != null ? this.myAnnotation.elementValueAttribute() : "value");
    }

    abstract Object processResult(Collection var1, Object var2);

    @NotNull
    abstract Collection<Object> getIterable(@NotNull Object var1);

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Collection<Object> collection = o == null ? null : this.getIterable(o);
        String tagName = this.getTagName(o);
        if (tagName != null) {
            Element result = new Element(tagName);
            if (ContainerUtil.isEmpty(collection)) {
                return new Element(tagName);
            }
            for (Object e : collection) {
                if (e == null) {
                    throw new XmlSerializationException("Collection " + this.myAccessor + " contains 'null' object");
                }
                Content child = (Content)this.getElementBinding(e.getClass()).serialize(e, result, filter);
                if (child == null) continue;
                result.addContent(child);
            }
            return result;
        }
        SmartList result = new SmartList();
        if (ContainerUtil.isEmpty(collection)) {
            return result;
        }
        for (Object e : collection) {
            ContainerUtil.addIfNotNull(result, this.getElementBinding(e.getClass()).serialize(e, result, filter));
        }
        return result;
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<?> nodes) {
        Collection<Object> result;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserializeList"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result = (SmartList)context;
                result.clear();
            } else {
                result = new SmartList();
            }
            for (Object node : nodes) {
                if (XmlSerializerImpl.isIgnoredNode(node)) continue;
                result.add(this.getElementBinding(node).deserialize(context, node));
            }
            if (result == context) {
                return result;
            }
        } else {
            assert (nodes.size() == 1);
            result = this.processSingle(context, (Element)nodes.get(0));
        }
        return this.processResult(result, context);
    }

    @Override
    public Object deserialize(Object context, @NotNull Object node) {
        SmartList<Object> result;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "deserialize"));
        }
        if (this.getTagName(context) == null) {
            if (context instanceof Collection) {
                result = (SmartList<Object>)context;
                result.clear();
            } else {
                result = new SmartList<Object>();
            }
            if (!XmlSerializerImpl.isIgnoredNode(node)) {
                result.add(this.getElementBinding(node).deserialize(context, node));
            }
            if (result == context) {
                return result;
            }
        } else {
            result = this.processSingle(context, (Element)node);
        }
        return this.processResult(result, context);
    }

    @NotNull
    private Collection processSingle(Object context, @NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AbstractCollectionBinding", "processSingle"));
        }
        Collection result = this.createCollection(node.getName());
        for (Content child : node.getContent()) {
            if (XmlSerializerImpl.isIgnoredNode(child)) continue;
            result.add(this.getElementBinding(child).deserialize(context, child));
        }
        Collection collection = result;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AbstractCollectionBinding", "processSingle"));
        }
        return collection;
    }

    protected Collection createCollection(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/util/xmlb/AbstractCollectionBinding", "createCollection"));
        }
        return new SmartList();
    }

    @Override
    public boolean isBoundTo(Object node) {
        if (!(node instanceof Element)) {
            return false;
        }
        String tagName = this.getTagName(node);
        if (tagName == null) {
            for (Binding binding : this.getElementBindings().values()) {
                if (!binding.isBoundTo(node)) continue;
                return true;
            }
        }
        return ((Element)node).getName().equals(tagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }

    public Class getElementType() {
        return this.myElementType;
    }

    @Nullable
    private String getTagName(Object target) {
        return this.myAnnotation == null || this.myAnnotation.surroundWithTag() ? this.getCollectionTagName(target) : null;
    }

    protected String getCollectionTagName(Object target) {
        return this.myTagName;
    }
}

