/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBindingWrapper
extends Binding {
    private final Binding myBinding;
    private final String myTagName;
    private final String myAttributeName;

    public TagBindingWrapper(@NotNull Binding binding, String tagName, String attributeName) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/util/xmlb/TagBindingWrapper", "<init>"));
        }
        super(binding.myAccessor);
        this.myBinding = binding;
        assert (binding.getBoundNodeType().isAssignableFrom(Text.class));
        this.myTagName = tagName;
        this.myAttributeName = attributeName;
    }

    @Override
    @Nullable
    public Object serialize(Object o, @Nullable Object context, SerializationFilter filter) {
        Element e = new Element(this.myTagName);
        Content content = (Content)this.myBinding.serialize(o, e, filter);
        if (content != null) {
            if (!this.myAttributeName.isEmpty()) {
                e.setAttribute(this.myAttributeName, content.getValue());
            } else if (content instanceof Text) {
                e.addContent(content);
            } else {
                e.addContent(content.getValue());
            }
        }
        return e;
    }

    @Override
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/TagBindingWrapper", "deserialize"));
        }
        Element element = (Element)node;
        if (this.myAttributeName.isEmpty()) {
            return Binding.deserializeList(this.myBinding, context, XmlSerializerImpl.getFilteredContent(element));
        }
        return this.myBinding.deserialize(context, element.getAttribute(this.myAttributeName));
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        return Element.class;
    }
}

