/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class CompositeLogger
extends Logger {
    private Logger[] myLoggers;

    public CompositeLogger(Logger ... loggers) {
        this.myLoggers = loggers;
    }

    public boolean isDebugEnabled() {
        for (Logger logger : this.myLoggers) {
            if (!logger.isDebugEnabled()) continue;
            return true;
        }
        return false;
    }

    public void debug(@NonNls String message) {
        for (Logger logger : this.myLoggers) {
            logger.debug(message);
        }
    }

    public void debug(@Nullable Throwable t) {
        for (Logger logger : this.myLoggers) {
            logger.debug(t);
        }
    }

    public void debug(@NonNls String message, @Nullable Throwable t) {
        for (Logger logger : this.myLoggers) {
            logger.debug(message, t);
        }
    }

    public void info(@NonNls String message) {
        for (Logger logger : this.myLoggers) {
            logger.info(message);
        }
    }

    public void info(@NonNls String message, @Nullable Throwable t) {
        for (Logger logger : this.myLoggers) {
            logger.info(message, t);
        }
    }

    public void warn(@NonNls String message, @Nullable Throwable t) {
        for (Logger logger : this.myLoggers) {
            logger.warn(message, t);
        }
    }

    public void error(@NonNls String message, @Nullable Throwable t, String ... details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/openapi/diagnostic/CompositeLogger", "error"));
        }
        for (Logger logger : this.myLoggers) {
            logger.error(message, t, details);
        }
    }

    public void setLevel(Level level) {
        for (Logger logger : this.myLoggers) {
            logger.setLevel(level);
        }
    }
}

