/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SystemImage;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class LocalSysImgPkgInfo
extends LocalPkgInfo {
    @NonNull
    private final IPkgDesc mDesc;

    public LocalSysImgPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps, @NonNull AndroidVersion version, @Nullable IdDisplay tag, @NonNull String abi, @NonNull MajorRevision revision) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = PkgDesc.Builder.newSysImg(version, tag, abi, revision).create();
    }

    @Override
    @NonNull
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    @NonNull
    public static IdDisplay extractTagFromProps(Properties props) {
        if (props != null) {
            String tagId = props.getProperty("SystemImage.TagId", SystemImage.DEFAULT_TAG.getId());
            String tagDisp = props.getProperty("SystemImage.TagDisplay", "");
            if (tagDisp == null || tagDisp.isEmpty()) {
                tagDisp = LocalSysImgPkgInfo.tagIdToDisplay(tagId);
            }
            assert (tagId != null);
            assert (tagDisp != null);
            return new IdDisplay(tagId, tagDisp);
        }
        return SystemImage.DEFAULT_TAG;
    }

    @NonNull
    public static String tagIdToDisplay(@NonNull String tagId) {
        char c;
        String name = tagId.replaceAll("[^A-Za-z0-9]+", " ");
        name = name.replaceAll(" +", " ");
        if ((name = name.trim()).length() > 0 && !Character.isUpperCase(c = name.charAt(0))) {
            StringBuilder sb = new StringBuilder(name);
            sb.replace(0, 1, String.valueOf(c).toUpperCase(Locale.US));
            name = sb.toString();
        }
        return name;
    }
}

