/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.flex.build.FlexSourceRootDescriptor;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexResourceBuildTarget
extends ModuleBasedTarget<BuildRootDescriptor> {
    FlexResourceBuildTarget(FlexResourceBuildTargetType type, @NotNull JpsTypedModule<JpsFlexBuildConfigurationManager> module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/flex/build/FlexResourceBuildTarget", "<init>"));
        }
        super((ModuleBasedBuildTargetType)type, module);
    }

    public String getId() {
        return this.getModule().getName();
    }

    @NotNull
    public JpsTypedModule<JpsFlexBuildConfigurationManager> getModule() {
        JpsTypedModule jpsTypedModule = (JpsTypedModule)super.getModule();
        if (jpsTypedModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTarget", "getModule"));
        }
        return jpsTypedModule;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        JavaSourceRootType rootType = this.getTargetType() == FlexResourceBuildTargetType.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        for (JpsTypedModuleSourceRoot sourceRoot : this.getModule().getSourceRoots((JpsModuleSourceRootType)rootType)) {
            File root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
            result.add((BuildRootDescriptor)new FlexSourceRootDescriptor((BuildTarget)this, root));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    public boolean isTests() {
        return ((FlexResourceBuildTargetType)this.getTargetType()).isTests();
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getTargetType().getTypeId() + ":" + this.getModule().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTarget", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        if (this.getTargetType() == FlexResourceBuildTargetType.TEST) {
            File outputDir = ProjectPaths.getModuleOutputDir(this.getModule(), (boolean)true);
            List<Object> list = outputDir == null ? Collections.emptyList() : Collections.singletonList(outputDir);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTarget", "getOutputRoots"));
            }
            return list;
        }
        THashSet result = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)this.getModule().getProperties()).getBuildConfigurations()) {
            if (!FlexCommonUtils.canHaveResourceFiles(bc.getNature())) continue;
            result.add(new File(PathUtilRt.getParentPath((String)bc.getActualOutputFilePath())));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTarget", "getOutputRoots"));
        }
        return tHashSet;
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        out.println("Module: " + this.getModule().getName());
        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)this.getModule().getProperties()).getBuildConfigurations()) {
            JpsJavaCompilerConfiguration c;
            if (bc.isSkipCompile() || !FlexCommonUtils.canHaveResourceFiles(bc.getNature()) || bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.None) continue;
            out.print("BC: " + bc.getName());
            out.print(", output folder: " + PathUtilRt.getParentPath((String)bc.getActualOutputFilePath()));
            out.print(", mode: " + (Object)((Object)bc.getCompilerOptions().getResourceFilesMode()));
            if (bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.ResourcePatterns && (c = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.getModule().getProject())) != null) {
                out.print(", patterns: " + StringUtil.join((Collection)c.getResourcePatterns(), (String)" "));
            }
            out.println();
        }
    }
}

