/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class FlexCompilerConfigFileUtilBase {
    public static final String FLEX_CONFIG = "flex-config";
    public static final String COMPILER = "compiler";
    public static final String EXTERNAL_LIBRARY_PATH = "external-library-path";
    public static final String INCLUDE_LIBRARIES = "include-libraries";
    public static final String LIBRARY = "library";
    public static final String LIBRARY_PATH = "library-path";
    public static final String PATH_ELEMENT = "path-element";
    public static final String APPEND = "append";
    private static final String[] ELEMENTS_TO_REMOVE = new String[]{"compute-digest", "directory", "include-classes", "include-file", "include-lookup-only", "include-namespaces", "include-sources", "include-stylesheet", "file-specs", "output", "link-report", "load-externs"};
    private static final String[] OPTIONS_CONTAINING_PATHS = new String[]{"path-element", "manifest", "defaults-css-url", "filename", "link-report", "load-externs", "services", "resource-bundle-list"};
    private static final String[] NON_REPEATABLE_OPTIONS_THAT_CAN_BE_IN_GENERATED_FILE = new String[]{"mobile", "preloader", "warn-no-constructor", "accessible", "keep-generated-actionscript", "services", "context-root", "defaults-css-url", "debug", "target-player", "swf-version", "static-link-runtime-shared-libraries", "date", "title", "language", "contributor", "creator", "publisher", "description", "manager-class"};

    public static String mergeWithCustomConfigFile(String generatedConfigText, String additionalConfigFilePath, boolean makeExternalLibsMerged, boolean makeIncludedLibsMerged) {
        Document document;
        block10: {
            File additionalConfigFile = new File(additionalConfigFilePath);
            if (!additionalConfigFile.isFile()) {
                return generatedConfigText;
            }
            try {
                document = JDOMUtil.loadDocument((File)additionalConfigFile);
            }
            catch (JDOMException e) {
                return generatedConfigText;
            }
            catch (IOException e) {
                return generatedConfigText;
            }
            Element rootElement = document.getRootElement();
            if (!FLEX_CONFIG.equals(rootElement.getName())) {
                return generatedConfigText;
            }
            FlexCompilerConfigFileUtilBase.removeSwcSpecificElementsRecursively(rootElement);
            FlexCompilerConfigFileUtilBase.makeLibrariesMergedIntoCode(rootElement, makeExternalLibsMerged, makeIncludedLibsMerged);
            try {
                Element otherRootElement = JDOMUtil.loadDocument((CharSequence)generatedConfigText).getRootElement();
                assert (otherRootElement != null && FLEX_CONFIG.equals(rootElement.getName())) : JDOMUtil.writeDocument((Document)document, (String)"\n");
                FlexCompilerConfigFileUtilBase.appendDocument(rootElement, otherRootElement);
            }
            catch (IOException e) {
                assert (false) : e.getMessage() + "\n" + generatedConfigText;
            }
            catch (JDOMException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)(e.getMessage() + "\n" + generatedConfigText));
            }
        }
        return JDOMUtil.writeDocument((Document)document, (String)"\n");
    }

    private static void removeSwcSpecificElementsRecursively(Element element) {
        for (String elementName : ELEMENTS_TO_REMOVE) {
            element.removeChildren(elementName, element.getNamespace());
        }
        for (Element child : element.getChildren()) {
            FlexCompilerConfigFileUtilBase.removeSwcSpecificElementsRecursively(child);
        }
    }

    private static void makeLibrariesMergedIntoCode(Element rootElement, boolean externalLibs, boolean includedLibs) {
        Namespace namespace = rootElement.getNamespace();
        Collection<String> paths = FlexCompilerConfigFileUtilBase.removeLibs(rootElement, externalLibs, includedLibs);
        if (!paths.isEmpty()) {
            Element compilerElement = rootElement.getChild(COMPILER, namespace);
            Element libraryPathElement = compilerElement.getChild(LIBRARY_PATH, namespace);
            if (libraryPathElement == null) {
                libraryPathElement = new Element(LIBRARY_PATH, namespace);
                libraryPathElement.setAttribute(new Attribute(APPEND, "true"));
                compilerElement.addContent(libraryPathElement);
            }
            for (String path : paths) {
                Element pathElement = new Element(PATH_ELEMENT, namespace);
                pathElement.addContent(path);
                libraryPathElement.addContent(pathElement);
            }
        }
    }

    private static Collection<String> removeLibs(Element rootElement, boolean removeExternal, boolean removeIncluded) {
        Namespace namespace = rootElement.getNamespace();
        ArrayList<String> result = new ArrayList<String>();
        for (Element compilerElement : rootElement.getChildren(COMPILER, namespace)) {
            if (removeExternal) {
                for (Element externalLibraryPathElement : compilerElement.getChildren(EXTERNAL_LIBRARY_PATH, namespace)) {
                    ArrayList<Element> pathElementsToRemove = new ArrayList<Element>();
                    for (Element pathElement : externalLibraryPathElement.getChildren(PATH_ELEMENT, namespace)) {
                        String path = pathElement.getText();
                        String fileName = path.substring(FileUtil.toSystemIndependentName((String)path).lastIndexOf("/") + 1);
                        if (fileName.startsWith("playerglobal") || fileName.startsWith("airglobal")) continue;
                        result.add(path);
                        pathElementsToRemove.add(pathElement);
                    }
                    for (Element pathElement : pathElementsToRemove) {
                        externalLibraryPathElement.removeContent((Content)pathElement);
                    }
                }
            }
            if (!removeIncluded) continue;
            for (Element includeLibrariesElement : compilerElement.getChildren(INCLUDE_LIBRARIES, namespace)) {
                ArrayList<Element> libraryElementsToRemove = new ArrayList<Element>();
                for (Element libraryElement : includeLibrariesElement.getChildren(LIBRARY, namespace)) {
                    result.add(libraryElement.getText());
                    libraryElementsToRemove.add(libraryElement);
                }
                for (Element pathElement : libraryElementsToRemove) {
                    includeLibrariesElement.removeContent((Content)pathElement);
                }
            }
        }
        return result;
    }

    private static void appendDocument(Element rootElement, Element otherRootElement) {
        Collection<Element> toRemove = FlexCompilerConfigFileUtilBase.findDuplicateElementsRecursively(rootElement, otherRootElement);
        for (Element duplicateElement : toRemove) {
            Element parentElement = duplicateElement.getParentElement();
            parentElement.removeContent((Content)duplicateElement);
            if (!parentElement.getChildren().isEmpty()) continue;
            parentElement.getParentElement().removeContent((Content)parentElement);
        }
        for (Element otherElement : otherRootElement.getChildren()) {
            rootElement.addContent(otherElement.clone());
        }
    }

    private static Collection<Element> findDuplicateElementsRecursively(Element existingElement, Element otherElement) {
        THashSet result = new THashSet();
        for (Element potentialChild : otherElement.getChildren()) {
            List existingChildren = existingElement.getChildren(potentialChild.getName(), existingElement.getNamespace());
            for (Element existingChild : existingChildren) {
                String potentialChildContent = potentialChild.getTextTrim();
                if (potentialChildContent.isEmpty()) {
                    result.addAll(FlexCompilerConfigFileUtilBase.findDuplicateElementsRecursively(existingChild, potentialChild));
                    continue;
                }
                String existingElementContent = existingChild.getTextTrim();
                if (ArrayUtil.contains((String)existingChild.getName(), (String[])NON_REPEATABLE_OPTIONS_THAT_CAN_BE_IN_GENERATED_FILE)) {
                    result.add(potentialChild);
                    continue;
                }
                if (!FlexCompilerConfigFileUtilBase.areOptionValuesEqual(existingChild.getName(), potentialChildContent, existingElementContent) || existingElement.getChildren().size() != existingChildren.size()) continue;
                result.add(potentialChild);
            }
        }
        return result;
    }

    private static boolean areOptionValuesEqual(String optionName, String value1, String value2) {
        if (value1.equals(value2)) {
            return true;
        }
        return ArrayUtil.contains((String)optionName, (String[])OPTIONS_CONTAINING_PATHS) && FileUtil.toSystemIndependentName((String)value1).equals(FileUtil.toSystemIndependentName((String)value2));
    }
}

