/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.FileDescriptor;
import io.netty.channel.epoll.Native;
import java.io.IOException;

public final class NativeFileDescriptor
implements FileDescriptor {
    private final int fd;

    public NativeFileDescriptor(int fd) {
        if (fd < 0) {
            throw new IllegalArgumentException("fd must be >= 0");
        }
        this.fd = fd;
    }

    @Override
    public int intValue() {
        return this.fd;
    }

    @Override
    public void close() throws IOException {
        Native.close(this.fd);
    }

    public String toString() {
        return "FileDescriptor{fd=" + this.fd + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NativeFileDescriptor)) {
            return false;
        }
        return this.fd == ((NativeFileDescriptor)o).fd;
    }

    public int hashCode() {
        return this.fd;
    }
}

