/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.jetbrains.groovy.compiler.rt.AstAwareResourceLoader;
import org.jetbrains.groovy.compiler.rt.CompilationUnitPatcher;
import org.jetbrains.groovy.compiler.rt.CompilerMessage;
import org.jetbrains.groovy.compiler.rt.GroovyCompilerWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentGroovycRunner {
    public static final String TEMP_RESOURCE_SUFFIX = "___" + new Random().nextInt() + "_neverHappen";
    public static final String[] RESOURCES_TO_MASK = new String[]{"META-INF/services/org.codehaus.groovy.transform.ASTTransformation", "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule"};
    private static final String STUB_DIR = "stubDir";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runGroovyc(boolean forStubs, String argsPath, Queue mailbox) {
        List<GroovyCompilerWrapper.OutputItem> compiledFiles;
        File argsFile = new File(argsPath);
        CompilerConfiguration config = new CompilerConfiguration();
        config.setClasspath("");
        config.setOutput(new PrintWriter(System.err));
        config.setWarningLevel(3);
        ArrayList<CompilerMessage> compilerMessages = new ArrayList<CompilerMessage>();
        ArrayList<CompilationUnitPatcher> patchers = new ArrayList<CompilationUnitPatcher>();
        ArrayList<File> srcFiles = new ArrayList<File>();
        HashMap<String, File> class2File = new HashMap<String, File>();
        String[] finalOutputRef = new String[1];
        DependentGroovycRunner.fillFromArgsFile(argsFile, config, patchers, compilerMessages, srcFiles, class2File, finalOutputRef);
        if (srcFiles.isEmpty()) {
            return true;
        }
        String[] finalOutputs = finalOutputRef[0].split(File.pathSeparator);
        if (forStubs) {
            HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
            options.put(STUB_DIR, config.getTargetDirectory());
            options.put("keepStubs", Boolean.TRUE);
            config.setJointCompilationOptions(options);
            if (mailbox != null) {
                config.setTargetDirectory(finalOutputs[0]);
            }
        }
        System.out.println("@#$%@# Presentable:Groovyc: loading sources...");
        DependentGroovycRunner.renameResources(finalOutputs, "", TEMP_RESOURCE_SUFFIX);
        try {
            final AstAwareResourceLoader resourceLoader = new AstAwareResourceLoader(class2File);
            GroovyCompilerWrapper wrapper = new GroovyCompilerWrapper(compilerMessages, forStubs);
            CompilationUnit unit = DependentGroovycRunner.createCompilationUnit(forStubs, config, DependentGroovycRunner.buildClassLoaderFor(config, resourceLoader), mailbox, wrapper);
            unit.addPhaseOperation(new CompilationUnit.SourceUnitOperation(){

                public void call(SourceUnit source) throws CompilationFailedException {
                    File file = new File(source.getName());
                    for (ClassNode aClass : source.getAST().getClasses()) {
                        resourceLoader.myClass2File.put(aClass.getName(), file);
                    }
                }
            }, 3);
            DependentGroovycRunner.addSources(forStubs, srcFiles, unit);
            DependentGroovycRunner.runPatchers(patchers, compilerMessages, unit, resourceLoader, srcFiles);
            System.out.println("@#$%@# Presentable:Groovyc: compiling...");
            compiledFiles = wrapper.compile(unit, forStubs && mailbox == null ? 3 : 9);
        }
        finally {
            DependentGroovycRunner.renameResources(finalOutputs, TEMP_RESOURCE_SUFFIX, "");
            System.out.println("$@#$%^ CLEAR_PRESENTABLE");
        }
        System.out.println();
        DependentGroovycRunner.reportCompiledItems(compiledFiles);
        int errorCount = 0;
        for (CompilerMessage message : compilerMessages) {
            if (message.getCategory() == "error") {
                if (errorCount > 100) continue;
                ++errorCount;
            }
            DependentGroovycRunner.printMessage(message);
        }
        return false;
    }

    private static void renameResources(String[] finalOutputs, String removeSuffix, String addSuffix) {
        for (String output : finalOutputs) {
            for (String res : RESOURCES_TO_MASK) {
                File file = new File(output, res + removeSuffix);
                if (!file.exists()) continue;
                file.renameTo(new File(output, res + addSuffix));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fillFromArgsFile(File argsFile, CompilerConfiguration compilerConfiguration, List<CompilationUnitPatcher> patchers, List<CompilerMessage> compilerMessages, List<File> srcFiles, Map<String, File> class2File, String[] finalOutputs) {
        String line;
        String moduleClasspath = null;
        BufferedReader reader = null;
        try {
            FileInputStream stream = new FileInputStream(argsFile);
            reader = new BufferedReader(new InputStreamReader(stream));
            reader.readLine();
            while ((line = reader.readLine()) != null && "src_file".equals(line)) {
                File file = new File(reader.readLine());
                srcFiles.add(file);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return moduleClasspath;
        }
        catch (IOException e) {
            e.printStackTrace();
            return moduleClasspath;
        }
        while (line != null) {
            block35: {
                String s;
                block36: {
                    block38: {
                        block37: {
                            block34: {
                                if (!line.equals("class2src")) break block34;
                                while (!"end".equals(line = reader.readLine())) {
                                    class2File.put(line, new File(reader.readLine()));
                                }
                                break block35;
                            }
                            if (line.startsWith("patchers")) break block36;
                            if (!line.startsWith("encoding")) break block37;
                            compilerConfiguration.setSourceEncoding(reader.readLine());
                            break block35;
                        }
                        if (!line.startsWith("outputpath")) break block38;
                        compilerConfiguration.setTargetDirectory(reader.readLine());
                        break block35;
                    }
                    if (line.startsWith("final_outputpath")) {
                        finalOutputs[0] = reader.readLine();
                    }
                    break block35;
                }
                while (!"end".equals(s = reader.readLine())) {
                    try {
                        CompilationUnitPatcher patcher = (CompilationUnitPatcher)Class.forName(s).newInstance();
                        patchers.add(patcher);
                    }
                    catch (InstantiationException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (IllegalAccessException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                    catch (ClassNotFoundException e) {
                        DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't instantiate " + s);
                    }
                }
            }
            line = reader.readLine();
        }
        return moduleClasspath;
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                argsFile.delete();
            }
        }
    }

    private static void addSources(boolean forStubs, List<File> srcFiles, CompilationUnit unit) {
        for (File file : srcFiles) {
            if (forStubs && file.getName().endsWith(".java")) continue;
            unit.addSource(new SourceUnit(file, unit.getConfiguration(), unit.getClassLoader(), unit.getErrorCollector()));
        }
    }

    private static void runPatchers(List<CompilationUnitPatcher> patchers, List<CompilerMessage> compilerMessages, CompilationUnit unit, AstAwareResourceLoader loader, List<File> srcFiles) {
        if (!patchers.isEmpty()) {
            for (CompilationUnitPatcher patcher : patchers) {
                try {
                    patcher.patchCompilationUnit(unit, loader, srcFiles.toArray(new File[srcFiles.size()]));
                }
                catch (LinkageError e) {
                    DependentGroovycRunner.addExceptionInfo(compilerMessages, e, "Couldn't run " + patcher.getClass().getName());
                }
            }
        }
    }

    private static void reportCompiledItems(List<GroovyCompilerWrapper.OutputItem> compiledFiles) {
        for (GroovyCompilerWrapper.OutputItem compiledFile : compiledFiles) {
            System.out.print("%%c");
            System.out.print(compiledFile.getOutputPath());
            System.out.print("#%%#%%%#%%%%%%%%%#");
            System.out.print(compiledFile.getSourceFile());
            System.out.print("/%c");
            System.out.println();
        }
    }

    private static void printMessage(CompilerMessage message) {
        System.out.print("%%m");
        System.out.print(message.getCategory());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getMessage());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getUrl());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getLineNum());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print(message.getColumnNum());
        System.out.print("#%%#%%%#%%%%%%%%%#");
        System.out.print("/%m");
        System.out.println();
    }

    private static void addExceptionInfo(List<CompilerMessage> compilerMessages, Throwable e, String message) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        compilerMessages.add(new CompilerMessage("warning", message + ":\n" + writer, "<exception>", -1, -1));
    }

    private static CompilationUnit createCompilationUnit(boolean forStubs, CompilerConfiguration config, GroovyClassLoader classLoader, Queue mailbox, GroovyCompilerWrapper wrapper) {
        CompilationUnit unit;
        GroovyClassLoader transformLoader = new GroovyClassLoader(classLoader);
        try {
            if (forStubs) {
                return DependentGroovycRunner.createStubGenerator(config, classLoader, transformLoader, mailbox, wrapper);
            }
        }
        catch (NoClassDefFoundError ignore) {
            // empty catch block
        }
        try {
            unit = new CompilationUnit(config, null, classLoader, transformLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        System.out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                    }
                }
            };
        }
        catch (NoSuchMethodError e) {
            unit = new CompilationUnit(config, null, classLoader){

                public void gotoPhase(int phase) throws CompilationFailedException {
                    super.gotoPhase(phase);
                    if (phase <= 9) {
                        System.out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                    }
                }
            };
        }
        return unit;
    }

    private static CompilationUnit createStubGenerator(CompilerConfiguration config, GroovyClassLoader classLoader, final GroovyClassLoader transformLoader, final Queue mailbox, final GroovyCompilerWrapper wrapper) {
        final JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(config, classLoader){
            private boolean annoRemovedAdded;

            public GroovyClassLoader getTransformLoader() {
                return transformLoader;
            }

            public void addPhaseOperation(CompilationUnit.PrimaryClassNodeOperation op, int phase) {
                if (!this.annoRemovedAdded && mailbox == null && phase == 3 && op.getClass().getName().startsWith("org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit$")) {
                    this.annoRemovedAdded = true;
                    super.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                        public void call(final SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            ClassCodeVisitorSupport annoRemover = new ClassCodeVisitorSupport(){

                                protected SourceUnit getSourceUnit() {
                                    return source;
                                }

                                public void visitClass(ClassNode node) {
                                    if (node.isEnum()) {
                                        node.setModifiers(node.getModifiers() & 0xFFFFFFEF);
                                    }
                                    super.visitClass(node);
                                }

                                public void visitField(FieldNode fieldNode) {
                                    Expression valueExpr = fieldNode.getInitialValueExpression();
                                    if (valueExpr instanceof ConstantExpression && ClassHelper.STRING_TYPE.equals((Object)valueExpr.getType())) {
                                        fieldNode.setInitialValueExpression((Expression)new MethodCallExpression(valueExpr, "toString", (Expression)new ListExpression()));
                                    }
                                    super.visitField(fieldNode);
                                }

                                public void visitAnnotations(AnnotatedNode node) {
                                    List annotations = node.getAnnotations();
                                    if (!annotations.isEmpty()) {
                                        annotations.clear();
                                    }
                                    super.visitAnnotations(node);
                                }
                            };
                            try {
                                annoRemover.visitClass(classNode);
                            }
                            catch (LinkageError ignored) {
                                // empty catch block
                            }
                        }
                    }, phase);
                }
                super.addPhaseOperation(op, phase);
            }

            public void gotoPhase(int phase) throws CompilationFailedException {
                if (phase < 4) {
                    System.out.println("@#$%@# Presentable:Groovy stub generator: " + this.getPhaseDescription());
                } else if (phase <= 9) {
                    System.out.println("@#$%@# Presentable:Groovyc: " + this.getPhaseDescription());
                }
                super.gotoPhase(phase);
            }
        };
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(final CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        if (mailbox != null) {
                            DependentGroovycRunner.reportCompiledItems(GroovyCompilerWrapper.getStubOutputItems((CompilationUnit)unit, (File)config.getJointCompilationOptions().get(DependentGroovycRunner.STUB_DIR)));
                            System.out.flush();
                            System.err.flush();
                            DependentGroovycRunner.pauseAndWaitForJavac(mailbox);
                            wrapper.onContinuation();
                        }
                    }
                };
            }
        });
        unit.addSources(new String[]{"SomeClass.java"});
        return unit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void pauseAndWaitForJavac(Queue mailbox) {
        mailbox.offer("Stubs generated");
        try {
            while (true) {
                Thread.sleep(10L);
                Object response = mailbox.poll();
                if ("Stubs generated".equals(response)) {
                    mailbox.offer(response);
                    continue;
                }
                if ("Build aborted".equals(response)) {
                    throw new RuntimeException("Build aborted");
                }
                if ("Javac completed".equals(response)) return;
                if (response != null) throw new RuntimeException("Unknown response: " + response);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static GroovyClassLoader buildClassLoaderFor(final CompilerConfiguration compilerConfiguration, final AstAwareResourceLoader resourceLoader) {
        GroovyClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

            @Override
            public GroovyClassLoader run() {
                return new GroovyClassLoader(Thread.currentThread().getContextClassLoader(), compilerConfiguration){

                    public Class loadClass(String name, boolean lookupScriptFiles, boolean preferClassOverScript) throws ClassNotFoundException, CompilationFailedException {
                        Class aClass;
                        try {
                            aClass = super.loadClass(name, lookupScriptFiles, preferClassOverScript);
                        }
                        catch (NoClassDefFoundError e) {
                            throw new ClassNotFoundException(name);
                        }
                        catch (LinkageError e) {
                            throw new RuntimeException("Problem loading class " + name, e);
                        }
                        this.ensureWellFormed(aClass, new HashSet<Class>());
                        return aClass;
                    }

                    private void ensureWellFormed(Type aClass, Set<Class> visited) throws ClassNotFoundException {
                        if (aClass instanceof Class) {
                            this.ensureWellFormed((Class)aClass, visited);
                        } else if (aClass instanceof ParameterizedType) {
                            this.ensureWellFormed(((ParameterizedType)aClass).getOwnerType(), visited);
                            for (Type type : ((ParameterizedType)aClass).getActualTypeArguments()) {
                                this.ensureWellFormed(type, visited);
                            }
                        } else if (aClass instanceof WildcardType) {
                            for (Type type : ((WildcardType)aClass).getLowerBounds()) {
                                this.ensureWellFormed(type, visited);
                            }
                            for (Type type : ((WildcardType)aClass).getUpperBounds()) {
                                this.ensureWellFormed(type, visited);
                            }
                        } else if (aClass instanceof GenericArrayType) {
                            this.ensureWellFormed(((GenericArrayType)aClass).getGenericComponentType(), visited);
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private void ensureWellFormed(Class aClass, Set<Class> visited) throws ClassNotFoundException {
                        String name = aClass.getName();
                        if (resourceLoader.getSourceFile(name) != null && visited.add(aClass)) {
                            try {
                                void var7_16;
                                for (Method method : aClass.getDeclaredMethods()) {
                                    this.ensureWellFormed(method.getGenericReturnType(), visited);
                                    for (Type type : method.getGenericExceptionTypes()) {
                                        this.ensureWellFormed(type, visited);
                                    }
                                    for (Type type : method.getGenericParameterTypes()) {
                                        this.ensureWellFormed(type, visited);
                                    }
                                }
                                for (Executable executable : aClass.getDeclaredConstructors()) {
                                    for (Type type : ((Constructor)executable).getGenericExceptionTypes()) {
                                        this.ensureWellFormed(type, visited);
                                    }
                                    for (Type type : ((Constructor)executable).getGenericParameterTypes()) {
                                        this.ensureWellFormed(type, visited);
                                    }
                                }
                                for (AccessibleObject accessibleObject : aClass.getDeclaredFields()) {
                                    this.ensureWellFormed(((Field)accessibleObject).getGenericType(), visited);
                                }
                                Type superclass = aClass.getGenericSuperclass();
                                if (superclass != null) {
                                    this.ensureWellFormed(aClass, visited);
                                }
                                Type[] arr$ = aClass.getGenericInterfaces();
                                int len$ = arr$.length;
                                boolean bl = false;
                                while (var7_16 < len$) {
                                    Type intf = arr$[var7_16];
                                    this.ensureWellFormed(intf, visited);
                                    ++var7_16;
                                }
                                aClass.getAnnotations();
                                Package aPackage = aClass.getPackage();
                                if (aPackage != null) {
                                    aPackage.getAnnotations();
                                }
                            }
                            catch (LinkageError e) {
                                throw new ClassNotFoundException(name);
                            }
                            catch (TypeNotPresentException e) {
                                throw new ClassNotFoundException(name);
                            }
                        }
                    }
                };
            }
        });
        classLoader.setResourceLoader((GroovyResourceLoader)resourceLoader);
        return classLoader;
    }
}

