/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;

public class JpsServiceManagerImpl
extends JpsServiceManager {
    private final ConcurrentMap<Class, Object> myServices = new ConcurrentHashMap<Class, Object>(16, 0.75f, 1);
    private final ConcurrentMap<Class, List<?>> myExtensions = new ConcurrentHashMap(16, 0.75f, 1);

    @Override
    public <T> T getService(Class<T> serviceClass) {
        Object service = this.myServices.get(serviceClass);
        if (service == null) {
            Iterator<T> iterator = ServiceLoader.load(serviceClass, serviceClass.getClassLoader()).iterator();
            if (!iterator.hasNext()) {
                throw new ServiceConfigurationError("Implementation for " + serviceClass + " not found");
            }
            T loadedService = iterator.next();
            if (iterator.hasNext()) {
                throw new ServiceConfigurationError("More than one implementation for " + serviceClass + " found: " + loadedService.getClass() + " and " + iterator.next().getClass());
            }
            service = this.myServices.putIfAbsent(serviceClass, loadedService);
            if (service == null) {
                service = loadedService;
            }
        }
        return (T)service;
    }

    @Override
    public <T> Iterable<T> getExtensions(Class<T> extensionClass) {
        ArrayList<T> extensions;
        ArrayList<T> cached = (ArrayList<T>)this.myExtensions.get(extensionClass);
        if (cached == null && (cached = (List)this.myExtensions.putIfAbsent(extensionClass, extensions = new ArrayList<T>(JpsPluginManager.getInstance().loadExtensions(extensionClass)))) == null) {
            cached = extensions;
        }
        return cached;
    }
}

