/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.build;

import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.build.GwtBuildTargetType;
import org.jetbrains.jps.gwt.build.JpsGwtCompilerPaths;
import org.jetbrains.jps.gwt.model.JpsGwtExtensionService;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtBuildTarget
extends BuildTarget<BuildRootDescriptor> {
    private final JpsGwtModuleExtension myExtension;

    public GwtBuildTarget(JpsGwtModuleExtension extension) {
        super((BuildTargetType)GwtBuildTargetType.INSTANCE);
        this.myExtension = extension;
    }

    public String getId() {
        return this.myExtension.getModule().getName();
    }

    public JpsGwtModuleExtension getExtension() {
        return this.myExtension;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.unmodifiableCollection(targetRegistry.getModuleBasedTargets(this.myExtension.getModule(), BuildTargetRegistry.ModuleTargetSelector.PRODUCTION));
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        final ArrayList<BuildRootDescriptor> roots = new ArrayList<BuildRootDescriptor>();
        this.processGwtExtensionFromDependencies(new Consumer<JpsGwtModuleExtension>(){

            public void consume(JpsGwtModuleExtension extension) {
                for (JpsTypedModuleSourceRoot sourceRoot : extension.getModule().getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
                    File root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
                    roots.add(new BuildRootDescriptorImpl((BuildTarget)GwtBuildTarget.this, root, true));
                }
            }
        });
        ArrayList<BuildRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuildTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    public void processGwtExtensionFromDependencies(final Consumer<JpsGwtModuleExtension> processor) {
        JpsJavaExtensionService.dependencies((JpsModule)this.myExtension.getModule()).recursively().productionOnly().processModules((Consumer)new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                JpsGwtModuleExtension extension = JpsGwtExtensionService.getInstance().getExtension(module);
                if (extension != null) {
                    processor.consume((Object)extension);
                }
            }
        });
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = "GWT in module '" + this.myExtension.getModule().getName() + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuildTarget", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        File root = JpsGwtCompilerPaths.getCompilerOutputRoot(this, context.getProjectDescriptor().dataManager.getDataPaths());
        Set<File> set = Collections.singleton(root);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/build/GwtBuildTarget", "getOutputRoots"));
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GwtBuildTarget target = (GwtBuildTarget)((Object)o);
        return this.myExtension.equals(target.myExtension);
    }

    public int hashCode() {
        return this.myExtension.hashCode();
    }
}

