/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final ThreadLocal<java.lang.ref.SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private JDOMUtil() {
    }

    @NotNull
    public static List<org.jdom.Element> getChildren(@Nullable org.jdom.Element parent) {
        if (parent == null) {
            List<org.jdom.Element> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
            }
            return list;
        }
        List list = parent.getChildren();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        return list;
    }

    @NotNull
    public static List<org.jdom.Element> getChildren(@Nullable org.jdom.Element parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        if (parent != null) {
            List list = parent.getChildren(name);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
            }
            return list;
        }
        List<org.jdom.Element> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildren"));
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    public static boolean areElementsEqual(@Nullable org.jdom.Element e1, @Nullable org.jdom.Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Comparing.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes()) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER));
    }

    public static int getTreeHash(@NotNull org.jdom.Element root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/JDOMUtil", "getTreeHash"));
        }
        return JDOMUtil.getTreeHash(root, false);
    }

    public static int getTreeHash(@NotNull org.jdom.Element root, boolean skipEmptyText) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/util/JDOMUtil", "getTreeHash"));
        }
        return JDOMUtil.addToHash(0, root, skipEmptyText);
    }

    @Deprecated
    public static int getTreeHash(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "getTreeHash"));
        }
        return JDOMUtil.getTreeHash(document.getRootElement());
    }

    private static int addToHash(int i, @NotNull org.jdom.Element element, boolean skipEmptyText) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "addToHash"));
        }
        i = JDOMUtil.addToHash(i, element.getName());
        for (Attribute attribute : element.getAttributes()) {
            i = JDOMUtil.addToHash(i, attribute.getName());
            i = JDOMUtil.addToHash(i, attribute.getValue());
        }
        for (Content child : element.getContent()) {
            if (child instanceof org.jdom.Element) {
                i = JDOMUtil.addToHash(i, (org.jdom.Element)child, skipEmptyText);
                continue;
            }
            if (!(child instanceof Text)) continue;
            String text = ((Text)child).getText();
            if (skipEmptyText && StringUtil.isEmptyOrSpaces(text)) continue;
            i = JDOMUtil.addToHash(i, text);
        }
        return i;
    }

    private static int addToHash(int i, @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/JDOMUtil", "addToHash"));
        }
        return i * 31 + s.hashCode();
    }

    @Deprecated
    @NotNull
    public static Object[] getChildNodesWithAttrs(@NotNull org.jdom.Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/JDOMUtil", "getChildNodesWithAttrs"));
        }
        ArrayList result = new ArrayList();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildNodesWithAttrs"));
        }
        return objectArray;
    }

    @NotNull
    public static Content[] getContent(@NotNull org.jdom.Element m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/util/JDOMUtil", "getContent"));
        }
        List list = m.getContent();
        Content[] contentArray = list.toArray(new Content[list.size()]);
        if (contentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getContent"));
        }
        return contentArray;
    }

    @NotNull
    public static org.jdom.Element[] getElements(@NotNull org.jdom.Element m) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/intellij/openapi/util/JDOMUtil", "getElements"));
        }
        List list = m.getChildren();
        org.jdom.Element[] elementArray = list.toArray(new org.jdom.Element[list.size()]);
        if (elementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getElements"));
        }
        return elementArray;
    }

    @Deprecated
    @NotNull
    public static String concatTextNodesValues(@NotNull Object[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/util/JDOMUtil", "concatTextNodesValues"));
        }
        StringBuilder result = new StringBuilder();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "concatTextNodesValues"));
        }
        return string;
    }

    public static void addContent(@NotNull org.jdom.Element targetElement, Object node) {
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/openapi/util/JDOMUtil", "addContent"));
        }
        if (node instanceof Content) {
            Content content = (Content)node;
            targetElement.addContent(content);
        } else if (node instanceof List) {
            targetElement.addContent((Collection)((List)node));
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }

    public static void internElement(@NotNull org.jdom.Element element, @NotNull StringInterner interner) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "com/intellij/openapi/util/JDOMUtil", "internElement"));
        }
        element.setName(JDOMUtil.intern(interner, element.getName()));
        for (Attribute attr : element.getAttributes()) {
            attr.setName(JDOMUtil.intern(interner, attr.getName()));
            attr.setValue(JDOMUtil.intern(interner, attr.getValue()));
        }
        for (Content o : element.getContent()) {
            if (o instanceof org.jdom.Element) {
                org.jdom.Element e = (org.jdom.Element)o;
                JDOMUtil.internElement(e, interner);
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                text.setText(JDOMUtil.intern(interner, text.getText()));
                continue;
            }
            if (o instanceof Comment) {
                Comment comment = (Comment)o;
                comment.setText(JDOMUtil.intern(interner, comment.getText()));
                continue;
            }
            throw new IllegalArgumentException("Wrong node: " + o);
        }
    }

    @NotNull
    private static String intern(@NotNull StringInterner interner, @NotNull String s) {
        if (interner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interner", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        String string = interner.intern(s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "intern"));
        }
        return string;
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil", "legalizeText"));
        }
        String string = ((Object)JDOMUtil.legalizeChars(str)).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "legalizeText"));
        }
        return string;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil", "legalizeChars"));
        }
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        StringBuilder stringBuilder = result;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "legalizeChars"));
        }
        return stringBuilder;
    }

    public static void appendLegalized(@NotNull StringBuilder sb, char each) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/openapi/util/JDOMUtil", "appendLegalized"));
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter((int)each)) {
            sb.append("0x").append(StringUtil.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List c1, List c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2) {
        if (!(c1 instanceof org.jdom.Element) && !(c2 instanceof org.jdom.Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof org.jdom.Element && c2 instanceof org.jdom.Element && JDOMUtil.areElementsEqual((org.jdom.Element)c1, (org.jdom.Element)c2);
    }

    private static boolean attListsEqual(@NotNull List a1, @NotNull List a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/openapi/util/JDOMUtil", "attListsEqual"));
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            if (JDOMUtil.attEqual((Attribute)a1.get(i), (Attribute)a2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/openapi/util/JDOMUtil", "attEqual"));
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    public static boolean areDocumentsEqual(@NotNull Document d1, @NotNull Document d2) {
        if (d1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d1", "com/intellij/openapi/util/JDOMUtil", "areDocumentsEqual"));
        }
        if (d2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d2", "com/intellij/openapi/util/JDOMUtil", "areDocumentsEqual"));
        }
        if (d1.hasRootElement() != d2.hasRootElement()) {
            return false;
        }
        if (!d1.hasRootElement()) {
            return true;
        }
        CharArrayWriter w1 = new CharArrayWriter();
        CharArrayWriter w2 = new CharArrayWriter();
        try {
            JDOMUtil.writeDocument(d1, w1, "\n");
            JDOMUtil.writeDocument(d2, w2, "\n");
        }
        catch (IOException e) {
            JDOMUtil.getLogger().error(e);
        }
        return w1.size() == w2.size() && w1.toString().equals(w2.toString());
    }

    @NotNull
    public static Document loadDocument(char[] chars, int length) throws IOException, JDOMException {
        Document document = JDOMUtil.getSaxBuilder().build((Reader)new CharArrayReader(chars, 0, length));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(byte[] bytes) throws IOException, JDOMException {
        Document document = JDOMUtil.loadDocument(new ByteArrayInputStream(bytes));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    private static SAXBuilder getSaxBuilder() {
        java.lang.ref.SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder saxBuilder = SoftReference.dereference(reference);
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    InputSource inputSource = new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                    if (inputSource == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$1", "resolveEntity"));
                    }
                    return inputSource;
                }
            });
            ourSaxBuilder.set(new java.lang.ref.SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    public static Document loadDocument(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new CharSequenceReader(seq));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.getSaxBuilder().build(reader);
        Document document2 = document;
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static Document loadDocument(File file) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file)));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static org.jdom.Element load(@NotNull File file) throws JDOMException, IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "load"));
        }
        org.jdom.Element element = JDOMUtil.load(new BufferedInputStream(new FileInputStream(file)));
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "load"));
        }
        return element;
    }

    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        Document document = JDOMUtil.loadDocument(new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @Contract(value="null -> null; !null -> !null")
    public static org.jdom.Element load(Reader reader) throws JDOMException, IOException {
        return reader == null ? null : JDOMUtil.loadDocument(reader).detachRootElement();
    }

    @Contract(value="null -> null; !null -> !null")
    public static org.jdom.Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadDocument(stream).detachRootElement();
    }

    @NotNull
    public static Document loadDocument(@NotNull Class clazz, String resource) throws JDOMException, IOException {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        Document document = JDOMUtil.loadDocument(stream);
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadDocument"));
        }
        return document;
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        Document document = JDOMUtil.loadDocument(URLUtil.openResourceStream(url));
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "loadResourceDocument"));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        JDOMUtil.writeParent((Parent)document, file, lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeParent(@NotNull Parent element, @NotNull File file, String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.writeParent(element, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        JDOMUtil.writeParent((Parent)document, stream, lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeParent(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, CharsetToolkit.UTF8_CHARSET);
        try {
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((org.jdom.Element)element, writer, lineSeparator);
            }
        }
        finally {
            writer.close();
        }
    }

    @NotNull
    public static byte[] printDocument(@NotNull Document document, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "printDocument"));
        }
        CharArrayWriter writer = new CharArrayWriter();
        JDOMUtil.writeDocument(document, writer, lineSeparator);
        byte[] byArray = StringFactory.createShared(writer.toCharArray()).getBytes(CharsetToolkit.UTF8_CHARSET);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "printDocument"));
        }
        return byArray;
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        String string;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException ignored) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        return string;
    }

    @NotNull
    public static String writeParent(Parent element, String lineSeparator) {
        String string;
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeParent(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeParent"));
        }
        return string;
    }

    public static void writeParent(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof org.jdom.Element) {
            JDOMUtil.writeElement((org.jdom.Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull org.jdom.Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull org.jdom.Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        String string = JDOMUtil.writeElement(element, "\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        return string;
    }

    @NotNull
    public static String writeElement(@NotNull org.jdom.Element element, String lineSeparator) {
        String string;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, writer, lineSeparator);
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeElement"));
        }
        return string;
    }

    @NotNull
    public static String writeChildren(@Nullable org.jdom.Element element, @NotNull String lineSeparator) {
        String string;
        if (lineSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSeparator", "com/intellij/openapi/util/JDOMUtil", "writeChildren"));
        }
        try {
            StringWriter writer = new StringWriter();
            for (org.jdom.Element child : JDOMUtil.getChildren(element)) {
                JDOMUtil.writeElement(child, writer, lineSeparator);
                writer.append(lineSeparator);
            }
            string = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "writeChildren"));
        }
        return string;
    }

    public static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/openapi/util/JDOMUtil", "writeDocument"));
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        MyXMLOutputter myXMLOutputter = xmlOutputter;
        if (myXMLOutputter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "createOutputter"));
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        String string = JDOMUtil.escapeText(text, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        String string = JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuilder(text.length() + 20);
                buffer.append(text, 0, i);
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        String string = buffer == null ? text : buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "escapeText"));
        }
        return string;
    }

    @Deprecated
    @NotNull
    public static List<org.jdom.Element> getChildrenFromAllNamespaces(@NotNull org.jdom.Element element, @NotNull @NonNls String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "getChildrenFromAllNamespaces"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil", "getChildrenFromAllNamespaces"));
        }
        SmartList<org.jdom.Element> result = new SmartList<org.jdom.Element>();
        for (org.jdom.Element child : element.getChildren()) {
            if (!name.equals(child.getName())) continue;
            result.add(child);
        }
        SmartList<org.jdom.Element> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getChildrenFromAllNamespaces"));
        }
        return smartList;
    }

    private static void printDiagnostics(@NotNull org.jdom.Element element, String prefix) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "printDiagnostics"));
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        List<org.jdom.Element> children = JDOMUtil.getChildren(element);
        for (org.jdom.Element child : children) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull org.jdom.Element element) {
        int length;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "getElementInfo"));
        }
        ElementInfo info = new ElementInfo();
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        ElementInfo elementInfo = info;
        if (elementInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil", "getElementInfo"));
        }
        return elementInfo;
    }

    public static void updateFileSet(@NotNull File[] oldFiles, @NotNull String[] newFilePaths, @NotNull Document[] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFiles", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        if (newFilePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFilePaths", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        if (newFileDocuments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFileDocuments", "com/intellij/openapi/util/JDOMUtil", "updateFileSet"));
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    @Deprecated
    public static Element convertToDOM(@NotNull org.jdom.Element e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/util/JDOMUtil", "convertToDOM"));
        }
        try {
            Document d = new Document();
            org.jdom.Element newRoot = new org.jdom.Element(e.getName());
            List attributes = e.getAttributes();
            for (Object o : attributes) {
                Attribute attr = (Attribute)o;
                newRoot.setAttribute(attr.getName(), attr.getValue(), attr.getNamespace());
            }
            d.addContent((Content)newRoot);
            newRoot.addContent((Collection)e.cloneContent());
            return new DOMOutputter().output(d).getDocumentElement();
        }
        catch (JDOMException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Deprecated
    public static org.jdom.Element convertFromDOM(Element e) {
        return new DOMBuilder().build(e);
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    @Deprecated
    @Nullable
    public static org.jdom.Element cloneElement(@NotNull org.jdom.Element element, @NotNull ElementFilter elementFilter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/util/JDOMUtil", "cloneElement"));
        }
        if (elementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementFilter", "com/intellij/openapi/util/JDOMUtil", "cloneElement"));
        }
        org.jdom.Element result = new org.jdom.Element(element.getName(), element.getNamespace());
        List attributes = element.getAttributes();
        if (!attributes.isEmpty()) {
            ArrayList<Attribute> list = new ArrayList<Attribute>(attributes.size());
            for (Attribute attribute : attributes) {
                list.add(attribute.clone());
            }
            result.setAttributes(list);
        }
        for (Namespace namespace : element.getAdditionalNamespaces()) {
            result.addNamespaceDeclaration(namespace);
        }
        boolean hasContent = false;
        for (Content content : element.getContent()) {
            if (content instanceof org.jdom.Element) {
                if (!elementFilter.matches((Object)content)) continue;
                hasContent = true;
            }
            result.addContent(content.clone());
        }
        return hasContent ? result : null;
    }

    public static boolean isEmpty(@Nullable org.jdom.Element element) {
        return element == null || element.getAttributes().isEmpty() && element.getContent().isEmpty();
    }

    private static class ElementInfo {
        @NotNull
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeAttributeEntities"));
            }
            String string = JDOMUtil.escapeText(str, false, true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeAttributeEntities"));
            }
            return string;
        }

        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeElementEntities"));
            }
            String string = JDOMUtil.escapeText(str, false, false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter", "escapeElementEntities"));
            }
            return string;
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");

        private LoggerHolder() {
        }
    }
}

