/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AttributeBinding
extends BasePrimitiveBinding {
    private final Class<?> valueClass;

    public AttributeBinding(@NotNull Accessor accessor, @NotNull Attribute attribute) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/AttributeBinding", "<init>"));
        }
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/util/xmlb/AttributeBinding", "<init>"));
        }
        super(accessor, attribute.value(), attribute.converter());
        this.valueClass = XmlSerializerImpl.typeToClass(accessor.getGenericType());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/AttributeBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/AttributeBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return null;
        }
        String stringValue = this.myConverter == null ? TextBinding.convertToString(value) : this.myConverter.toString(value);
        return new org.jdom.Attribute(this.myName, stringValue);
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/AttributeBinding", "deserialize"));
        }
        String value = ((org.jdom.Attribute)node).getValue();
        if (this.myConverter == null) {
            XmlSerializerImpl.doSet(context, value, this.myAccessor, this.valueClass);
        } else {
            this.myAccessor.set(context, this.myConverter.fromString(value));
        }
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof org.jdom.Attribute && ((org.jdom.Attribute)node).getName().equals(this.myName);
    }

    @Override
    @NotNull
    public Class getBoundNodeType() {
        if (org.jdom.Attribute.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/AttributeBinding", "getBoundNodeType"));
        }
        return org.jdom.Attribute.class;
    }

    public String toString() {
        return "AttributeBinding[" + this.myName + "]";
    }
}

