/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PropertyAccessor
implements Accessor {
    private final String myName;
    private final Class<?> myType;
    private final Method myReadMethod;
    private final Method setter;
    private final Type myGenericType;

    public PropertyAccessor(PropertyDescriptor descriptor) {
        this(descriptor.getName(), descriptor.getPropertyType(), descriptor.getReadMethod(), descriptor.getWriteMethod());
    }

    public PropertyAccessor(String name, Class<?> type, @NotNull Method readMethod, @NotNull Method writeMethod) {
        if (readMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readMethod", "com/intellij/util/xmlb/PropertyAccessor", "<init>"));
        }
        if (writeMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writeMethod", "com/intellij/util/xmlb/PropertyAccessor", "<init>"));
        }
        this.myName = name;
        this.myType = type;
        this.myReadMethod = readMethod;
        this.setter = writeMethod;
        this.myGenericType = this.myReadMethod.getGenericReturnType();
        try {
            this.myReadMethod.setAccessible(true);
            this.setter.setAccessible(true);
        }
        catch (SecurityException ignored) {
            // empty catch block
        }
    }

    @Override
    public Object read(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/PropertyAccessor", "read"));
        }
        try {
            return this.myReadMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void set(@NotNull Object host, @Nullable Object value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "set"));
        }
        try {
            this.setter.invoke(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new XmlSerializationException(e);
        }
    }

    @Override
    public void setBoolean(@NotNull Object host, boolean value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setBoolean"));
        }
        this.set(host, value);
    }

    @Override
    public void setInt(@NotNull Object host, int value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setInt"));
        }
        this.set(host, value);
    }

    @Override
    public void setShort(@NotNull Object host, short value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setShort"));
        }
        this.set(host, value);
    }

    @Override
    public void setLong(@NotNull Object host, long value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setLong"));
        }
        this.set(host, value);
    }

    @Override
    public void setDouble(@NotNull Object host, double value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setDouble"));
        }
        this.set(host, value);
    }

    @Override
    public void setFloat(@NotNull Object host, float value) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/PropertyAccessor", "setFloat"));
        }
        this.set(host, Float.valueOf(value));
    }

    @Override
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/util/xmlb/PropertyAccessor", "getAnnotation"));
        }
        T annotation = this.myReadMethod.getAnnotation(annotationClass);
        return annotation == null ? this.setter.getAnnotation(annotationClass) : annotation;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Class<?> getValueClass() {
        return this.myType;
    }

    @Override
    public Type getGenericType() {
        return this.myGenericType;
    }

    @Override
    public boolean isFinal() {
        return false;
    }

    @NonNls
    public String toString() {
        return "PropertyAccessor[" + this.myReadMethod.getDeclaringClass().getName() + "." + this.getName() + "]";
    }
}

