/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SkipDefaultsSerializationFilter
extends SkipDefaultValuesSerializationFilters {
    boolean equal(@NotNull Binding binding, @NotNull Object bean) {
        if (binding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/util/xmlb/SkipDefaultsSerializationFilter", "equal"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/SkipDefaultsSerializationFilter", "equal"));
        }
        Accessor accessor = binding.getAccessor();
        return this.equal(binding, accessor.read(bean), accessor.read(this.getDefaultBean(bean)));
    }

    boolean equal(@Nullable Binding binding, @Nullable Object currentValue, @Nullable Object defaultValue) {
        Binding referencedBinding;
        if (defaultValue instanceof Element && currentValue instanceof Element) {
            return JDOMUtil.areElementsEqual((Element)currentValue, (Element)defaultValue);
        }
        if (currentValue == defaultValue) {
            return true;
        }
        if (currentValue == null || defaultValue == null) {
            return false;
        }
        if (binding instanceof BasePrimitiveBinding && (referencedBinding = ((BasePrimitiveBinding)binding).myBinding) instanceof BeanBinding) {
            BeanBinding classBinding = (BeanBinding)referencedBinding;
            ThreeState compareByFields = classBinding.hasEqualMethod;
            if (compareByFields == ThreeState.UNSURE) {
                try {
                    classBinding.myBeanClass.getDeclaredMethod("equals", Object.class);
                    compareByFields = ThreeState.NO;
                }
                catch (NoSuchMethodException ignored) {
                    compareByFields = ThreeState.YES;
                }
                catch (Exception e) {
                    BeanBinding.LOG.warn(e);
                }
                classBinding.hasEqualMethod = compareByFields;
            }
            if (compareByFields == ThreeState.YES) {
                return classBinding.equalByFields(currentValue, defaultValue, this);
            }
        }
        return Comparing.equal(currentValue, defaultValue);
    }
}

