/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.TextBinding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    public TagBinding(@NotNull Accessor accessor, @NotNull Tag tagAnnotation) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        if (tagAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagAnnotation", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = StringUtil.nullize(tagAnnotation.textIfEmpty());
    }

    @Override
    @Nullable
    public Object serialize(@NotNull Object o, @Nullable Object context, @NotNull SerializationFilter filter) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/util/xmlb/TagBinding", "serialize"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/TagBinding", "serialize"));
        }
        Object value = this.myAccessor.read(o);
        Element serialized = new Element(this.myName);
        if (value == null) {
            return serialized;
        }
        if (this.myBinding == null) {
            serialized.addContent((Content)new Text(TextBinding.convertToString(value)));
        } else {
            Object node = this.myBinding.serialize(value, serialized, filter);
            if (node != null && node != serialized) {
                JDOMUtil.addContent(serialized, node);
            }
        }
        return serialized;
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<?> nodes) {
        List<? extends Content> children;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/util/xmlb/TagBinding", "deserializeList"));
        }
        boolean isBeanBinding = this.myBinding instanceof BeanBinding;
        if (nodes.size() == 1) {
            children = TagBinding.getContents(isBeanBinding, (Element)nodes.get(0));
        } else {
            String name = ((Element)nodes.get(0)).getName();
            children = new SmartList<Content>();
            for (Object node : nodes) {
                Element element = (Element)node;
                assert (element.getName().equals(name));
                children.addAll(TagBinding.getContents(isBeanBinding, element));
            }
        }
        return this.deserialize(context, children, isBeanBinding);
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Object node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        boolean isBeanBinding = this.myBinding instanceof BeanBinding;
        Element element = (Element)node;
        return this.deserialize(context, TagBinding.getContents(isBeanBinding, element), isBeanBinding);
    }

    private Object deserialize(Object o, List<? extends Content> children, boolean isBeanBinding) {
        if (isBeanBinding && this.myAccessor.isFinal()) {
            assert (this.myBinding != null);
            ((BeanBinding)this.myBinding).deserializeInto(o, (Element)children.get(0), null);
        } else if (this.myTextIfEmpty != null && children.isEmpty()) {
            XmlSerializerImpl.doSet(o, this.myTextIfEmpty, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else if (this.myBinding == null) {
            XmlSerializerImpl.doSet(o, children.isEmpty() ? "" : children.get(0).getValue(), this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.myAccessor.set(o, Binding.deserializeList(this.myBinding, this.myAccessor.read(o), children));
        }
        return o;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myName);
    }

    @NotNull
    private static List<? extends Content> getContents(boolean isBeanBinding, Element element) {
        List<Content> list = isBeanBinding ? element.getChildren() : XmlSerializerImpl.getFilteredContent(element);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/TagBinding", "getContents"));
        }
        return list;
    }
}

