/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.ArrayBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.CollectionBinding;
import com.intellij.util.xmlb.CompactCollectionBinding;
import com.intellij.util.xmlb.JDOMElementBinding;
import com.intellij.util.xmlb.MapBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.annotations.CollectionBean;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlSerializerImpl {
    private static final Filter<Content> CONTENT_FILTER = new Filter<Content>(){

        public boolean matches(Object object) {
            return !XmlSerializerImpl.isIgnoredNode(object);
        }
    };
    private static java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>> ourBindings;

    XmlSerializerImpl() {
    }

    @NotNull
    static List<Content> getFilteredContent(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
        }
        List content = element.getContent();
        if (content.isEmpty()) {
            List list = content;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
            }
            return list;
        }
        if (content.size() == 1) {
            List list = XmlSerializerImpl.isIgnoredNode(content.get(0)) ? Collections.emptyList() : content;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
            }
            return list;
        }
        List list = element.getContent(CONTENT_FILTER);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getFilteredContent"));
        }
        return list;
    }

    @NotNull
    static Element serialize(@NotNull Object object, @NotNull SerializationFilter filter) throws XmlSerializationException {
        Element element;
        Binding binding;
        block8: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            Class<?> aClass = object.getClass();
            binding = XmlSerializerImpl.getClassBinding(aClass, aClass, null);
            if (!(binding instanceof BeanBinding)) break block8;
            Element element2 = ((BeanBinding)binding).serialize(object, true, filter);
            if (element2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
            }
            return element2;
        }
        try {
            element = (Element)binding.serialize(object, null, filter);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Can't serialize instance of " + object.getClass(), e);
        }
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "serialize"));
        }
        return element;
    }

    @Nullable
    static Element serializeIfNotDefault(@NotNull Object object, @NotNull SerializationFilter filter) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/xmlb/XmlSerializerImpl", "serializeIfNotDefault"));
        }
        Class<?> aClass = object.getClass();
        Binding binding = XmlSerializerImpl.getClassBinding(aClass, aClass, null);
        assert (binding != null);
        return (Element)binding.serialize(object, null, filter);
    }

    @Nullable
    static Binding getBinding(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, null);
    }

    @Nullable
    static Binding getBinding(@NotNull Accessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "getBinding"));
        }
        Type type = accessor.getGenericType();
        return XmlSerializerImpl.getClassBinding(XmlSerializerImpl.typeToClass(type), type, accessor);
    }

    @NotNull
    static Class<?> typeToClass(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        if (type instanceof TypeVariable) {
            Type bound = ((TypeVariable)type).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type).getRawType();
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "typeToClass"));
        }
        return clazz;
    }

    @Nullable
    static synchronized Binding getClassBinding(@NotNull Class<?> aClass, @NotNull Type originalType, @Nullable Accessor accessor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "getClassBinding"));
        }
        if (aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass)) {
            return null;
        }
        Pair<Type, Accessor> key = Pair.create(originalType, accessor);
        Map<Pair<Type, Accessor>, Binding> map = XmlSerializerImpl.getBindingCacheMap();
        Binding binding = map.get(key);
        if (binding == null) {
            binding = XmlSerializerImpl.getNonCachedClassBinding(aClass, accessor, originalType);
            map.put(key, binding);
            try {
                binding.init(originalType);
            }
            catch (XmlSerializationException e) {
                map.remove(key);
                throw e;
            }
        }
        return binding;
    }

    @NotNull
    private static Map<Pair<Type, Accessor>, Binding> getBindingCacheMap() {
        Map<Pair<Type, Accessor>, Binding> map = SoftReference.dereference(ourBindings);
        if (map == null) {
            map = new ConcurrentHashMap<Pair<Type, Accessor>, Binding>();
            ourBindings = new java.lang.ref.SoftReference<Map<Pair<Type, Accessor>, Binding>>(map);
        }
        Map<Pair<Type, Accessor>, Binding> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getBindingCacheMap"));
        }
        return map2;
    }

    @NotNull
    private static Binding getNonCachedClassBinding(@NotNull Class<?> aClass, @Nullable Accessor accessor, @NotNull Type originalType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (originalType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        if (aClass.isArray()) {
            if (Element.class.isAssignableFrom(aClass.getComponentType())) {
                assert (accessor != null);
                JDOMElementBinding jDOMElementBinding = new JDOMElementBinding(accessor);
                if (jDOMElementBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return jDOMElementBinding;
            }
            ArrayBinding arrayBinding = new ArrayBinding(aClass, accessor);
            if (arrayBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
            }
            return arrayBinding;
        }
        if (Collection.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
            CollectionBean listBean;
            if (accessor != null && (listBean = accessor.getAnnotation(CollectionBean.class)) != null) {
                CompactCollectionBinding compactCollectionBinding = new CompactCollectionBinding(accessor);
                if (compactCollectionBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return compactCollectionBinding;
            }
            CollectionBinding collectionBinding = new CollectionBinding((ParameterizedType)originalType, accessor);
            if (collectionBinding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
            }
            return collectionBinding;
        }
        if (accessor != null) {
            if (Map.class.isAssignableFrom(aClass) && originalType instanceof ParameterizedType) {
                MapBinding mapBinding = new MapBinding(accessor);
                if (mapBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return mapBinding;
            }
            if (Element.class.isAssignableFrom(aClass)) {
                JDOMElementBinding jDOMElementBinding = new JDOMElementBinding(accessor);
                if (jDOMElementBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return jDOMElementBinding;
            }
            if (JDOMExternalizableStringList.class == aClass) {
                CompactCollectionBinding compactCollectionBinding = new CompactCollectionBinding(accessor);
                if (compactCollectionBinding == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
                }
                return compactCollectionBinding;
            }
        }
        BeanBinding beanBinding = new BeanBinding(aClass, accessor);
        if (beanBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializerImpl", "getNonCachedClassBinding"));
        }
        return beanBinding;
    }

    @Nullable
    static Object convert(@Nullable String value, @NotNull Class<?> valueClass) {
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "convert"));
        }
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (valueClass == Integer.TYPE || valueClass == Integer.class) {
            return Integer.parseInt(value);
        }
        if (valueClass == Boolean.TYPE || valueClass == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (valueClass == Double.TYPE || valueClass == Double.class) {
            return Double.parseDouble(value);
        }
        if (valueClass == Float.TYPE || valueClass == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (valueClass == Long.TYPE || valueClass == Long.class) {
            return Long.parseLong(value);
        }
        if (valueClass.isEnum()) {
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                return enumConstant;
            }
            return null;
        }
        if (Date.class.isAssignableFrom(valueClass)) {
            try {
                return new Date(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                return new Date(0L);
            }
        }
        return value;
    }

    public static boolean isIgnoredNode(Object child) {
        if (child instanceof Text && StringUtil.isEmptyOrSpaces(((Text)child).getValue())) {
            return true;
        }
        if (child instanceof Comment) {
            return true;
        }
        return child instanceof Attribute && !StringUtil.isEmpty(((Attribute)child).getNamespaceURI());
    }

    static void doSet(@NotNull Object host, @Nullable String value, @NotNull Accessor accessor, @NotNull Class<?> valueClass) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (valueClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueClass", "com/intellij/util/xmlb/XmlSerializerImpl", "doSet"));
        }
        if (value == null) {
            accessor.set(host, null);
        } else if (valueClass == String.class) {
            accessor.set(host, value);
        } else if (valueClass == Integer.TYPE) {
            accessor.setInt(host, Integer.parseInt(value));
        } else if (valueClass == Boolean.TYPE) {
            accessor.setBoolean(host, Boolean.parseBoolean(value));
        } else if (valueClass == Double.TYPE) {
            accessor.setDouble(host, Double.parseDouble(value));
        } else if (valueClass == Float.TYPE) {
            accessor.setFloat(host, Float.parseFloat(value));
        } else if (valueClass == Long.TYPE) {
            accessor.setLong(host, Long.parseLong(value));
        } else if (valueClass == Short.TYPE) {
            accessor.setShort(host, Short.parseShort(value));
        } else if (valueClass.isEnum()) {
            Object deserializedValue = null;
            for (Object enumConstant : valueClass.getEnumConstants()) {
                if (!enumConstant.toString().equals(value)) continue;
                deserializedValue = enumConstant;
            }
            accessor.set(host, deserializedValue);
        } else if (Date.class.isAssignableFrom(valueClass)) {
            try {
                accessor.set(host, new Date(Long.parseLong(value)));
            }
            catch (NumberFormatException e) {
                accessor.set(host, new Date(0L));
            }
        } else {
            Object deserializedValue = value;
            if (valueClass == Boolean.class) {
                deserializedValue = Boolean.parseBoolean(value);
            } else if (valueClass == Integer.class) {
                deserializedValue = Integer.parseInt(value);
            } else if (valueClass == Short.class) {
                deserializedValue = Short.parseShort(value);
            } else if (valueClass == Long.class) {
                deserializedValue = Long.parseLong(value);
            } else if (valueClass == Double.class) {
                deserializedValue = Double.parseDouble(value);
            } else if (valueClass == Float.class) {
                deserializedValue = Float.valueOf(Float.parseFloat(value));
            }
            accessor.set(host, deserializedValue);
        }
    }
}

