/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcherEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeAssocTable<T> {
    private final Map<CharSequence, T> myExtensionMappings;
    private final Map<CharSequence, T> myExactFileNameMappings;
    private final Map<CharSequence, T> myExactFileNameAnyCaseMappings;
    private boolean myHasAnyCaseExactMappings;
    private final List<Pair<FileNameMatcher, T>> myMatchingMappings;

    private FileTypeAssocTable(Map<CharSequence, T> extensionMappings, Map<CharSequence, T> exactFileNameMappings, Map<CharSequence, T> exactFileNameAnyCaseMappings, List<Pair<FileNameMatcher, T>> matchingMappings) {
        this.myExtensionMappings = new THashMap(extensionMappings, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE);
        this.myExactFileNameMappings = new THashMap(exactFileNameMappings, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE);
        this.myExactFileNameAnyCaseMappings = new THashMap<CharSequence, T>(exactFileNameAnyCaseMappings, (TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_INSENSITIVE){

            public T remove(Object key) {
                Object removed = super.remove(key);
                FileTypeAssocTable.this.myHasAnyCaseExactMappings = this.size() > 0;
                return removed;
            }

            public T put(CharSequence key, T value) {
                Object result = super.put((Object)key, value);
                FileTypeAssocTable.this.myHasAnyCaseExactMappings = true;
                return result;
            }
        };
        this.myMatchingMappings = new ArrayList<Pair<FileNameMatcher, T>>(matchingMappings);
    }

    public FileTypeAssocTable() {
        this(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    public boolean isAssociatedWith(T type, FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher || matcher instanceof ExactFileNameMatcher) {
            return this.findAssociatedFileType(matcher) == type;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst()) || type != mapping.getSecond()) continue;
            return true;
        }
        return false;
    }

    public void addAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            this.myExtensionMappings.put(((ExtensionFileNameMatcher)matcher).getExtension(), type);
        } else if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            if (exactFileNameMatcher.isIgnoreCase()) {
                this.myExactFileNameAnyCaseMappings.put(exactFileNameMatcher.getFileName(), type);
            } else {
                this.myExactFileNameMappings.put(exactFileNameMatcher.getFileName(), type);
            }
        } else {
            this.myMatchingMappings.add(Pair.create((Object)matcher, type));
        }
    }

    public boolean removeAssociation(FileNameMatcher matcher, T type) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            String extension = ((ExtensionFileNameMatcher)matcher).getExtension();
            if (this.myExtensionMappings.get(extension) == type) {
                this.myExtensionMappings.remove(extension);
                return true;
            }
            return false;
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            String string = exactFileNameMatcher.getFileName();
            Map<CharSequence, T> mapToUse = exactFileNameMatcher.isIgnoreCase() ? this.myExactFileNameAnyCaseMappings : this.myExactFileNameMappings;
            if (mapToUse.get(string) == type) {
                mapToUse.remove(string);
                return true;
            }
            return false;
        }
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (!matcher.equals(pair.getFirst())) continue;
            this.myMatchingMappings.remove(pair);
            return true;
        }
        return false;
    }

    public boolean removeAllAssociations(T type) {
        boolean changed = this.removeAssociationsFromMap(this.myExtensionMappings, type, false);
        changed = this.removeAssociationsFromMap(this.myExactFileNameAnyCaseMappings, type, changed);
        changed = this.removeAssociationsFromMap(this.myExactFileNameMappings, type, changed);
        ArrayList<Pair<FileNameMatcher, T>> copy = new ArrayList<Pair<FileNameMatcher, T>>(this.myMatchingMappings);
        for (Pair pair : copy) {
            if (pair.getSecond() != type) continue;
            this.myMatchingMappings.remove(pair);
            changed = true;
        }
        return changed;
    }

    private boolean removeAssociationsFromMap(Map<CharSequence, T> extensionMappings, T type, boolean changed) {
        CharSequence[] extsStrings;
        Set<CharSequence> exts = extensionMappings.keySet();
        for (CharSequence s : extsStrings = exts.toArray(new CharSequence[exts.size()])) {
            if (extensionMappings.get(s) != type) continue;
            extensionMappings.remove(s);
            changed = true;
        }
        return changed;
    }

    @Nullable
    public T findAssociatedFileType(@NotNull @NonNls CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "findAssociatedFileType"));
        }
        T t = this.myExactFileNameMappings.get(fileName);
        if (t != null) {
            return t;
        }
        if (this.myHasAnyCaseExactMappings && (t = this.myExactFileNameAnyCaseMappings.get(fileName)) != null) {
            return t;
        }
        int n = this.myMatchingMappings.size();
        for (int i = 0; i < n; ++i) {
            Pair<FileNameMatcher, T> mapping = this.myMatchingMappings.get(i);
            if (!FileNameMatcherEx.acceptsCharSequence((FileNameMatcher)mapping.getFirst(), fileName)) continue;
            return (T)mapping.getSecond();
        }
        return this.myExtensionMappings.get(FileUtilRt.getExtension((CharSequence)fileName));
    }

    @Nullable
    public T findAssociatedFileType(FileNameMatcher matcher) {
        if (matcher instanceof ExtensionFileNameMatcher) {
            return this.myExtensionMappings.get(((ExtensionFileNameMatcher)matcher).getExtension());
        }
        if (matcher instanceof ExactFileNameMatcher) {
            ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
            if (exactFileNameMatcher.isIgnoreCase()) {
                return this.myExactFileNameAnyCaseMappings.get(exactFileNameMatcher.getFileName());
            }
            return this.myExactFileNameMappings.get(exactFileNameMatcher.getFileName());
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (!matcher.equals(mapping.getFirst())) continue;
            return (T)mapping.getSecond();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public String[] getAssociatedExtensions(T type) {
        Map<CharSequence, T> extMap = this.myExtensionMappings;
        ArrayList<String> exts = new ArrayList<String>();
        for (CharSequence ext : extMap.keySet()) {
            if (extMap.get(ext) != type) continue;
            exts.add(((Object)ext).toString());
        }
        String[] stringArray = ArrayUtil.toStringArray(exts);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociatedExtensions"));
        }
        return stringArray;
    }

    @NotNull
    public FileTypeAssocTable<T> copy() {
        FileTypeAssocTable<T> fileTypeAssocTable = new FileTypeAssocTable<T>(this.myExtensionMappings, this.myExactFileNameMappings, this.myExactFileNameAnyCaseMappings, this.myMatchingMappings);
        if (fileTypeAssocTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "copy"));
        }
        return fileTypeAssocTable;
    }

    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull T type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociations"));
        }
        ArrayList<FileNameMatcher> result = new ArrayList<FileNameMatcher>();
        for (Pair<FileNameMatcher, T> pair : this.myMatchingMappings) {
            if (pair.getSecond() != type) continue;
            result.add((FileNameMatcher)pair.getFirst());
        }
        for (Map.Entry entry : this.myExactFileNameMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add(new ExactFileNameMatcher(((Object)((CharSequence)entry.getKey())).toString()));
        }
        for (Map.Entry entry : this.myExactFileNameAnyCaseMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add(new ExactFileNameMatcher(((Object)((CharSequence)entry.getKey())).toString(), true));
        }
        for (Map.Entry entry : this.myExtensionMappings.entrySet()) {
            if (entry.getValue() != type) continue;
            result.add(new ExtensionFileNameMatcher(((Object)((CharSequence)entry.getKey())).toString()));
        }
        ArrayList<FileNameMatcher> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "getAssociations"));
        }
        return arrayList;
    }

    public boolean hasAssociationsFor(@NotNull T fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/openapi/fileTypes/impl/FileTypeAssocTable", "hasAssociationsFor"));
        }
        if (this.myExtensionMappings.values().contains(fileType) || this.myExactFileNameMappings.values().contains(fileType) || this.myExactFileNameAnyCaseMappings.values().contains(fileType)) {
            return true;
        }
        for (Pair<FileNameMatcher, T> mapping : this.myMatchingMappings) {
            if (mapping.getSecond() != fileType) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTypeAssocTable that = (FileTypeAssocTable)o;
        return ((Object)this.myExtensionMappings).equals(that.myExtensionMappings) && ((Object)this.myMatchingMappings).equals(that.myMatchingMappings) && ((Object)this.myExactFileNameMappings).equals(that.myExactFileNameMappings) && ((Object)this.myExactFileNameAnyCaseMappings).equals(that.myExactFileNameAnyCaseMappings);
    }

    public int hashCode() {
        int result = ((Object)this.myExtensionMappings).hashCode();
        result = 31 * result + ((Object)this.myMatchingMappings).hashCode();
        result = 31 * result + ((Object)this.myExactFileNameMappings).hashCode();
        result = 31 * result + ((Object)this.myExactFileNameAnyCaseMappings).hashCode();
        return result;
    }
}

