/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.model.JpsGwtCompilerProjectExtension;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class JpsGwtCompilerProjectExtensionImpl
extends JpsElementBase<JpsGwtCompilerProjectExtensionImpl>
implements JpsGwtCompilerProjectExtension {
    public static final JpsElementChildRole<JpsGwtCompilerProjectExtension> ROLE = JpsElementChildRoleBase.create((String)"GWT Compiler Configuration");
    private Set<String> myModulesToShowCompilerOutput;

    public JpsGwtCompilerProjectExtensionImpl(Collection<String> modulesToShowCompilerOutput) {
        this.myModulesToShowCompilerOutput = new LinkedHashSet<String>(modulesToShowCompilerOutput);
    }

    @NotNull
    public JpsGwtCompilerProjectExtensionImpl createCopy() {
        JpsGwtCompilerProjectExtensionImpl jpsGwtCompilerProjectExtensionImpl = new JpsGwtCompilerProjectExtensionImpl(this.myModulesToShowCompilerOutput);
        if (jpsGwtCompilerProjectExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/JpsGwtCompilerProjectExtensionImpl", "createCopy"));
        }
        return jpsGwtCompilerProjectExtensionImpl;
    }

    @Override
    public boolean isShowCompilerOutput(JpsGwtModuleExtension extension) {
        return this.myModulesToShowCompilerOutput.contains(extension.getModule().getName());
    }

    public void applyChanges(@NotNull JpsGwtCompilerProjectExtensionImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/gwt/model/impl/JpsGwtCompilerProjectExtensionImpl", "applyChanges"));
        }
        if (!((Object)this.myModulesToShowCompilerOutput).equals(modified.myModulesToShowCompilerOutput)) {
            this.myModulesToShowCompilerOutput.clear();
            this.myModulesToShowCompilerOutput.addAll(modified.myModulesToShowCompilerOutput);
            this.fireElementChanged();
        }
    }
}

