/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.Nullable;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.XmlDocument;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Optional;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XmlLoader {
    public static final SourceLocation UNKNOWN = new SourceLocation("Unknown location", null);

    private XmlLoader() {
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> systemPropertyResolver, String displayName, File xmlFile, XmlDocument.Type type, Optional<String> mainManifestPackageName) throws IOException, SAXException, ParserConfigurationException {
        PositionXmlParser positionXmlParser = new PositionXmlParser();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(xmlFile));
        Document domDocument = positionXmlParser.parse((InputStream)inputStream);
        return domDocument != null ? new XmlDocument(positionXmlParser, new SourceLocation(displayName, xmlFile), selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName) : null;
    }

    public static XmlDocument load(KeyResolver<String> selectors, PlaceholderHandler.KeyBasedValueResolver<ManifestMerger2.SystemProperty> systemPropertyResolver, SourceLocation sourceLocation, String xml, XmlDocument.Type type, Optional<String> mainManifestPackageName) throws IOException, SAXException, ParserConfigurationException {
        PositionXmlParser positionXmlParser = new PositionXmlParser();
        Document domDocument = positionXmlParser.parse(xml);
        return domDocument != null ? new XmlDocument(positionXmlParser, sourceLocation, selectors, systemPropertyResolver, domDocument.getDocumentElement(), type, mainManifestPackageName) : null;
    }

    public static class SourceLocation {
        @Nullable
        private final File mSource;
        @Nullable
        private final String mDescription;

        public SourceLocation(@Nullable String description, @Nullable File source) {
            if (description == null && source == null) {
                throw new IllegalArgumentException("description and source cannot be both null");
            }
            this.mDescription = description == null ? source.getName() : description;
            this.mSource = source;
        }

        String print(boolean shortFormat) {
            return shortFormat ? this.mDescription : (this.mSource == null ? this.mDescription : this.mSource.getAbsolutePath());
        }
    }
}

