/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LanguageQualifier;
import com.android.ide.common.resources.configuration.RegionQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.utils.Pair;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Locale;

public final class LocaleQualifier
extends ResourceQualifier {
    public static final String NAME = "Locale";
    public static final String PREFIX = "b+";
    private String mValue;

    @Nullable
    public static LocaleQualifier getQualifier(@NonNull String segment) {
        if (segment.startsWith(PREFIX)) {
            LocaleQualifier qualifier = new LocaleQualifier();
            qualifier.mValue = LocaleQualifier.normalizeCase(segment);
            return qualifier;
        }
        return null;
    }

    @NonNull
    public static String normalizeCase(@NonNull String segment) {
        if (LocaleQualifier.isNormalizedCase(segment)) {
            return segment;
        }
        StringBuilder sb = new StringBuilder(segment.length());
        sb.append(PREFIX);
        assert (segment.startsWith(PREFIX));
        int segmentBegin = PREFIX.length();
        int segmentLength = segment.length();
        int start = segmentBegin;
        int lastLength = -1;
        while (start < segmentLength) {
            int i;
            int length;
            int end;
            if (start != segmentBegin) {
                sb.append('+');
            }
            if ((end = segment.indexOf(43, start)) == -1) {
                end = segmentLength;
            }
            if ((length = end - start) != 2 && length != 4 || start == segmentBegin || lastLength == 1) {
                for (i = start; i < end; ++i) {
                    sb.append(Character.toLowerCase(segment.charAt(i)));
                }
            } else if (length == 2) {
                for (i = start; i < end; ++i) {
                    sb.append(Character.toUpperCase(segment.charAt(i)));
                }
            } else {
                assert (length == 4) : length;
                sb.append(Character.toUpperCase(segment.charAt(start)));
                for (i = start + 1; i < end; ++i) {
                    sb.append(Character.toLowerCase(segment.charAt(i)));
                }
            }
            lastLength = length;
            start = end + 1;
        }
        return sb.toString();
    }

    static boolean isNormalizedCase(@NonNull String segment) {
        assert (segment.startsWith(PREFIX));
        int segmentBegin = PREFIX.length();
        int segmentLength = segment.length();
        int start = segmentBegin;
        int lastLength = -1;
        while (start < segmentLength) {
            int length;
            int end = segment.indexOf(43, start);
            if (end == -1) {
                end = segmentLength;
            }
            if ((length = end - start) != 2 && length != 4 || start == segmentBegin || lastLength == 1) {
                if (LocaleQualifier.isNotLowerCase(segment, start, end)) {
                    return false;
                }
            } else if (length == 2) {
                if (LocaleQualifier.isNotUpperCase(segment, start, end)) {
                    return false;
                }
            } else {
                assert (length == 4) : length;
                if (LocaleQualifier.isNotUpperCase(segment, start, start + 1)) {
                    return false;
                }
                if (LocaleQualifier.isNotLowerCase(segment, start + 1, end)) {
                    return false;
                }
            }
            lastLength = length;
            start = end + 1;
        }
        return true;
    }

    private static boolean isNotLowerCase(@NonNull String segment, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Character.isUpperCase(segment.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotUpperCase(@NonNull String segment, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Character.isLowerCase(segment.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getFolderSegment(@NonNull String value) {
        String segment = value.toLowerCase(Locale.US);
        if (segment.startsWith(PREFIX)) {
            return segment;
        }
        return null;
    }

    public LocaleQualifier() {
    }

    public LocaleQualifier(@NonNull String value) {
        this.mValue = value;
    }

    @NonNull
    public String getValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mValue != null;
    }

    @Override
    public boolean hasFakeValue() {
        return this.mValue == null || this.mValue.isEmpty();
    }

    @Override
    public boolean checkAndSet(@NonNull String value, @NonNull FolderConfiguration config) {
        LocaleQualifier qualifier = LocaleQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setLocaleQualifier(qualifier);
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object qualifier) {
        if (qualifier instanceof LocaleQualifier) {
            if (this.mValue == null) {
                return ((LocaleQualifier)qualifier).mValue == null;
            }
            return this.mValue.equals(((LocaleQualifier)qualifier).mValue);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.mValue != null) {
            return this.mValue.hashCode();
        }
        return 0;
    }

    @Override
    public String getFolderSegment() {
        if (this.mValue != null) {
            return LocaleQualifier.normalizeCase(this.mValue);
        }
        return "";
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mValue != null) {
            return this.mValue;
        }
        return "";
    }

    @Override
    public String getLongDisplayValue() {
        if (this.mValue != null) {
            return String.format("Locale %s", this.mValue);
        }
        return "";
    }

    @Nullable
    public static Pair<String, String> parseBcp47(@NonNull String qualifier) {
        if (qualifier.startsWith(PREFIX)) {
            Iterator iterator = Splitter.on((char)'+').split((CharSequence)qualifier).iterator();
            iterator.next();
            if (iterator.hasNext()) {
                String language = (String)iterator.next();
                String region = null;
                if (language.length() >= 2 && language.length() <= 3) {
                    if (iterator.hasNext()) {
                        String next = (String)iterator.next();
                        if (next.length() == 4) {
                            if (iterator.hasNext()) {
                                next = (String)iterator.next();
                            }
                        } else if (next.length() >= 5) {
                            return Pair.of((Object)language, null);
                        }
                        if (next.length() >= 2 && next.length() <= 3) {
                            region = next;
                        }
                    }
                    return Pair.of((Object)language, region);
                }
            }
        }
        return null;
    }

    @Nullable
    public LanguageQualifier getLanguageQualifier() {
        if (this.mValue != null && !this.mValue.isEmpty()) {
            String languageCode;
            assert (this.mValue.startsWith(PREFIX));
            Pair<String, String> codes = LocaleQualifier.parseBcp47(this.mValue);
            if (codes != null && (languageCode = (String)codes.getFirst()) != null) {
                return new LanguageQualifier(languageCode);
            }
        }
        return null;
    }

    @Nullable
    public RegionQualifier getRegionQualifier() {
        if (this.mValue != null && !this.mValue.isEmpty()) {
            String regionCode;
            assert (this.mValue.startsWith(PREFIX));
            Pair<String, String> codes = LocaleQualifier.parseBcp47(this.mValue);
            if (codes != null && (regionCode = (String)codes.getSecond()) != null) {
                return new RegionQualifier(regionCode);
            }
        }
        return null;
    }
}

