/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PagePool;
import com.intellij.util.io.RecordDataOutput;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.DataTable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class AbstractStorage
implements Disposable,
Forceable {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.Storage");
    @NonNls
    public static final String INDEX_EXTENSION = ".storageRecordIndex";
    @NonNls
    public static final String DATA_EXTENSION = ".storageData";
    private static final int MAX_PAGES_TO_FLUSH_AT_A_TIME = 50;
    protected final Object myLock = new Object();
    protected AbstractRecordsTable myRecordsTable;
    protected DataTable myDataTable;
    protected PagePool myPool;
    private final CapacityAllocationPolicy myCapacityAllocationPolicy;

    public static boolean deleteFiles(String storageFilePath) {
        File recordsFile = new File(storageFilePath + INDEX_EXTENSION);
        File dataFile = new File(storageFilePath + DATA_EXTENSION);
        boolean deletedRecordsFile = FileUtil.delete(recordsFile);
        boolean deletedDataFile = FileUtil.delete(dataFile);
        return deletedRecordsFile && deletedDataFile;
    }

    public static void convertFromOldExtensions(String storageFilePath) {
        FileUtil.delete(new File(storageFilePath + ".rindex"));
        FileUtil.delete(new File(storageFilePath + ".data"));
    }

    protected AbstractStorage(String storageFilePath) throws IOException {
        this(storageFilePath, PagePool.SHARED);
    }

    protected AbstractStorage(String storageFilePath, PagePool pool) throws IOException {
        this(storageFilePath, pool, CapacityAllocationPolicy.DEFAULT);
    }

    protected AbstractStorage(String storageFilePath, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        this(storageFilePath, PagePool.SHARED, capacityAllocationPolicy);
    }

    protected AbstractStorage(String storageFilePath, PagePool pool, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        this.myCapacityAllocationPolicy = capacityAllocationPolicy != null ? capacityAllocationPolicy : CapacityAllocationPolicy.DEFAULT;
        this.tryInit(storageFilePath, pool, 0);
    }

    private void tryInit(String storageFilePath, PagePool pool, int retryCount) throws IOException {
        DataTable dataTable;
        AbstractStorage.convertFromOldExtensions(storageFilePath);
        File recordsFile = new File(storageFilePath + INDEX_EXTENSION);
        File dataFile = new File(storageFilePath + DATA_EXTENSION);
        if (recordsFile.exists() != dataFile.exists()) {
            AbstractStorage.deleteFiles(storageFilePath);
        }
        FileUtil.createIfDoesntExist(recordsFile);
        FileUtil.createIfDoesntExist(dataFile);
        AbstractRecordsTable recordsTable = null;
        try {
            recordsTable = this.createRecordsTable(pool, recordsFile);
            dataTable = new DataTable(dataFile, pool);
        }
        catch (IOException e) {
            boolean deleted;
            LOG.info(e.getMessage());
            if (recordsTable != null) {
                recordsTable.dispose();
            }
            if (!(deleted = AbstractStorage.deleteFiles(storageFilePath))) {
                throw new IOException("Can't delete caches at: " + storageFilePath);
            }
            if (retryCount >= 5) {
                throw new IOException("Can't create storage at: " + storageFilePath);
            }
            this.tryInit(storageFilePath, pool, retryCount + 1);
            return;
        }
        this.myRecordsTable = recordsTable;
        this.myDataTable = dataTable;
        this.myPool = pool;
        if (this.myDataTable.isCompactNecessary()) {
            this.compact(storageFilePath);
        }
    }

    protected abstract AbstractRecordsTable createRecordsTable(PagePool var1, File var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact(String path) {
        Object object = this.myLock;
        synchronized (object) {
            LOG.info("Space waste in " + path + " is " + this.myDataTable.getWaste() + " bytes. Compacting now.");
            long start = System.currentTimeMillis();
            try {
                File newDataFile = new File(path + ".storageData.backup");
                FileUtil.delete(newDataFile);
                FileUtil.createIfDoesntExist(newDataFile);
                File oldDataFile = new File(path + DATA_EXTENSION);
                DataTable newDataTable = new DataTable(newDataFile, this.myPool);
                int count = this.myRecordsTable.getRecordsCount();
                for (int i = 1; i <= count; ++i) {
                    long addr = this.myRecordsTable.getAddress(i);
                    int size = this.myRecordsTable.getSize(i);
                    if (size <= 0) continue;
                    assert (addr > 0L);
                    int capacity = this.myCapacityAllocationPolicy.calculateCapacity(size);
                    long newaddr = newDataTable.allocateSpace(capacity);
                    byte[] bytes = new byte[size];
                    this.myDataTable.readBytes(addr, bytes);
                    newDataTable.writeBytes(newaddr, bytes);
                    this.myRecordsTable.setAddress(i, newaddr);
                    this.myRecordsTable.setCapacity(i, capacity);
                }
                this.myDataTable.dispose();
                newDataTable.dispose();
                if (!FileUtil.delete(oldDataFile)) {
                    throw new IOException("Can't delete file: " + oldDataFile);
                }
                newDataFile.renameTo(oldDataFile);
                this.myDataTable = new DataTable(oldDataFile, this.myPool);
            }
            catch (IOException e) {
                LOG.info("Compact failed: " + e.getMessage());
            }
            long timedelta = System.currentTimeMillis() - start;
            LOG.info("Done compacting in " + timedelta + "msec.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVersion() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myRecordsTable.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(int expectedVersion) {
        Object object = this.myLock;
        synchronized (object) {
            this.myRecordsTable.setVersion(expectedVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force() {
        Object object = this.myLock;
        synchronized (object) {
            this.myDataTable.force();
            this.myRecordsTable.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushSome() {
        Object object = this.myLock;
        synchronized (object) {
            boolean okRecords = this.myRecordsTable.flushSome(50);
            boolean okData = this.myDataTable.flushSome(50);
            return okRecords && okData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDataTable.isDirty() || this.myRecordsTable.isDirty();
        }
    }

    public StorageDataOutput writeStream(int record) {
        return this.writeStream(record, false);
    }

    public StorageDataOutput writeStream(int record, boolean fixedSize) {
        return new StorageDataOutput(this, record, fixedSize);
    }

    public AppenderStream appendStream(int record) {
        return new AppenderStream(record);
    }

    public DataInputStream readStream(int record) throws IOException {
        byte[] bytes = this.readBytes(record);
        return new DataInputStream(new UnsyncByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBytes(int record) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            int length = this.myRecordsTable.getSize(record);
            if (length == 0) {
                return ArrayUtil.EMPTY_BYTE_ARRAY;
            }
            assert (length > 0);
            long address = this.myRecordsTable.getAddress(record);
            byte[] result = new byte[length];
            this.myDataTable.readBytes(address, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendBytes(int record, ByteSequence bytes) throws IOException {
        int delta = bytes.getLength();
        if (delta == 0) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            int capacity = this.myRecordsTable.getCapacity(record);
            int oldSize = this.myRecordsTable.getSize(record);
            int newSize = oldSize + delta;
            if (newSize > capacity) {
                if (oldSize > 0) {
                    byte[] newbytes = new byte[newSize];
                    System.arraycopy(this.readBytes(record), 0, newbytes, 0, oldSize);
                    System.arraycopy(bytes.getBytes(), bytes.getOffset(), newbytes, oldSize, delta);
                    this.writeBytes(record, new ByteSequence(newbytes), false);
                } else {
                    this.writeBytes(record, bytes, false);
                }
            } else {
                long address = this.myRecordsTable.getAddress(record) + (long)oldSize;
                this.myDataTable.writeBytes(address, bytes.getBytes(), bytes.getOffset(), bytes.getLength());
                this.myRecordsTable.setSize(record, newSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(int record, ByteSequence bytes, boolean fixedSize) throws IOException {
        Object object = this.myLock;
        synchronized (object) {
            long address;
            int requiredLength = bytes.getLength();
            int currentCapacity = this.myRecordsTable.getCapacity(record);
            int currentSize = this.myRecordsTable.getSize(record);
            assert (currentSize >= 0);
            if (requiredLength == 0 && currentSize == 0) {
                return;
            }
            if (currentCapacity >= requiredLength) {
                address = this.myRecordsTable.getAddress(record);
            } else {
                int newCapacity;
                this.myDataTable.reclaimSpace(currentCapacity);
                int n = newCapacity = fixedSize ? requiredLength : this.myCapacityAllocationPolicy.calculateCapacity(requiredLength);
                if (newCapacity < requiredLength) {
                    newCapacity = requiredLength;
                }
                address = this.myDataTable.allocateSpace(newCapacity);
                this.myRecordsTable.setAddress(record, address);
                this.myRecordsTable.setCapacity(record, newCapacity);
            }
            this.myDataTable.writeBytes(address, bytes.getBytes(), bytes.getOffset(), bytes.getLength());
            this.myRecordsTable.setSize(record, requiredLength);
        }
    }

    protected void doDeleteRecord(int record) throws IOException {
        this.myDataTable.reclaimSpace(this.myRecordsTable.getCapacity(record));
        this.myRecordsTable.deleteRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRecordsTable.dispose();
            this.myDataTable.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSanity(int record) {
        Object object = this.myLock;
        synchronized (object) {
            int size = this.myRecordsTable.getSize(record);
            assert (size >= 0);
            long address = this.myRecordsTable.getAddress(record);
            assert (address >= 0L);
            assert (address + (long)size < this.myDataTable.getFileSize());
        }
    }

    public class AppenderStream
    extends DataOutputStream {
        private final int myRecordId;

        private AppenderStream(int recordId) {
            super(new BufferExposingByteArrayOutputStream());
            this.myRecordId = recordId;
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream _out = (BufferExposingByteArrayOutputStream)this.out;
            AbstractStorage.this.appendBytes(this.myRecordId, new ByteSequence(_out.getInternalBuffer(), 0, _out.size()));
        }
    }

    public static class StorageDataOutput
    extends DataOutputStream
    implements RecordDataOutput {
        private final AbstractStorage myStorage;
        private final int myRecordId;
        private final boolean myFixedSize;

        private StorageDataOutput(AbstractStorage storage, int recordId, boolean fixedSize) {
            super(new BufferExposingByteArrayOutputStream());
            this.myStorage = storage;
            this.myRecordId = recordId;
            this.myFixedSize = fixedSize;
        }

        @Override
        public void close() throws IOException {
            super.close();
            BufferExposingByteArrayOutputStream byteStream = this.getByteStream();
            this.myStorage.writeBytes(this.myRecordId, new ByteSequence(byteStream.getInternalBuffer(), 0, byteStream.size()), this.myFixedSize);
        }

        protected BufferExposingByteArrayOutputStream getByteStream() {
            return (BufferExposingByteArrayOutputStream)this.out;
        }

        @Override
        public int getRecordId() {
            return this.myRecordId;
        }
    }
}

