/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex.indexer.api;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PersistentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.classFilesIndex.indexer.api.ClassFileIndexer;
import org.jetbrains.jps.classFilesIndex.indexer.api.IndexState;
import org.jetbrains.jps.classFilesIndex.indexer.api.storage.ClassFilesIndexStorageBase;
import org.jetbrains.jps.classFilesIndex.indexer.api.storage.ClassFilesIndexStorageWriter;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.org.objectweb.asm.ClassReader;

public class ClassFilesIndexWriter<K, V> {
    private static final Logger LOG = Logger.getInstance(ClassFilesIndexWriter.class);
    private final ClassFileIndexer<K, V> myIndexer;
    private final boolean myEmpty;
    private final Mappings myMappings;
    private final ClassFilesIndexStorageWriter<K, V> myIndex;

    protected ClassFilesIndexWriter(ClassFileIndexer<K, V> indexer, CompileContext compileContext) {
        this.myIndexer = indexer;
        File storageDir = this.getIndexRoot(compileContext);
        Set<String> containingFileNames = ClassFilesIndexWriter.listFiles(storageDir);
        if (!containingFileNames.contains("version") || !containingFileNames.contains("state")) {
            throw new IllegalStateException("version or state file for index " + indexer.getIndexCanonicalName() + " not found in " + storageDir.getAbsolutePath());
        }
        ClassFilesIndexStorageWriter<K, V> index = null;
        IOException exception = null;
        LOG.debug("start open... " + indexer.getIndexCanonicalName());
        this.myMappings = compileContext.getProjectDescriptor().dataManager.getMappings();
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                index = new ClassFilesIndexStorageWriter<K, V>(storageDir, this.myIndexer.getKeyDescriptor(), this.myIndexer.getDataExternalizer(), this.myMappings);
                break;
            }
            catch (IOException e) {
                exception = e;
                PersistentHashMap.deleteFilesStartingWith((File)ClassFilesIndexStorageBase.getIndexFile(storageDir));
                continue;
            }
        }
        LOG.debug("opened " + indexer.getIndexCanonicalName());
        if (index == null) {
            throw new RuntimeException(exception);
        }
        this.myIndex = index;
        this.myEmpty = IndexState.EXIST != IndexState.load(storageDir) || exception != null;
        IndexState.CORRUPTED.save(storageDir);
    }

    private static Set<String> listFiles(File dir) {
        Object[] containingFileNames = dir.list();
        return containingFileNames == null ? Collections.emptySet() : ContainerUtil.newHashSet((Object[])containingFileNames);
    }

    private File getIndexRoot(CompileContext compileContext) {
        File rootFile = compileContext.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot();
        return ClassFilesIndexStorageBase.getIndexDir(this.myIndexer.getIndexCanonicalName(), rootFile);
    }

    public final boolean isEmpty() {
        return this.myEmpty;
    }

    public final void close(CompileContext compileContext) {
        try {
            this.myIndex.close();
            IndexState.EXIST.save(this.getIndexRoot(compileContext));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void update(String id, ClassReader inputData) {
        for (Map.Entry<K, V> e : this.myIndexer.map(inputData, this.myMappings).entrySet()) {
            this.myIndex.putData(e.getKey(), e.getValue(), id);
        }
    }
}

